import platform


def get_cpu_info():
    """ Returns the contents of /proc/cpuinfo (for the first core) as a dict
    """
    try:
        cpu_info = {}
        with open('/proc/cpuinfo') as f:
            for line in f:
                if not line.strip():  # stop after the first core
                    break
                key, value = line.split(":", 1)
                key = key.strip()
                value = value.strip()
                if value:
                    cpu_info[key] = value
        return cpu_info
    except Exception as e:
        return {"errorReadingCPUInfo": str(e)}


def get_platform_info():
    """ Returns various platform-related strings as a dict
    """
    platform_info = {
        "architecture": list(filter(bool, platform.architecture())),
        "libc": list(filter(bool, platform.libc_ver())),
        "machine": platform.machine(),
        "kernelRelease": platform.release(),
        "kernelVersion": platform.version(),
        "platform": platform.platform(),
        "pythonCompiler": platform.python_compiler(),
        "pythonImplementation": platform.python_implementation(),
        "pythonVersion": platform.python_version(),
        "system": platform.system(),
    }
    return platform_info
