# Python<->Java mapping
from typing import TypedDict
from typing import TypeVar
from typing import TYPE_CHECKING
from typing import Union


class SingleCommandWithId(TypedDict):
    id: str  # manually set on the python-side to track the request in the logs


if TYPE_CHECKING:
    from generated_sources.com.dataiku.dip.connections.hugging_face_local_connection.device_strategy import DeviceStrategy
    from generated_sources.com.dataiku.dip.connections.hugging_face_local_connection.inference_settings import InferenceSettings as ModelSettings
    from generated_sources.com.dataiku.dip.connections.hugging_face_local_connection.tool_settings import ToolSettings
    from generated_sources.com.dataiku.dip.connections.hugging_face_local_connection.chat_template_settings import ChatTemplateSettings
    from generated_sources.com.dataiku.dip.llm.io.commands.process_single_prompt_command.process_single_prompt_command import ProcessSinglePromptCommand as ProcessSinglePromptCommandModel
    from generated_sources.com.dataiku.dip.llm.io.commands.process_single_embedding_command.process_single_embedding_command import ProcessSingleEmbeddingCommand as ProcessSingleEmbeddingCommandModel
    from generated_sources.com.dataiku.dip.llm.io.commands.stream_response_chunk_or_footer.stream_response_chunk_or_footer import StreamResponseChunkOrFooter
    from generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.hugging_face_kernel_command import HuggingFaceKernelCommand
    from generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.start_command import StartCommand
    from generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.collect_tracking_data import CollectTrackingData
    from generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.collect_tracking_data_response import CollectTrackingDataResponse
    from generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.process_single_command import ProcessSingleCommand as ProcessSingleCommandModel
    from generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.process_single_image_generation_command import ProcessSingleImageGenerationCommand as ProcessSingleImageGenerationCommandModel
    from generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.image_generation_kernel_response import ImageGenerationKernelResponse as ProcessSingleImageGenerationResponse
    from generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.zero_shot_classification_response import ZeroShotClassificationResponse
    from generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.process_single_prompt_response import ProcessSinglePromptResponse as ProcessSinglePromptResponseFull
    from generated_sources.com.dataiku.dip.llm.online.llm_client.simple_embedding_response import SimpleEmbeddingResponse as ProcessSingleEmbeddingResponse
    from generated_sources.com.dataiku.dip.llm.online.llm_client.completion_settings import CompletionSettings
    from generated_sources.com.dataiku.dip.llm.online.llm_client.detailed_log_prob import DetailedLogProb
    from generated_sources.com.dataiku.dip.llm.online.llm_client.chat_message import ChatMessage
    from generated_sources.com.dataiku.dip.llm.online.llm_client.chat_message import ChatMessagePart
    from generated_sources.com.dataiku.dip.llm.online.llm_client.streamed_completion_response_chunk import StreamedCompletionResponseChunk
    from generated_sources.com.dataiku.dip.llm.online.llm_client.streamed_completion_response_footer import StreamedCompletionResponseFooter
    from generated_sources.com.dataiku.dip.llm.online.llm_client.tool_choice import ToolChoice
    from generated_sources.com.dataiku.dip.llm.online.llm_client.function_tool_call import FunctionToolCall
    from generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.usage_data import UsageData
    from generated_sources.com.dataiku.dip.llm.online.llm_client.finish_reason import FinishReason
else:
    DeviceStrategy = str

    ModelSettings = str

    class ToolSettings(TypedDict):
        pass

    class ChatTemplateSettings(TypedDict):
        pass

    class HuggingFaceKernelCommand(TypedDict):
        pass

    class StartCommand(TypedDict):
        pass

    class CollectTrackingData(TypedDict):
        pass

    class CollectTrackingDataResponse(TypedDict):
        pass

    class ProcessSingleCommandModel(TypedDict):
        pass

    class ProcessSinglePromptCommandModel(TypedDict):
        pass

    class ProcessSingleEmbeddingCommandModel(TypedDict):
        pass

    class ProcessSingleImageGenerationCommandModel(TypedDict):
        pass

    class ZeroShotClassificationResponse(TypedDict):
        pass

    class ProcessSinglePromptResponseFull(TypedDict):
        pass

    class ProcessSingleEmbeddingResponse(TypedDict):
        pass

    class ProcessSingleImageGenerationResponse(TypedDict):
        pass

    class CompletionSettings(TypedDict):
        pass

    class DetailedLogProb(TypedDict):
        pass

    class ChatMessage(TypedDict):
        pass

    class ChatMessagePart(TypedDict):
        pass

    class ToolChoice(TypedDict):
        pass

    class FunctionToolCall(TypedDict):
        pass

    class UsageData(TypedDict):
        pass

    FinishReason = str

    class StreamedCompletionResponseChunk(TypedDict):
        pass

    class StreamedCompletionResponseFooter(TypedDict):
        pass

    class StreamResponseChunkOrFooter(TypedDict):
        pass

class ProcessSinglePromptCommand(ProcessSinglePromptCommandModel, SingleCommandWithId):
    pass


class ProcessSingleEmbeddingCommand(ProcessSingleEmbeddingCommandModel, SingleCommandWithId):
    pass


class ProcessSingleImageGenerationCommand(ProcessSingleImageGenerationCommandModel, SingleCommandWithId):
    pass


ProcessSingleCommand = Union[ProcessSinglePromptCommand, ProcessSingleEmbeddingCommand, ProcessSingleImageGenerationCommand]
SingleCommand = TypeVar("SingleCommand", bound=ProcessSingleCommand)


class ProcessSinglePromptResponseTextFull(ProcessSinglePromptResponseFull):
    text: str  # type: ignore


class ProcessSinglePromptResponseZeroShotClassification(ProcessSinglePromptResponseFull):
    classification: ZeroShotClassificationResponse  # type: ignore


ProcessSinglePromptResponseText = Union[ProcessSinglePromptResponseTextFull, StreamResponseChunkOrFooter]
ProcessSinglePromptResponse = Union[ProcessSinglePromptResponseText, ProcessSinglePromptResponseZeroShotClassification]
ProcessSingleResponse = Union[ProcessSinglePromptResponse, ProcessSingleEmbeddingResponse, ProcessSingleImageGenerationResponse, CollectTrackingDataResponse]
SingleResponse = TypeVar("SingleResponse", bound=ProcessSingleResponse)
