import xml.etree.ElementTree as ET
from dataiku.apinode import DkuCustomHttpResponse

def api_py_function():
    root = ET.Element("person")
    name = ET.SubElement(root, "name")
    name.text = "John Doe"
    age = ET.SubElement(root, "age")
    age.text = str(42)
    xml_string = ET.tostring(root, encoding="unicode")
    response = DkuCustomHttpResponse.create_text_response(xml_string, content_type="text/xml")
    response.headers["SampleAdditionalHeader"] = "Sample value"
    return response
