from tensorflow.keras.layers import (
    Activation, BatchNormalization, Conv2D, Dense, Dropout, Reshape, Input, MaxPooling2D
)
from tensorflow.keras.models import Model
from numpy import multiply

def build_model(input_shapes, n_classes=None):

    ### DEFINE INPUT AND BASE ARCHITECTURE
    # You need to modify the name and shape of the "image_input" 
    # according to the preprocessing and name of your 
    # initial feature.
    # This feature should be preprocessed as an "Image" with a
    # custom preprocessing.
    image_shape = (197, 197, 3)
    image_input_name = "name_of_your_image_input_preprocessed"

    image_input = Input(shape=image_shape, name=image_input_name)

    ### DEFINE THE ARCHITECTURE
    x = Conv2D(64, kernel_size=(11, 11), padding='same')(image_input)
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = MaxPooling2D(pool_size=(3, 3))(x)

    x = Conv2D(128, kernel_size=(7, 7), padding='same')(x)
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = MaxPooling2D(pool_size=(3, 3))(x)

    x = Conv2D(192, kernel_size=(3, 3), padding='same')(x)
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = MaxPooling2D(pool_size=(3, 3))(x)

    x = Conv2D(256, kernel_size=(3, 3), padding='same')(x)
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = MaxPooling2D(pool_size=(3, 3))(x)

    x = Reshape((multiply.reduce(x.shape[1:]),))(x)
    x = Dense(4096)(x)
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = Dropout(0.2)(x)
    x = Dense(4096)(x)
    x = BatchNormalization()(x)
    x = Activation('relu')(x)
    x = Dropout(0.2)(x)
    x = Dense(n_classes)(x)
    x = BatchNormalization()(x)
    x = Activation('softmax')(x)

    model = Model(inputs=image_input, outputs=x)

    return model

def compile_model(model):
    model.compile(
        optimizer="adam",
        loss="categorical_crossentropy"
    )
    return model