#!/bin/bash -e
# Install a locally-compiled version of Python 3.13 in an AlmaLinux 8 or 9 container image

PYTHON_VERSION="3.13.7"
PYTHON_MD5="138c2e19c835ead10499571e0d4cf189"

TMPDIR="/tmp.build-python313"

source /etc/os-release
case "$VERSION_ID" in
  8*) repo="--enablerepo=powertools" ;;
  9*) repo="--enablerepo=crb" ;;
esac

yum -y --setopt=group_package_types="mandatory" $repo install \
  @development \
  bzip2-devel \
  gdbm-devel \
  libffi-devel \
  libuuid-devel \
  mpdecimal-devel \
  ncurses-devel \
  openssl-devel \
  readline-devel \
  sqlite-devel \
  xz-devel \
  zlib-devel \

mkdir -p "$TMPDIR"
cd "$TMPDIR"

curl -OsS "https://www.python.org/ftp/python/$PYTHON_VERSION/Python-$PYTHON_VERSION.tgz"
echo "$PYTHON_MD5 Python-$PYTHON_VERSION.tgz" | md5sum -c

tar xf Python-"$PYTHON_VERSION".tgz
cd Python-"$PYTHON_VERSION"

./configure --without-static-libpython
make -j 8
make altinstall

# Update built-in packages
/usr/local/bin/python3.13 -m pip install --upgrade pip setuptools

# Remove test module, except test.support which might be needed by additional packages
(cd /usr/local/lib/python3.13/test; ls | grep -vx support | xargs rm -rf)

(cd /usr/local/lib/python3.13 ; find . -depth  -type f -name '*.pyc' -exec rm -f {} \;)

cd /
rm -rf "$TMPDIR"
yum clean all
