// Code for custom code recipe __ID__ (imported from a Spark-Scala recipe)

// To finish creating your custom recipe from your original Spark-Scala recipe, you need to:
//  - Declare the input and output roles in recipe.json
//  - Replace the dataset names by roles access in your code
//  - Declare, if any, the params of your custom recipe in recipe.json
//  - Replace the hardcoded params values by access to the configuration map

// See sample code below for how to do that.
// The code of your original recipe is included afterwards for convenience.
// Please also see the "recipe.json" file for more information.

// import the classes for accessing DSS objects from the recipe
import com.dataiku.dss.spark._
// import Spark classes & utility functions
import org.apache.spark.SparkContext
import org.apache.spark.sql.SQLContext
import org.apache.spark.sql.functions._

// retrieve default SparkConf, create SparkContext & SQLContext, obtain DataikuSparkContext
val sparkConf    = DataikuSparkContext.buildSparkConf()
val sparkContext = new SparkContext(sparkConf)
val sqlContext   = new SQLContext(sparkContext)
val dkuContext   = DataikuSparkContext.getContext(sparkContext).asInstanceOf[DataikuCustomRecipeSparkContext]

// Inputs and outputs are defined by roles. In the recipe's I/O tab, the user can associate one
// or more dataset to each input and output role.
// Roles need to be defined in recipe.json, in the inputRoles and outputRoles fields.

// You can use the role -> input Map[String, List[FlowInput]]
val inputMains = dkuContext.inputsByRole("input_role_main")
// The corresponding dataframes can then be created like this:
val inputMainFrames = inputMains.map(i => dkuContext.getDataFrame(sqlContext, i.smartName))

// Same for output names:
val outputMains = dkuContext.outputsByRole("output_role_main")


// The configuration consists of the parameters set up by the user in the recipe Settings tab.

// Parameters must be added to the recipe.json file so that DSS can prompt the user for values in
// the Settings tab of the recipe. The field "params" holds a list of all the params for wich the
// user will be prompted for values.

// The configuration is simply a Map[String, Any] of parameters, and retrieving the value of one of them is simply:
val myParam = dkuContext.recipeParams("parameter_name")

// For optional parameters, you should either provide a default value or get an option in case the parameter is not present:
val myOptParam1 = dkuContext.recipeParams.getOrElse("parameter_name", "") // default value
val myOptParam2 = dkuContext.recipeParams.get("parameter_name") // Option[Any]


//////////////////////////
// Your original recipe //
//////////////////////////

