/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MapSchemaVersionToSerdeRequest
implements TBase<MapSchemaVersionToSerdeRequest, _Fields>,
Serializable,
Cloneable,
Comparable<MapSchemaVersionToSerdeRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("MapSchemaVersionToSerdeRequest");
    private static final TField SCHEMA_VERSION_FIELD_DESC = new TField("schemaVersion", 12, 1);
    private static final TField SERDE_NAME_FIELD_DESC = new TField("serdeName", 11, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private SchemaVersionDescriptor schemaVersion;
    private String serdeName;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public MapSchemaVersionToSerdeRequest() {
    }

    public MapSchemaVersionToSerdeRequest(SchemaVersionDescriptor schemaVersion, String serdeName) {
        this();
        this.schemaVersion = schemaVersion;
        this.serdeName = serdeName;
    }

    public MapSchemaVersionToSerdeRequest(MapSchemaVersionToSerdeRequest other) {
        if (other.isSetSchemaVersion()) {
            this.schemaVersion = new SchemaVersionDescriptor(other.schemaVersion);
        }
        if (other.isSetSerdeName()) {
            this.serdeName = other.serdeName;
        }
    }

    public MapSchemaVersionToSerdeRequest deepCopy() {
        return new MapSchemaVersionToSerdeRequest(this);
    }

    @Override
    public void clear() {
        this.schemaVersion = null;
        this.serdeName = null;
    }

    public SchemaVersionDescriptor getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(SchemaVersionDescriptor schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void unsetSchemaVersion() {
        this.schemaVersion = null;
    }

    public boolean isSetSchemaVersion() {
        return this.schemaVersion != null;
    }

    public void setSchemaVersionIsSet(boolean value) {
        if (!value) {
            this.schemaVersion = null;
        }
    }

    public String getSerdeName() {
        return this.serdeName;
    }

    public void setSerdeName(String serdeName) {
        this.serdeName = serdeName;
    }

    public void unsetSerdeName() {
        this.serdeName = null;
    }

    public boolean isSetSerdeName() {
        return this.serdeName != null;
    }

    public void setSerdeNameIsSet(boolean value) {
        if (!value) {
            this.serdeName = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case SCHEMA_VERSION: {
                if (value == null) {
                    this.unsetSchemaVersion();
                    break;
                }
                this.setSchemaVersion((SchemaVersionDescriptor)value);
                break;
            }
            case SERDE_NAME: {
                if (value == null) {
                    this.unsetSerdeName();
                    break;
                }
                this.setSerdeName((String)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case SCHEMA_VERSION: {
                return this.getSchemaVersion();
            }
            case SERDE_NAME: {
                return this.getSerdeName();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case SCHEMA_VERSION: {
                return this.isSetSchemaVersion();
            }
            case SERDE_NAME: {
                return this.isSetSerdeName();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof MapSchemaVersionToSerdeRequest) {
            return this.equals((MapSchemaVersionToSerdeRequest)that);
        }
        return false;
    }

    public boolean equals(MapSchemaVersionToSerdeRequest that) {
        if (that == null) {
            return false;
        }
        boolean this_present_schemaVersion = this.isSetSchemaVersion();
        boolean that_present_schemaVersion = that.isSetSchemaVersion();
        if (this_present_schemaVersion || that_present_schemaVersion) {
            if (!this_present_schemaVersion || !that_present_schemaVersion) {
                return false;
            }
            if (!this.schemaVersion.equals(that.schemaVersion)) {
                return false;
            }
        }
        boolean this_present_serdeName = this.isSetSerdeName();
        boolean that_present_serdeName = that.isSetSerdeName();
        if (this_present_serdeName || that_present_serdeName) {
            if (!this_present_serdeName || !that_present_serdeName) {
                return false;
            }
            if (!this.serdeName.equals(that.serdeName)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_schemaVersion = this.isSetSchemaVersion();
        list.add(present_schemaVersion);
        if (present_schemaVersion) {
            list.add(this.schemaVersion);
        }
        boolean present_serdeName = this.isSetSerdeName();
        list.add(present_serdeName);
        if (present_serdeName) {
            list.add(this.serdeName);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(MapSchemaVersionToSerdeRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetSchemaVersion()).compareTo(other.isSetSchemaVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchemaVersion() && (lastComparison = TBaseHelper.compareTo(this.schemaVersion, other.schemaVersion)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSerdeName()).compareTo(other.isSetSerdeName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSerdeName() && (lastComparison = TBaseHelper.compareTo(this.serdeName, other.serdeName)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (MapSchemaVersionToSerdeRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (MapSchemaVersionToSerdeRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MapSchemaVersionToSerdeRequest(");
        boolean first = true;
        sb.append("schemaVersion:");
        if (this.schemaVersion == null) {
            sb.append("null");
        } else {
            sb.append(this.schemaVersion);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("serdeName:");
        if (this.serdeName == null) {
            sb.append("null");
        } else {
            sb.append(this.serdeName);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.schemaVersion != null) {
            this.schemaVersion.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new MapSchemaVersionToSerdeRequestStandardSchemeFactory());
        schemes.put(TupleScheme.class, new MapSchemaVersionToSerdeRequestTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.SCHEMA_VERSION, new FieldMetaData("schemaVersion", 3, new StructMetaData(12, SchemaVersionDescriptor.class)));
        tmpMap.put(_Fields.SERDE_NAME, new FieldMetaData("serdeName", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(MapSchemaVersionToSerdeRequest.class, metaDataMap);
    }

    private static class MapSchemaVersionToSerdeRequestTupleScheme
    extends TupleScheme<MapSchemaVersionToSerdeRequest> {
        private MapSchemaVersionToSerdeRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, MapSchemaVersionToSerdeRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetSchemaVersion()) {
                optionals.set(0);
            }
            if (struct.isSetSerdeName()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetSchemaVersion()) {
                struct.schemaVersion.write(oprot);
            }
            if (struct.isSetSerdeName()) {
                oprot.writeString(struct.serdeName);
            }
        }

        @Override
        public void read(TProtocol prot, MapSchemaVersionToSerdeRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.schemaVersion = new SchemaVersionDescriptor();
                struct.schemaVersion.read(iprot);
                struct.setSchemaVersionIsSet(true);
            }
            if (incoming.get(1)) {
                struct.serdeName = iprot.readString();
                struct.setSerdeNameIsSet(true);
            }
        }
    }

    private static class MapSchemaVersionToSerdeRequestTupleSchemeFactory
    implements SchemeFactory {
        private MapSchemaVersionToSerdeRequestTupleSchemeFactory() {
        }

        public MapSchemaVersionToSerdeRequestTupleScheme getScheme() {
            return new MapSchemaVersionToSerdeRequestTupleScheme();
        }
    }

    private static class MapSchemaVersionToSerdeRequestStandardScheme
    extends StandardScheme<MapSchemaVersionToSerdeRequest> {
        private MapSchemaVersionToSerdeRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, MapSchemaVersionToSerdeRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.schemaVersion = new SchemaVersionDescriptor();
                            struct.schemaVersion.read(iprot);
                            struct.setSchemaVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.serdeName = iprot.readString();
                            struct.setSerdeNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, MapSchemaVersionToSerdeRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.schemaVersion != null) {
                oprot.writeFieldBegin(SCHEMA_VERSION_FIELD_DESC);
                struct.schemaVersion.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.serdeName != null) {
                oprot.writeFieldBegin(SERDE_NAME_FIELD_DESC);
                oprot.writeString(struct.serdeName);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class MapSchemaVersionToSerdeRequestStandardSchemeFactory
    implements SchemeFactory {
        private MapSchemaVersionToSerdeRequestStandardSchemeFactory() {
        }

        public MapSchemaVersionToSerdeRequestStandardScheme getScheme() {
            return new MapSchemaVersionToSerdeRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        SCHEMA_VERSION(1, "schemaVersion"),
        SERDE_NAME(2, "serdeName");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return SCHEMA_VERSION;
                }
                case 2: {
                    return SERDE_NAME;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

