/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.arrow;

import io.netty.buffer.ArrowBuf;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.arrow.ArrowColumnarBatchSerDe;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

class Serializer {
    private final int MAX_BUFFERED_ROWS;
    private final StructTypeInfo structTypeInfo;
    private final int fieldSize;
    private final VectorizedRowBatch vectorizedRowBatch;
    private final VectorAssignRow vectorAssignRow;
    private int batchSize;
    private final NullableMapVector rootVector;

    Serializer(ArrowColumnarBatchSerDe serDe) throws SerDeException {
        this.MAX_BUFFERED_ROWS = HiveConf.getIntVar(serDe.conf, HiveConf.ConfVars.HIVE_ARROW_BATCH_SIZE);
        ArrowColumnarBatchSerDe.LOG.info("ArrowColumnarBatchSerDe max number of buffered columns: " + this.MAX_BUFFERED_ROWS);
        this.structTypeInfo = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(serDe.rowObjectInspector);
        ArrayList<TypeInfo> fieldTypeInfos = this.structTypeInfo.getAllStructFieldTypeInfos();
        this.fieldSize = fieldTypeInfos.size();
        this.rootVector = NullableMapVector.empty(null, (BufferAllocator)serDe.rootAllocator);
        this.vectorizedRowBatch = new VectorizedRowBatch(this.fieldSize);
        for (int fieldIndex = 0; fieldIndex < this.fieldSize; ++fieldIndex) {
            ColumnVector columnVector;
            this.vectorizedRowBatch.cols[fieldIndex] = columnVector = VectorizedBatchUtil.createColumnVector((TypeInfo)fieldTypeInfos.get(fieldIndex));
            columnVector.init();
        }
        this.vectorizedRowBatch.ensureSize(this.MAX_BUFFERED_ROWS);
        this.vectorAssignRow = new VectorAssignRow();
        try {
            this.vectorAssignRow.init(serDe.rowObjectInspector);
        }
        catch (HiveException e) {
            throw new SerDeException(e);
        }
    }

    private ArrowWrapperWritable serializeBatch() {
        this.rootVector.setValueCount(0);
        for (int fieldIndex = 0; fieldIndex < this.vectorizedRowBatch.projectionSize; ++fieldIndex) {
            int projectedColumn = this.vectorizedRowBatch.projectedColumns[fieldIndex];
            ColumnVector hiveVector = this.vectorizedRowBatch.cols[projectedColumn];
            TypeInfo fieldTypeInfo = this.structTypeInfo.getAllStructFieldTypeInfos().get(fieldIndex);
            String fieldName = this.structTypeInfo.getAllStructFieldNames().get(fieldIndex);
            FieldType fieldType = this.toFieldType(fieldTypeInfo);
            FieldVector arrowVector = this.rootVector.addOrGet(fieldName, fieldType, FieldVector.class);
            arrowVector.setInitialCapacity(this.batchSize);
            arrowVector.allocateNew();
            this.write(arrowVector, hiveVector, fieldTypeInfo, this.batchSize);
        }
        this.vectorizedRowBatch.reset();
        this.rootVector.setValueCount(this.batchSize);
        this.batchSize = 0;
        VectorSchemaRoot vectorSchemaRoot = new VectorSchemaRoot((FieldVector)this.rootVector);
        return new ArrowWrapperWritable(vectorSchemaRoot);
    }

    private FieldType toFieldType(TypeInfo typeInfo) {
        return new FieldType(true, this.toArrowType(typeInfo), null);
    }

    private ArrowType toArrowType(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return Types.MinorType.BIT.getType();
                    }
                    case BYTE: {
                        return Types.MinorType.TINYINT.getType();
                    }
                    case SHORT: {
                        return Types.MinorType.SMALLINT.getType();
                    }
                    case INT: {
                        return Types.MinorType.INT.getType();
                    }
                    case LONG: {
                        return Types.MinorType.BIGINT.getType();
                    }
                    case FLOAT: {
                        return Types.MinorType.FLOAT4.getType();
                    }
                    case DOUBLE: {
                        return Types.MinorType.FLOAT8.getType();
                    }
                    case STRING: 
                    case VARCHAR: 
                    case CHAR: {
                        return Types.MinorType.VARCHAR.getType();
                    }
                    case DATE: {
                        return Types.MinorType.DATEDAY.getType();
                    }
                    case TIMESTAMP: {
                        return new ArrowType.Timestamp(TimeUnit.MICROSECOND, "UTC");
                    }
                    case BINARY: {
                        return Types.MinorType.VARBINARY.getType();
                    }
                    case DECIMAL: {
                        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                        return new ArrowType.Decimal(decimalTypeInfo.precision(), decimalTypeInfo.scale());
                    }
                    case INTERVAL_YEAR_MONTH: {
                        return Types.MinorType.INTERVALYEAR.getType();
                    }
                    case INTERVAL_DAY_TIME: {
                        return Types.MinorType.INTERVALDAY.getType();
                    }
                }
                throw new IllegalArgumentException();
            }
            case LIST: {
                return ArrowType.List.INSTANCE;
            }
            case STRUCT: {
                return ArrowType.Struct.INSTANCE;
            }
            case MAP: {
                return ArrowType.List.INSTANCE;
            }
        }
        throw new IllegalArgumentException();
    }

    private void write(FieldVector arrowVector, ColumnVector hiveVector, TypeInfo typeInfo, int size) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                this.writePrimitive(arrowVector, hiveVector, typeInfo, size);
                break;
            }
            case LIST: {
                this.writeList((ListVector)arrowVector, (ListColumnVector)hiveVector, (ListTypeInfo)typeInfo, size);
                break;
            }
            case STRUCT: {
                this.writeStruct((MapVector)arrowVector, (StructColumnVector)hiveVector, (StructTypeInfo)typeInfo, size);
                break;
            }
            case UNION: {
                this.writeUnion(arrowVector, hiveVector, typeInfo, size);
                break;
            }
            case MAP: {
                this.writeMap((ListVector)arrowVector, (MapColumnVector)hiveVector, (MapTypeInfo)typeInfo, size);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void writeMap(ListVector arrowVector, MapColumnVector hiveVector, MapTypeInfo typeInfo, int size) {
        ListTypeInfo structListTypeInfo = ArrowColumnarBatchSerDe.toStructListTypeInfo(typeInfo);
        ListColumnVector structListVector = ArrowColumnarBatchSerDe.toStructListVector(hiveVector);
        this.write((FieldVector)arrowVector, structListVector, structListTypeInfo, size);
        ArrowBuf validityBuffer = arrowVector.getValidityBuffer();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            if (hiveVector.isNull[rowIndex]) {
                BitVectorHelper.setValidityBit((ArrowBuf)validityBuffer, (int)rowIndex, (int)0);
                continue;
            }
            BitVectorHelper.setValidityBitToOne((ArrowBuf)validityBuffer, (int)rowIndex);
        }
    }

    private void writeUnion(FieldVector arrowVector, ColumnVector hiveVector, TypeInfo typeInfo, int size) {
        UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
        List<TypeInfo> objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
        UnionColumnVector hiveUnionVector = (UnionColumnVector)hiveVector;
        ColumnVector[] hiveObjectVectors = hiveUnionVector.fields;
        int tag = hiveUnionVector.tags[0];
        ColumnVector hiveObjectVector = hiveObjectVectors[tag];
        TypeInfo objectTypeInfo = objectTypeInfos.get(tag);
        this.write(arrowVector, hiveObjectVector, objectTypeInfo, size);
    }

    private void writeStruct(MapVector arrowVector, StructColumnVector hiveVector, StructTypeInfo typeInfo, int size) {
        ArrayList<String> fieldNames = typeInfo.getAllStructFieldNames();
        ArrayList<TypeInfo> fieldTypeInfos = typeInfo.getAllStructFieldTypeInfos();
        ColumnVector[] hiveFieldVectors = hiveVector.fields;
        int fieldSize = fieldTypeInfos.size();
        for (int fieldIndex = 0; fieldIndex < fieldSize; ++fieldIndex) {
            TypeInfo fieldTypeInfo = (TypeInfo)fieldTypeInfos.get(fieldIndex);
            ColumnVector hiveFieldVector = hiveFieldVectors[fieldIndex];
            String fieldName = (String)fieldNames.get(fieldIndex);
            FieldVector arrowFieldVector = arrowVector.addOrGet(fieldName, this.toFieldType((TypeInfo)fieldTypeInfos.get(fieldIndex)), FieldVector.class);
            arrowFieldVector.setInitialCapacity(size);
            arrowFieldVector.allocateNew();
            this.write(arrowFieldVector, hiveFieldVector, fieldTypeInfo, size);
        }
        ArrowBuf validityBuffer = arrowVector.getValidityBuffer();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            if (hiveVector.isNull[rowIndex]) {
                BitVectorHelper.setValidityBit((ArrowBuf)validityBuffer, (int)rowIndex, (int)0);
                continue;
            }
            BitVectorHelper.setValidityBitToOne((ArrowBuf)validityBuffer, (int)rowIndex);
        }
    }

    private void writeList(ListVector arrowVector, ListColumnVector hiveVector, ListTypeInfo typeInfo, int size) {
        int OFFSET_WIDTH = 4;
        TypeInfo elementTypeInfo = typeInfo.getListElementTypeInfo();
        ColumnVector hiveElementVector = hiveVector.child;
        FieldVector arrowElementVector = (FieldVector)arrowVector.addOrGetVector(this.toFieldType(elementTypeInfo)).getVector();
        arrowElementVector.setInitialCapacity(hiveVector.childCount);
        arrowElementVector.allocateNew();
        this.write(arrowElementVector, hiveElementVector, elementTypeInfo, hiveVector.childCount);
        ArrowBuf offsetBuffer = arrowVector.getOffsetBuffer();
        int nextOffset = 0;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            if (hiveVector.isNull[rowIndex]) {
                offsetBuffer.setInt(rowIndex * 4, nextOffset);
                continue;
            }
            offsetBuffer.setInt(rowIndex * 4, nextOffset);
            nextOffset += (int)hiveVector.lengths[rowIndex];
            arrowVector.setNotNull(rowIndex);
        }
        offsetBuffer.setInt(size * 4, nextOffset);
    }

    private void writePrimitive(FieldVector arrowVector, ColumnVector hiveVector, TypeInfo typeInfo, int size) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        switch (primitiveCategory) {
            case BOOLEAN: {
                BitVector bitVector = (BitVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        bitVector.setNull(i);
                        continue;
                    }
                    bitVector.set(i, (int)((LongColumnVector)hiveVector).vector[i]);
                }
                break;
            }
            case BYTE: {
                TinyIntVector tinyIntVector = (TinyIntVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        tinyIntVector.setNull(i);
                        continue;
                    }
                    tinyIntVector.set(i, (byte)((LongColumnVector)hiveVector).vector[i]);
                }
                break;
            }
            case SHORT: {
                SmallIntVector smallIntVector = (SmallIntVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        smallIntVector.setNull(i);
                        continue;
                    }
                    smallIntVector.set(i, (short)((LongColumnVector)hiveVector).vector[i]);
                }
                break;
            }
            case INT: {
                IntVector intVector = (IntVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        intVector.setNull(i);
                        continue;
                    }
                    intVector.set(i, (int)((LongColumnVector)hiveVector).vector[i]);
                }
                break;
            }
            case LONG: {
                BigIntVector bigIntVector = (BigIntVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        bigIntVector.setNull(i);
                        continue;
                    }
                    bigIntVector.set(i, ((LongColumnVector)hiveVector).vector[i]);
                }
                break;
            }
            case FLOAT: {
                Float4Vector float4Vector = (Float4Vector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        float4Vector.setNull(i);
                        continue;
                    }
                    float4Vector.set(i, (float)((DoubleColumnVector)hiveVector).vector[i]);
                }
                break;
            }
            case DOUBLE: {
                Float8Vector float8Vector = (Float8Vector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        float8Vector.setNull(i);
                        continue;
                    }
                    float8Vector.set(i, ((DoubleColumnVector)hiveVector).vector[i]);
                }
                break;
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                VarCharVector varCharVector = (VarCharVector)arrowVector;
                BytesColumnVector bytesVector = (BytesColumnVector)hiveVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        varCharVector.setNull(i);
                        continue;
                    }
                    varCharVector.setSafe(i, bytesVector.vector[i], bytesVector.start[i], bytesVector.length[i]);
                }
                break;
            }
            case DATE: {
                DateDayVector dateDayVector = (DateDayVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        dateDayVector.setNull(i);
                        continue;
                    }
                    dateDayVector.set(i, (int)((LongColumnVector)hiveVector).vector[i]);
                }
                break;
            }
            case TIMESTAMP: {
                TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)arrowVector;
                TimestampColumnVector timestampColumnVector = (TimestampColumnVector)hiveVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        timeStampMicroTZVector.setNull(i);
                        continue;
                    }
                    long secondInMillis = timestampColumnVector.getTime(i);
                    long secondInMicros = (secondInMillis - secondInMillis % 1000L) * 1000L;
                    long subSecondInMicros = timestampColumnVector.getNanos(i) / 1000;
                    if (secondInMillis > 0L && secondInMicros < 0L || secondInMillis < 0L && secondInMicros > 0L) {
                        timeStampMicroTZVector.setNull(i);
                        continue;
                    }
                    timeStampMicroTZVector.set(i, secondInMicros + subSecondInMicros);
                }
                break;
            }
            case BINARY: {
                VarBinaryVector varBinaryVector = (VarBinaryVector)arrowVector;
                BytesColumnVector bytesVector = (BytesColumnVector)hiveVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        varBinaryVector.setNull(i);
                        continue;
                    }
                    varBinaryVector.setSafe(i, bytesVector.vector[i], bytesVector.start[i], bytesVector.length[i]);
                }
                break;
            }
            case DECIMAL: {
                DecimalVector decimalVector = (DecimalVector)arrowVector;
                int scale = decimalVector.getScale();
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        decimalVector.setNull(i);
                        continue;
                    }
                    decimalVector.set(i, ((DecimalColumnVector)hiveVector).vector[i].getHiveDecimal().bigDecimalValue().setScale(scale));
                }
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                IntervalYearVector intervalYearVector = (IntervalYearVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        intervalYearVector.setNull(i);
                        continue;
                    }
                    intervalYearVector.set(i, (int)((LongColumnVector)hiveVector).vector[i]);
                }
                break;
            }
            case INTERVAL_DAY_TIME: {
                IntervalDayVector intervalDayVector = (IntervalDayVector)arrowVector;
                IntervalDayTimeColumnVector intervalDayTimeColumnVector = (IntervalDayTimeColumnVector)hiveVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        intervalDayVector.setNull(i);
                        continue;
                    }
                    long totalSeconds = intervalDayTimeColumnVector.getTotalSeconds(i);
                    long days = totalSeconds / 86400L;
                    long millis = (totalSeconds - days * 86400L) * 1000L + intervalDayTimeColumnVector.getNanos(i) / 1000000L;
                    intervalDayVector.set(i, (int)days, (int)millis);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    ArrowWrapperWritable serialize(Object obj, ObjectInspector objInspector) {
        if (obj == null) {
            return this.serializeBatch();
        }
        ArrayList<Object> standardObjects = new ArrayList<Object>();
        ObjectInspectorUtils.copyToStandardObject(standardObjects, obj, (StructObjectInspector)objInspector, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        this.vectorAssignRow.assignRow(this.vectorizedRowBatch, this.batchSize, standardObjects, this.fieldSize);
        ++this.batchSize;
        if (this.batchSize == this.MAX_BUFFERED_ROWS) {
            return this.serializeBatch();
        }
        return null;
    }
}

