/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)"hive.ql.metadata.Table");
    private org.apache.hadoop.hive.metastore.api.Table tTable;
    private Deserializer deserializer;
    private Class<? extends OutputFormat> outputFormatClass;
    private Class<? extends InputFormat> inputFormatClass;
    private Path path;
    private transient HiveStorageHandler storageHandler;
    private transient BaseSemanticAnalyzer.TableSpec tableSpec;
    private transient boolean materializedTable;

    public Table() {
    }

    public Table(org.apache.hadoop.hive.metastore.api.Table table) {
        this.initialize(table);
    }

    protected void initialize(org.apache.hadoop.hive.metastore.api.Table table) {
        this.tTable = table;
    }

    public Table(String databaseName, String tableName) {
        this(Table.getEmptyTable(databaseName, tableName));
    }

    public boolean isDummyTable() {
        return this.tTable.getTableName().equals("_dummy_table");
    }

    public org.apache.hadoop.hive.metastore.api.Table getTTable() {
        return this.tTable;
    }

    public void setTTable(org.apache.hadoop.hive.metastore.api.Table tTable) {
        this.tTable = tTable;
    }

    public static org.apache.hadoop.hive.metastore.api.Table getEmptyTable(String databaseName, String tableName) {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setSerdeInfo(new SerDeInfo());
        sd.setNumBuckets(-1);
        sd.setBucketCols(new ArrayList<String>());
        sd.setCols(new ArrayList<FieldSchema>());
        sd.setParameters(new HashMap<String, String>());
        sd.setSortCols(new ArrayList<Order>());
        sd.getSerdeInfo().setParameters(new HashMap<String, String>());
        sd.getSerdeInfo().setSerializationLib(MetadataTypedColumnsetSerDe.class.getName());
        sd.getSerdeInfo().getParameters().put("serialization.format", "1");
        sd.setInputFormat(SequenceFileInputFormat.class.getName());
        sd.setOutputFormat(HiveSequenceFileOutputFormat.class.getName());
        SkewedInfo skewInfo = new SkewedInfo();
        skewInfo.setSkewedColNames(new ArrayList<String>());
        skewInfo.setSkewedColValues(new ArrayList<List<String>>());
        skewInfo.setSkewedColValueLocationMaps(new HashMap<List<String>, String>());
        sd.setSkewedInfo(skewInfo);
        org.apache.hadoop.hive.metastore.api.Table t = new org.apache.hadoop.hive.metastore.api.Table();
        t.setSd(sd);
        t.setPartitionKeys(new ArrayList<FieldSchema>());
        t.setParameters(new HashMap<String, String>());
        t.setTableType(TableType.MANAGED_TABLE.toString());
        t.setDbName(databaseName);
        t.setTableName(tableName);
        t.setOwner(SessionState.getUserFromAuthenticator());
        t.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        t.getParameters().put("bucketing_version", "2");
        return t;
    }

    public void checkValidity(Configuration conf) throws HiveException {
        String name = this.tTable.getTableName();
        if (null == name || name.length() == 0 || !MetaStoreUtils.validateName(name, conf)) {
            throw new HiveException("[" + name + "]: is not a valid table name");
        }
        if (0 == this.getCols().size()) {
            throw new HiveException("at least one column must be specified for the table");
        }
        if (!this.isView()) {
            if (null == this.getDeserializerFromMetaStore(false)) {
                throw new HiveException("must specify a non-null serDe");
            }
            if (null == this.getInputFormatClass()) {
                throw new HiveException("must specify an InputFormat class");
            }
            if (null == this.getOutputFormatClass()) {
                throw new HiveException("must specify an OutputFormat class");
            }
        }
        if (this.isView() || this.isMaterializedView()) {
            assert (this.getViewOriginalText() != null);
            assert (this.getViewExpandedText() != null);
        } else {
            assert (this.getViewOriginalText() == null);
            assert (this.getViewExpandedText() == null);
        }
        Table.validateColumns(this.getCols(), this.getPartCols());
    }

    public StorageDescriptor getSd() {
        return this.tTable.getSd();
    }

    public void setInputFormatClass(Class<? extends InputFormat> inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
        this.tTable.getSd().setInputFormat(inputFormatClass.getName());
    }

    public void setOutputFormatClass(Class<? extends OutputFormat> outputFormatClass) {
        this.outputFormatClass = outputFormatClass;
        this.tTable.getSd().setOutputFormat(outputFormatClass.getName());
    }

    public final Properties getMetadata() {
        return MetaStoreUtils.getTableMetadata(this.tTable);
    }

    public final Path getPath() {
        String location = this.tTable.getSd().getLocation();
        if (location == null) {
            return null;
        }
        return new Path(location);
    }

    public final String getTableName() {
        return this.tTable.getTableName();
    }

    public final Path getDataLocation() {
        if (this.path == null) {
            this.path = this.getPath();
        }
        return this.path;
    }

    public final Deserializer getDeserializer() {
        if (this.deserializer == null) {
            this.deserializer = this.getDeserializerFromMetaStore(false);
        }
        return this.deserializer;
    }

    public final Class<? extends Deserializer> getDeserializerClass() throws Exception {
        return HiveMetaStoreUtils.getDeserializerClass(SessionState.getSessionConf(), this.tTable);
    }

    public final Deserializer getDeserializer(boolean skipConfError) {
        if (this.deserializer == null) {
            this.deserializer = this.getDeserializerFromMetaStore(skipConfError);
        }
        return this.deserializer;
    }

    public final Deserializer getDeserializerFromMetaStore(boolean skipConfError) {
        try {
            return HiveMetaStoreUtils.getDeserializer((Configuration)SessionState.getSessionConf(), this.tTable, skipConfError);
        }
        catch (MetaException e) {
            throw new RuntimeException(e);
        }
    }

    public HiveStorageHandler getStorageHandler() {
        if (this.storageHandler != null || !this.isNonNative()) {
            return this.storageHandler;
        }
        try {
            this.storageHandler = HiveUtils.getStorageHandler(SessionState.getSessionConf(), this.getProperty("storage_handler"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.storageHandler;
    }

    public final Class<? extends InputFormat> getInputFormatClass() {
        if (this.inputFormatClass == null) {
            try {
                String className = this.tTable.getSd().getInputFormat();
                if (className == null) {
                    if (this.getStorageHandler() == null) {
                        return null;
                    }
                    this.inputFormatClass = this.getStorageHandler().getInputFormatClass();
                } else {
                    this.inputFormatClass = Class.forName(className, true, Utilities.getSessionSpecifiedClassLoader());
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.inputFormatClass;
    }

    public final Class<? extends OutputFormat> getOutputFormatClass() {
        if (this.outputFormatClass == null) {
            try {
                Class<Object> c;
                String className = this.tTable.getSd().getOutputFormat();
                if (className == null) {
                    if (this.getStorageHandler() == null) {
                        return null;
                    }
                    c = this.getStorageHandler().getOutputFormatClass();
                } else {
                    c = Class.forName(className, true, Utilities.getSessionSpecifiedClassLoader());
                }
                this.outputFormatClass = HiveFileFormatUtils.getOutputFormatSubstitute(c);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.outputFormatClass;
    }

    public boolean isMaterializedTable() {
        return this.materializedTable;
    }

    public void setMaterializedTable(boolean materializedTable) {
        this.materializedTable = materializedTable;
    }

    public final void validatePartColumnNames(Map<String, String> spec, boolean shouldBeFull) throws SemanticException {
        List<FieldSchema> partCols = this.tTable.getPartitionKeys();
        String tableName = Warehouse.getQualifiedName(this.tTable);
        if (partCols == null || partCols.size() == 0) {
            if (spec != null) {
                throw new ValidationFailureSemanticException(tableName + " table is not partitioned but partition spec exists: " + spec);
            }
            return;
        }
        if (spec == null) {
            if (shouldBeFull) {
                throw new ValidationFailureSemanticException(tableName + " table is partitioned but partition spec is not specified");
            }
            return;
        }
        int columnsFound = 0;
        for (FieldSchema fs : partCols) {
            if (spec.containsKey(fs.getName())) {
                ++columnsFound;
            }
            if (columnsFound != spec.size()) continue;
            break;
        }
        if (columnsFound < spec.size()) {
            throw new ValidationFailureSemanticException(tableName + ": Partition spec " + spec + " contains non-partition columns");
        }
        if (shouldBeFull && spec.size() != partCols.size()) {
            throw new ValidationFailureSemanticException(tableName + ": partition spec " + spec + " doesn't contain all (" + partCols.size() + ") partition columns");
        }
    }

    public void setProperty(String name, String value) {
        this.tTable.getParameters().put(name, value);
    }

    public void setParameters(Map<String, String> params) {
        this.tTable.setParameters(params);
    }

    public String getProperty(String name) {
        return this.tTable.getParameters().get(name);
    }

    public boolean isImmutable() {
        return this.tTable.getParameters().containsKey("immutable") && this.tTable.getParameters().get("immutable").equalsIgnoreCase("true");
    }

    public void setTableType(TableType tableType) {
        this.tTable.setTableType(tableType.toString());
    }

    public TableType getTableType() {
        return Enum.valueOf(TableType.class, this.tTable.getTableType());
    }

    public ArrayList<StructField> getFields() {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        try {
            Deserializer decoder = this.getDeserializer();
            StructObjectInspector structObjectInspector = (StructObjectInspector)decoder.getObjectInspector();
            List<? extends StructField> fld_lst = structObjectInspector.getAllStructFieldRefs();
            for (StructField structField : fld_lst) {
                fields.add(structField);
            }
        }
        catch (SerDeException e) {
            throw new RuntimeException(e);
        }
        return fields;
    }

    public StructField getField(String fld) {
        try {
            StructObjectInspector structObjectInspector = (StructObjectInspector)this.getDeserializer().getObjectInspector();
            return structObjectInspector.getStructFieldRef(fld);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getBucketingVersion() {
        return Utilities.getBucketingVersion(this.getProperty("bucketing_version"));
    }

    public String toString() {
        return this.tTable.getTableName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tTable == null ? 0 : this.tTable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Table other = (Table)obj;
        return !(this.tTable == null ? other.tTable != null : !this.tTable.equals(other.tTable));
    }

    public List<FieldSchema> getPartCols() {
        List<FieldSchema> partKeys = this.tTable.getPartitionKeys();
        if (partKeys == null) {
            partKeys = new ArrayList<FieldSchema>();
            this.tTable.setPartitionKeys(partKeys);
        }
        return partKeys;
    }

    public FieldSchema getPartColByName(String colName) {
        for (FieldSchema key : this.getPartCols()) {
            if (!key.getName().toLowerCase().equals(colName)) continue;
            return key;
        }
        return null;
    }

    public List<String> getPartColNames() {
        ArrayList<String> partColNames = new ArrayList<String>();
        for (FieldSchema key : this.getPartCols()) {
            partColNames.add(key.getName());
        }
        return partColNames;
    }

    public boolean isPartitionKey(String colName) {
        return this.getPartColByName(colName) != null;
    }

    public String getBucketingDimensionId() {
        List<String> bcols = this.tTable.getSd().getBucketCols();
        if (bcols == null || bcols.size() == 0) {
            return null;
        }
        if (bcols.size() > 1) {
            LOG.warn(this + " table has more than one dimensions which aren't supported yet");
        }
        return bcols.get(0);
    }

    public void setDataLocation(Path path) {
        this.path = path;
        this.tTable.getSd().setLocation(path.toString());
    }

    public void unsetDataLocation() {
        this.path = null;
        this.tTable.getSd().unsetLocation();
    }

    public void setBucketCols(List<String> bucketCols) throws HiveException {
        if (bucketCols == null) {
            return;
        }
        for (String col : bucketCols) {
            if (this.isField(col)) continue;
            throw new HiveException("Bucket columns " + col + " is not part of the table columns (" + this.getCols());
        }
        this.tTable.getSd().setBucketCols(bucketCols);
    }

    public void setSortCols(List<Order> sortOrder) throws HiveException {
        this.tTable.getSd().setSortCols(sortOrder);
    }

    public void setSkewedValueLocationMap(List<String> valList, String dirName) throws HiveException {
        Map<List<String>, String> mappings = this.tTable.getSd().getSkewedInfo().getSkewedColValueLocationMaps();
        if (null == mappings) {
            mappings = new HashMap<List<String>, String>();
            this.tTable.getSd().getSkewedInfo().setSkewedColValueLocationMaps(mappings);
        }
        mappings.put(valList, dirName);
    }

    public Map<List<String>, String> getSkewedColValueLocationMaps() {
        return this.tTable.getSd().getSkewedInfo() != null ? this.tTable.getSd().getSkewedInfo().getSkewedColValueLocationMaps() : new HashMap<List<String>, String>();
    }

    public void setSkewedColValues(List<List<String>> skewedValues) throws HiveException {
        this.tTable.getSd().getSkewedInfo().setSkewedColValues(skewedValues);
    }

    public List<List<String>> getSkewedColValues() {
        return this.tTable.getSd().getSkewedInfo() != null ? this.tTable.getSd().getSkewedInfo().getSkewedColValues() : new ArrayList<List<String>>();
    }

    public void setSkewedColNames(List<String> skewedColNames) throws HiveException {
        this.tTable.getSd().getSkewedInfo().setSkewedColNames(skewedColNames);
    }

    public List<String> getSkewedColNames() {
        return this.tTable.getSd().getSkewedInfo() != null ? this.tTable.getSd().getSkewedInfo().getSkewedColNames() : new ArrayList<String>();
    }

    public SkewedInfo getSkewedInfo() {
        return this.tTable.getSd().getSkewedInfo();
    }

    public void setSkewedInfo(SkewedInfo skewedInfo) throws HiveException {
        this.tTable.getSd().setSkewedInfo(skewedInfo);
    }

    public boolean isStoredAsSubDirectories() {
        return this.tTable.getSd().isStoredAsSubDirectories();
    }

    public void setStoredAsSubDirectories(boolean storedAsSubDirectories) throws HiveException {
        this.tTable.getSd().setStoredAsSubDirectories(storedAsSubDirectories);
    }

    private boolean isField(String col) {
        for (FieldSchema field : this.getCols()) {
            if (!field.getName().equals(col)) continue;
            return true;
        }
        return false;
    }

    public List<FieldSchema> getCols() {
        return this.getColsInternal(false);
    }

    public List<FieldSchema> getColsForMetastore() {
        return this.getColsInternal(true);
    }

    private List<FieldSchema> getColsInternal(boolean forMs) {
        String serializationLib = this.getSerializationLib();
        try {
            if (Table.hasMetastoreBasedSchema(SessionState.getSessionConf(), serializationLib)) {
                return this.tTable.getSd().getCols();
            }
            if (forMs && !Table.shouldStoreFieldsInMetastore(SessionState.getSessionConf(), serializationLib, this.tTable.getParameters())) {
                return Hive.getFieldsFromDeserializerForMsStorage(this, this.getDeserializer());
            }
            return HiveMetaStoreUtils.getFieldsFromDeserializer(this.getTableName(), this.getDeserializer());
        }
        catch (Exception e) {
            LOG.error("Unable to get field from serde: " + serializationLib, (Throwable)e);
            return new ArrayList<FieldSchema>();
        }
    }

    public List<FieldSchema> getAllCols() {
        ArrayList<FieldSchema> f_list = new ArrayList<FieldSchema>();
        f_list.addAll(this.getCols());
        f_list.addAll(this.getPartCols());
        return f_list;
    }

    public void setPartCols(List<FieldSchema> partCols) {
        this.tTable.setPartitionKeys(partCols);
    }

    public String getCatName() {
        return this.tTable.getCatName();
    }

    public String getDbName() {
        return this.tTable.getDbName();
    }

    public int getNumBuckets() {
        return this.tTable.getSd().getNumBuckets();
    }

    public void setInputFormatClass(String name) throws HiveException {
        if (name == null) {
            this.inputFormatClass = null;
            this.tTable.getSd().setInputFormat(null);
            return;
        }
        try {
            this.setInputFormatClass(Class.forName(name, true, Utilities.getSessionSpecifiedClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Class not found: " + name, e);
        }
    }

    public void setOutputFormatClass(String name) throws HiveException {
        if (name == null) {
            this.outputFormatClass = null;
            this.tTable.getSd().setOutputFormat(null);
            return;
        }
        try {
            Class<?> origin = Class.forName(name, true, Utilities.getSessionSpecifiedClassLoader());
            this.setOutputFormatClass(HiveFileFormatUtils.getOutputFormatSubstitute(origin));
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Class not found: " + name, e);
        }
    }

    public boolean isPartitioned() {
        if (this.getPartCols() == null) {
            return false;
        }
        return this.getPartCols().size() != 0;
    }

    public void setFields(List<FieldSchema> fields) {
        this.tTable.getSd().setCols(fields);
    }

    public void setNumBuckets(int nb) {
        this.tTable.getSd().setNumBuckets(nb);
    }

    public String getOwner() {
        return this.tTable.getOwner();
    }

    public PrincipalType getOwnerType() {
        return this.tTable.getOwnerType();
    }

    public Map<String, String> getParameters() {
        return this.tTable.getParameters();
    }

    public int getRetention() {
        return this.tTable.getRetention();
    }

    public void setOwner(String owner) {
        this.tTable.setOwner(owner);
    }

    public void setOwnerType(PrincipalType ownerType) {
        this.tTable.setOwnerType(ownerType);
    }

    public void setRetention(int retention) {
        this.tTable.setRetention(retention);
    }

    private SerDeInfo getSerdeInfo() {
        return this.tTable.getSd().getSerdeInfo();
    }

    public void setSerializationLib(String lib) {
        this.getSerdeInfo().setSerializationLib(lib);
    }

    public String getSerializationLib() {
        return this.getSerdeInfo().getSerializationLib();
    }

    public String getSerdeParam(String param) {
        return this.getSerdeInfo().getParameters().get(param);
    }

    public String setSerdeParam(String param, String value) {
        return this.getSerdeInfo().getParameters().put(param, value);
    }

    public List<String> getBucketCols() {
        return this.tTable.getSd().getBucketCols();
    }

    public List<Order> getSortCols() {
        return this.tTable.getSd().getSortCols();
    }

    public void setTableName(String tableName) {
        this.tTable.setTableName(tableName);
    }

    public void setDbName(String databaseName) {
        this.tTable.setDbName(databaseName);
    }

    public List<FieldSchema> getPartitionKeys() {
        return this.tTable.getPartitionKeys();
    }

    public String getViewOriginalText() {
        return this.tTable.getViewOriginalText();
    }

    public void setViewOriginalText(String viewOriginalText) {
        this.tTable.setViewOriginalText(viewOriginalText);
    }

    public String getViewExpandedText() {
        return this.tTable.getViewExpandedText();
    }

    public void setViewExpandedText(String viewExpandedText) {
        this.tTable.setViewExpandedText(viewExpandedText);
    }

    public boolean isRewriteEnabled() {
        return this.tTable.isRewriteEnabled();
    }

    public void setRewriteEnabled(boolean rewriteEnabled) {
        this.tTable.setRewriteEnabled(rewriteEnabled);
    }

    public CreationMetadata getCreationMetadata() {
        return this.tTable.getCreationMetadata();
    }

    public void setCreationMetadata(CreationMetadata creationMetadata) {
        this.tTable.setCreationMetadata(creationMetadata);
    }

    public void clearSerDeInfo() {
        this.tTable.getSd().getSerdeInfo().getParameters().clear();
    }

    public boolean isView() {
        return TableType.VIRTUAL_VIEW.equals((Object)this.getTableType());
    }

    public boolean isMaterializedView() {
        return TableType.MATERIALIZED_VIEW.equals((Object)this.getTableType());
    }

    public LinkedHashMap<String, String> createSpec(Partition tp) {
        List<FieldSchema> fsl = this.getPartCols();
        List<String> tpl = tp.getValues();
        LinkedHashMap<String, String> spec = new LinkedHashMap<String, String>(fsl.size());
        for (int i = 0; i < fsl.size(); ++i) {
            FieldSchema fs = fsl.get(i);
            String value = tpl.get(i);
            spec.put(fs.getName(), value);
        }
        return spec;
    }

    public Table copy() throws HiveException {
        return new Table(this.tTable.deepCopy());
    }

    public int getCreateTime() {
        return this.tTable.getCreateTime();
    }

    public void setCreateTime(int createTime) {
        this.tTable.setCreateTime(createTime);
    }

    public int getLastAccessTime() {
        return this.tTable.getLastAccessTime();
    }

    public void setLastAccessTime(int lastAccessTime) {
        this.tTable.setLastAccessTime(lastAccessTime);
    }

    public boolean isNonNative() {
        return this.getProperty("storage_handler") != null;
    }

    public String getFullyQualifiedName() {
        return Warehouse.getQualifiedName(this.tTable);
    }

    public String getCompleteName() {
        return Table.getCompleteName(this.getDbName(), this.getTableName());
    }

    public static String getCompleteName(String dbName, String tabName) {
        return dbName + "@" + tabName;
    }

    public FileStatus[] getSortedPaths() {
        try {
            FileSystem fs = FileSystem.get((URI)this.getPath().toUri(), (Configuration)SessionState.getSessionConf());
            String pathPattern = this.getPath().toString();
            if (this.getNumBuckets() > 0) {
                pathPattern = pathPattern + "/*";
            }
            LOG.info("Path pattern = " + pathPattern);
            Object[] srcs = fs.globStatus(new Path(pathPattern), FileUtils.HIDDEN_FILES_PATH_FILTER);
            Arrays.sort(srcs);
            for (Object src : srcs) {
                LOG.info("Got file: " + src.getPath());
            }
            if (srcs.length == 0) {
                return null;
            }
            return srcs;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get path ", e);
        }
    }

    public boolean isEmpty() throws HiveException {
        Preconditions.checkNotNull(this.getPath());
        try {
            FileSystem fs = FileSystem.get((URI)this.getPath().toUri(), (Configuration)SessionState.getSessionConf());
            return !fs.exists(this.getPath()) || fs.listStatus(this.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER).length == 0;
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    public boolean isTemporary() {
        return this.tTable.isTemporary();
    }

    public static boolean hasMetastoreBasedSchema(HiveConf conf, String serdeLib) {
        return StringUtils.isEmpty(serdeLib) || conf.getStringCollection(HiveConf.ConfVars.SERDESUSINGMETASTOREFORSCHEMA.varname).contains(serdeLib);
    }

    public static boolean shouldStoreFieldsInMetastore(HiveConf conf, String serdeLib, Map<String, String> tableParams) {
        if (Table.hasMetastoreBasedSchema(conf, serdeLib)) {
            return true;
        }
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_LEGACY_SCHEMA_FOR_ALL_SERDES)) {
            return true;
        }
        AbstractSerDe deserializer = null;
        try {
            Class clazz = conf.getClassByName(serdeLib);
            if (!AbstractSerDe.class.isAssignableFrom(clazz)) {
                return true;
            }
            deserializer = ReflectionUtil.newInstance(conf.getClassByName(serdeLib).asSubclass(AbstractSerDe.class), conf);
        }
        catch (Exception ex) {
            LOG.warn("Cannot initialize SerDe: " + serdeLib + ", ignoring", (Throwable)ex);
            return true;
        }
        return deserializer.shouldStoreFieldsInMetastore(tableParams);
    }

    public static void validateColumns(List<FieldSchema> columns, List<FieldSchema> partCols) throws HiveException {
        String colName;
        HashSet<String> colNames = new HashSet<String>();
        for (FieldSchema col : columns) {
            colName = Table.normalize(col.getName());
            if (colNames.contains(colName)) {
                throw new HiveException("Duplicate column name " + colName + " in the table definition.");
            }
            colNames.add(colName);
        }
        if (partCols != null) {
            for (FieldSchema partCol : partCols) {
                colName = Table.normalize(partCol.getName());
                if (!colNames.contains(colName)) continue;
                throw new HiveException("Partition column name " + colName + " conflicts with table columns.");
            }
        }
    }

    private static String normalize(String colName) throws HiveException {
        if (!MetaStoreUtils.validateColumnName(colName)) {
            throw new HiveException("Invalid column name '" + colName + "' in the table definition");
        }
        return colName.toLowerCase();
    }

    public BaseSemanticAnalyzer.TableSpec getTableSpec() {
        return this.tableSpec;
    }

    public void setTableSpec(BaseSemanticAnalyzer.TableSpec tableSpec) {
        this.tableSpec = tableSpec;
    }

    public boolean hasDeserializer() {
        return this.deserializer != null;
    }

    public class ValidationFailureSemanticException
    extends SemanticException {
        public ValidationFailureSemanticException(String s) {
            super(s);
        }
    }
}

