/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.LinkedHashMap;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.VoidObjectInspector;

@Description(name="map", value="_FUNC_(key0, value0, key1, value1...) - Creates a map with the given key/value pairs ")
public class GenericUDFMap
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters;
    LinkedHashMap<Object, Object> ret = new LinkedHashMap();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length % 2 != 0) {
            throw new UDFArgumentLengthException("Arguments must be in key/value pairs");
        }
        GenericUDFUtils.ReturnObjectInspectorResolver keyOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        GenericUDFUtils.ReturnObjectInspectorResolver valueOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        for (int i = 0; i < arguments.length; ++i) {
            if (i % 2 == 0) {
                if (!(arguments[i] instanceof PrimitiveObjectInspector)) {
                    throw new UDFArgumentTypeException(1, "Primitive Type is expected but " + arguments[i].getTypeName() + "\" is found");
                }
                if (keyOIResolver.update(arguments[i])) continue;
                throw new UDFArgumentTypeException(i, "Key type \"" + arguments[i].getTypeName() + "\" is different from preceding key types. Previous key type was \"" + arguments[i - 2].getTypeName() + "\"");
            }
            if (valueOIResolver.update(arguments[i]) || this.compatibleTypes(arguments[i], arguments[i - 2])) continue;
            throw new UDFArgumentTypeException(i, "Value type \"" + arguments[i].getTypeName() + "\" is different from preceding value types. Previous value type was \"" + arguments[i - 2].getTypeName() + "\"");
        }
        ObjectInspector keyOI = keyOIResolver.get(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        ObjectInspector valueOI = valueOIResolver.get(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            this.converters[i] = ObjectInspectorConverters.getConverter(arguments[i], i % 2 == 0 ? keyOI : valueOI);
        }
        return ObjectInspectorFactory.getStandardMapObjectInspector(keyOI, valueOI);
    }

    private boolean compatibleTypes(ObjectInspector current, ObjectInspector prev) {
        if (current instanceof VoidObjectInspector || prev instanceof VoidObjectInspector) {
            return true;
        }
        return current instanceof ListObjectInspector && prev instanceof ListObjectInspector && (((ListObjectInspector)current).getListElementObjectInspector() instanceof VoidObjectInspector || ((ListObjectInspector)prev).getListElementObjectInspector() instanceof VoidObjectInspector);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.ret.clear();
        for (int i = 0; i < arguments.length; i += 2) {
            this.ret.put(this.converters[i].convert(arguments[i].get()), this.converters[i + 1].convert(arguments[i + 1].get()));
        }
        return this.ret;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("map(");
        assert (children.length % 2 == 0);
        for (int i = 0; i < children.length; i += 2) {
            sb.append(children[i]);
            sb.append(":");
            sb.append(children[i + 1]);
            if (i + 2 == children.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

