/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSerdeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSerdeUtils.class);
    @Deprecated
    public static final String SCHEMA_LITERAL = "avro.schema.literal";
    @Deprecated
    public static final String SCHEMA_URL = "avro.schema.url";
    @Deprecated
    public static final String SCHEMA_NAMESPACE = "avro.schema.namespace";
    @Deprecated
    public static final String SCHEMA_NAME = "avro.schema.name";
    @Deprecated
    public static final String SCHEMA_DOC = "avro.schema.doc";
    @Deprecated
    public static final String AVRO_SERDE_SCHEMA = AvroTableProperties.AVRO_SERDE_SCHEMA.getPropName();
    @Deprecated
    public static final String SCHEMA_RETRIEVER = AvroTableProperties.SCHEMA_RETRIEVER.getPropName();
    public static final String SCHEMA_NONE = "none";
    public static final String EXCEPTION_MESSAGE = "Neither " + AvroTableProperties.SCHEMA_LITERAL.getPropName() + " nor " + AvroTableProperties.SCHEMA_URL.getPropName() + " specified, can't determine table schema";

    public static Schema determineSchemaOrThrowException(Configuration conf, Properties properties) throws IOException, AvroSerdeException {
        String schemaString = properties.getProperty(AvroTableProperties.SCHEMA_LITERAL.getPropName());
        if (schemaString != null && !schemaString.equals(SCHEMA_NONE)) {
            return AvroSerdeUtils.getSchemaFor(schemaString);
        }
        schemaString = properties.getProperty(AvroTableProperties.SCHEMA_URL.getPropName());
        if (schemaString == null) {
            String columnNameProperty = properties.getProperty("columns");
            String columnTypeProperty = properties.getProperty("columns.types");
            String columnCommentProperty = properties.getProperty("columns.comments");
            if (columnNameProperty == null || columnNameProperty.isEmpty() || columnTypeProperty == null || columnTypeProperty.isEmpty()) {
                throw new AvroSerdeException(EXCEPTION_MESSAGE);
            }
            String columnNameDelimiter = properties.containsKey("column.name.delimiter") ? properties.getProperty("column.name.delimiter") : String.valueOf(',');
            List<String> columnNames = Arrays.asList(columnNameProperty.split(columnNameDelimiter));
            ArrayList<TypeInfo> columnTypes = TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
            Schema schema = AvroSerDe.getSchemaFromCols(properties, columnNames, columnTypes, columnCommentProperty);
            properties.setProperty(AvroTableProperties.SCHEMA_LITERAL.getPropName(), schema.toString());
            if (conf != null) {
                conf.set(AvroTableProperties.AVRO_SERDE_SCHEMA.getPropName(), schema.toString(false));
            }
            return schema;
        }
        if (schemaString.equals(SCHEMA_NONE)) {
            throw new AvroSerdeException(EXCEPTION_MESSAGE);
        }
        try {
            Schema s = AvroSerdeUtils.getSchemaFromFS(schemaString, conf);
            if (s == null) {
                return AvroSerdeUtils.getSchemaFor(new URL(schemaString));
            }
            return s;
        }
        catch (IOException ioe) {
            throw new AvroSerdeException("Unable to read schema from given path: " + schemaString, ioe);
        }
        catch (URISyntaxException urie) {
            throw new AvroSerdeException("Unable to read schema from given path: " + schemaString, urie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Schema getSchemaFromFS(String schemaFSUrl, Configuration conf) throws IOException, URISyntaxException {
        FSDataInputStream in = null;
        FileSystem fs = null;
        try {
            fs = FileSystem.get((URI)new URI(schemaFSUrl), (Configuration)conf);
        }
        catch (IOException ioe) {
            if (LOG.isDebugEnabled()) {
                String msg = "Failed to open file system for uri " + schemaFSUrl + " assuming it is not a FileSystem url";
                LOG.debug(msg, (Throwable)ioe);
            }
            return null;
        }
        try {
            Schema s;
            in = fs.open(new Path(schemaFSUrl));
            Schema schema = s = AvroSerdeUtils.getSchemaFor((InputStream)in);
            return schema;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static boolean isNullableType(Schema schema) {
        if (!schema.getType().equals((Object)Schema.Type.UNION)) {
            return false;
        }
        List itemSchemas = schema.getTypes();
        if (itemSchemas.size() < 2) {
            return false;
        }
        for (Schema itemSchema : itemSchemas) {
            if (!Schema.Type.NULL.equals((Object)itemSchema.getType())) continue;
            return true;
        }
        return false;
    }

    public static Schema getOtherTypeFromNullableType(Schema unionSchema) {
        List types = unionSchema.getTypes();
        if (types.size() == 2) {
            if (((Schema)types.get(0)).getType() == Schema.Type.NULL) {
                return (Schema)types.get(1);
            }
            if (((Schema)types.get(1)).getType() == Schema.Type.NULL) {
                return (Schema)types.get(0);
            }
            return unionSchema;
        }
        ArrayList<Schema> itemSchemas = new ArrayList<Schema>();
        for (Schema itemSchema : types) {
            if (Schema.Type.NULL.equals((Object)itemSchema.getType())) continue;
            itemSchemas.add(itemSchema);
        }
        if (itemSchemas.size() > 1) {
            return Schema.createUnion(itemSchemas);
        }
        return (Schema)itemSchemas.get(0);
    }

    public static boolean insideMRJob(JobConf job) {
        return job != null && HiveConf.getVar((Configuration)job, HiveConf.ConfVars.PLAN) != null && !HiveConf.getVar((Configuration)job, HiveConf.ConfVars.PLAN).isEmpty();
    }

    public static Buffer getBufferFromBytes(byte[] input) {
        ByteBuffer bb = ByteBuffer.wrap(input);
        return bb.rewind();
    }

    public static Buffer getBufferFromDecimal(HiveDecimal dec, int scale) {
        if (dec == null) {
            return null;
        }
        return AvroSerdeUtils.getBufferFromBytes(dec.bigIntegerBytesScaled(scale));
    }

    public static byte[] getBytesFromByteBuffer(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        byte[] result = new byte[byteBuffer.limit()];
        byteBuffer.get(result);
        return result;
    }

    public static HiveDecimal getHiveDecimalFromByteBuffer(ByteBuffer byteBuffer, int scale) {
        byte[] result = AvroSerdeUtils.getBytesFromByteBuffer(byteBuffer);
        HiveDecimal dec = HiveDecimal.create(new BigInteger(result), scale);
        return dec;
    }

    private static Schema.Parser getSchemaParser() {
        return new Schema.Parser().setValidateDefaults(false);
    }

    public static Schema getSchemaFor(String str) {
        Schema schema = AvroSerdeUtils.getSchemaParser().parse(str);
        return schema;
    }

    public static Schema getSchemaFor(File file) {
        Schema schema;
        try {
            schema = AvroSerdeUtils.getSchemaParser().parse(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse Avro schema from " + file.getName(), e);
        }
        return schema;
    }

    public static Schema getSchemaFor(InputStream stream) {
        Schema schema;
        try {
            schema = AvroSerdeUtils.getSchemaParser().parse(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse Avro schema", e);
        }
        return schema;
    }

    public static Schema getSchemaFor(URL url) {
        InputStream in = null;
        try {
            in = url.openStream();
            Schema schema = AvroSerdeUtils.getSchemaFor(in);
            return schema;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse Avro schema", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int getIntFromSchema(Schema schema, String name) {
        Object obj = schema.getObjectProp(name);
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new IllegalArgumentException("Expect integer or string value from property " + name + " but found type " + obj.getClass().getName());
    }

    public static void handleAlterTableForAvro(HiveConf conf, String serializationLib, Map<String, String> parameters) {
        if (AvroSerDe.class.getName().equals(serializationLib)) {
            String literalPropName = AvroTableProperties.SCHEMA_LITERAL.getPropName();
            String urlPropName = AvroTableProperties.SCHEMA_URL.getPropName();
            if (parameters.containsKey(literalPropName) || parameters.containsKey(urlPropName)) {
                throw new RuntimeException("Not allowed to alter schema of Avro stored table having external schema. Consider removing " + AvroTableProperties.SCHEMA_LITERAL.getPropName() + " or " + AvroTableProperties.SCHEMA_URL.getPropName() + " from table properties.");
            }
        }
    }

    public static enum AvroTableProperties {
        SCHEMA_LITERAL("avro.schema.literal"),
        SCHEMA_URL("avro.schema.url"),
        SCHEMA_NAMESPACE("avro.schema.namespace"),
        SCHEMA_NAME("avro.schema.name"),
        SCHEMA_DOC("avro.schema.doc"),
        AVRO_SERDE_SCHEMA("avro.serde.schema"),
        SCHEMA_RETRIEVER("avro.schema.retriever");

        private final String propName;

        private AvroTableProperties(String propName) {
            this.propName = propName;
        }

        public String getPropName() {
            return this.propName;
        }
    }
}

