/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.impl.WeakReferenceThreadMap;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.audit.AWSRequestAnalyzer;
import org.apache.hadoop.fs.s3a.audit.AuditFailureException;
import org.apache.hadoop.fs.s3a.audit.AuditIntegration;
import org.apache.hadoop.fs.s3a.audit.AuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.audit.OperationAuditor;
import org.apache.hadoop.fs.s3a.audit.OperationAuditorOptions;
import org.apache.hadoop.fs.s3a.audit.impl.AbstractAuditSpanImpl;
import org.apache.hadoop.fs.s3a.impl.V2Migration;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.FutureIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;

@InterfaceAudience.Private
public final class ActiveAuditManagerS3A
extends CompositeService
implements AuditManagerS3A {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveAuditManagerS3A.class);
    public static final LogExactlyOnce WARN_OF_SPAN_TYPE = new LogExactlyOnce(LOG);
    public static final String AUDIT_MANAGER_OPERATION = "AuditManagerS3A";
    public static final String NOT_A_WRAPPED_SPAN = "Span attached to request is not a wrapped span";
    static final int PRUNE_THRESHOLD = 10000;
    private OperationAuditor auditor;
    private final AWSRequestAnalyzer analyzer = new AWSRequestAnalyzer();
    private WrappingAuditSpan unbondedSpan;
    private final int pruneThreshold = 10000;
    private final AtomicInteger deactivationsBeforePrune = new AtomicInteger();
    private final WeakReferenceThreadMap<WrappingAuditSpan> activeSpanMap = new WeakReferenceThreadMap(k -> this.getUnbondedSpan(), this::noteSpanReferenceLost);
    private final IOStatisticsStore ioStatisticsStore;

    public ActiveAuditManagerS3A(IOStatisticsStore iostatistics) {
        super("ActiveAuditManagerS3A");
        this.ioStatisticsStore = iostatistics;
        this.deactivationsBeforePrune.set(10000);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        OperationAuditorOptions options = OperationAuditorOptions.builder().withConfiguration(conf).withIoStatisticsStore(this.ioStatisticsStore);
        this.auditor = AuditIntegration.createAndInitAuditor(this.getConfig(), "fs.s3a.audit.service.classname", options);
        this.addService(this.auditor);
        LOG.debug("Audit manager initialized with audit service {}", (Object)this.auditor);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.setUnbondedSpan(new WrappingAuditSpan(this.auditor.getUnbondedSpan(), false));
        LOG.debug("Started audit service {}", (Object)this.auditor);
    }

    protected void serviceStop() throws Exception {
        this.activeSpanMap.clear();
        super.serviceStop();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", auditor=").append(this.auditor);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public OperationAuditor getAuditor() {
        return this.auditor;
    }

    private WrappingAuditSpan getUnbondedSpan() {
        return this.unbondedSpan;
    }

    private void setUnbondedSpan(WrappingAuditSpan unbondedSpan) {
        this.unbondedSpan = unbondedSpan;
    }

    public AuditSpanS3A getActiveAuditSpan() {
        return this.activeSpan();
    }

    private WrappingAuditSpan activeSpan() {
        return (WrappingAuditSpan)this.activeSpanMap.getForCurrentThread();
    }

    private AuditSpanS3A setActiveThreadSpan(AuditSpanS3A span) {
        return this.switchToActiveSpan(new WrappingAuditSpan(span, span.isValidSpan()));
    }

    private WrappingAuditSpan switchToActiveSpan(WrappingAuditSpan span) {
        if (span != null && span.isValidSpan()) {
            this.activeSpanMap.setForCurrentThread((Object)span);
        } else {
            this.activeSpanMap.removeForCurrentThread();
        }
        return this.activeSpan();
    }

    private void noteSpanReferenceLost(long threadId) {
        this.auditor.noteSpanReferenceLost(threadId);
    }

    @VisibleForTesting
    int prune() {
        return this.activeSpanMap.prune();
    }

    @VisibleForTesting
    boolean removeActiveSpanFromMap() {
        this.activeSpanMap.removeForCurrentThread();
        if (this.deactivationsBeforePrune.decrementAndGet() == 0) {
            this.activeSpanMap.prune();
            this.deactivationsBeforePrune.set(10000);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    WeakReferenceThreadMap<WrappingAuditSpan> getActiveSpanMap() {
        return this.activeSpanMap;
    }

    @Override
    public String getSpanId() {
        return this.auditor != null ? this.auditor.getAuditorId() : "(auditor not yet created)";
    }

    @Override
    public String getOperationName() {
        return AUDIT_MANAGER_OPERATION;
    }

    public AuditSpanS3A createSpan(String operation, @Nullable String path1, @Nullable String path2) throws IOException {
        Preconditions.checkState((boolean)this.isInState(Service.STATE.STARTED), (String)"Audit Manager %s is in wrong state: %s", (Object[])new Object[]{this, this.getServiceState()});
        this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_SPAN_CREATION.getSymbol());
        return this.setActiveThreadSpan((AuditSpanS3A)this.auditor.createSpan(operation, path1, path2));
    }

    @Override
    public List<ExecutionInterceptor> createExecutionInterceptors() throws IOException {
        Class[] interceptors;
        ArrayList<ExecutionInterceptor> executionInterceptors = new ArrayList<ExecutionInterceptor>();
        executionInterceptors.add(this);
        String handlers = this.getConfig().getTrimmed("fs.s3a.audit.request.handlers", "");
        if (!handlers.isEmpty()) {
            V2Migration.v1RequestHandlersUsed(handlers);
        }
        if ((interceptors = this.getConfig().getClasses("fs.s3a.audit.execution.interceptors", new Class[0])) != null) {
            for (Class handler : interceptors) {
                try {
                    LOG.debug("Adding intercept of class {}", (Object)handler);
                    Constructor ctor = handler.getConstructor(new Class[0]);
                    ExecutionInterceptor interceptor = (ExecutionInterceptor)ctor.newInstance(new Object[0]);
                    if (interceptor instanceof Configurable) {
                        ((Configurable)interceptor).setConf(this.getConfig());
                    }
                    executionInterceptors.add(interceptor);
                }
                catch (ExceptionInInitializerError e) {
                    throw FutureIO.unwrapInnerException((Throwable)e);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
        return executionInterceptors;
    }

    @Override
    public TransferListener createTransferListener() {
        final WrappingAuditSpan span = this.activeSpan();
        return new TransferListener(){

            public void transferInitiated(TransferListener.Context.TransferInitiated context) {
                ActiveAuditManagerS3A.this.switchToActiveSpan(span);
            }
        };
    }

    @Override
    public boolean checkAccess(Path path, S3AFileStatus status, FsAction mode) throws IOException {
        return this.auditor.checkAccess(path, status, mode);
    }

    @Override
    public void requestCreated(SdkRequest.Builder builder) {
        AuditSpanS3A span = this.getActiveAuditSpan();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created Request {} in span {}", (Object)this.analyzer.analyze(builder.build()), (Object)span);
        }
        try {
            span.requestCreated(builder);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_REQUEST_EXECUTION.getSymbol());
        AuditSpanS3A span = this.getActiveAuditSpan();
        AuditIntegration.attachSpanToRequest(executionAttributes, span);
        try {
            span.beforeExecution(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        try {
            this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).afterExecution(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    private AuditSpanS3A extractAndActivateSpanFromRequest(SdkRequest request, ExecutionAttributes executionAttributes) {
        AuditSpanS3A span = AuditIntegration.retrieveAttachedSpan(executionAttributes);
        if (span == null) {
            LOG.debug("No audit span attached to request {}", (Object)request);
            span = this.getActiveAuditSpan();
        } else if (span instanceof WrappingAuditSpan) {
            this.switchToActiveSpan((WrappingAuditSpan)span);
        } else {
            WARN_OF_SPAN_TYPE.warn("Span attached to request is not a wrapped span: {}", new Object[]{span});
            LOG.debug("Span attached to request is not a wrapped span: {}", (Object)span);
        }
        return span;
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        try {
            this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).onExecutionFailure(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        try {
            return this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).modifyRequest(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public void beforeMarshalling(Context.BeforeMarshalling context, ExecutionAttributes executionAttributes) {
        try {
            this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).beforeMarshalling(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
        try {
            this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).afterMarshalling(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        try {
            return this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).modifyHttpRequest(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
        try {
            this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).beforeTransmission(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public void afterTransmission(Context.AfterTransmission context, ExecutionAttributes executionAttributes) {
        try {
            this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).afterTransmission(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public SdkHttpResponse modifyHttpResponse(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        try {
            return this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).modifyHttpResponse(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public void beforeUnmarshalling(Context.BeforeUnmarshalling context, ExecutionAttributes executionAttributes) {
        try {
            this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).beforeUnmarshalling(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public void afterUnmarshalling(Context.AfterUnmarshalling context, ExecutionAttributes executionAttributes) {
        try {
            this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).afterUnmarshalling(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    public SdkResponse modifyResponse(Context.ModifyResponse context, ExecutionAttributes executionAttributes) {
        try {
            return this.extractAndActivateSpanFromRequest(context.request(), executionAttributes).modifyResponse(context, executionAttributes);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    @VisibleForTesting
    final class WrappingAuditSpan
    extends AbstractAuditSpanImpl {
        private final AuditSpanS3A span;
        private final boolean isValid;

        private WrappingAuditSpan(AuditSpanS3A span, boolean isValid) {
            super(span.getSpanId(), span.getTimestamp(), span.getOperationName());
            this.span = Objects.requireNonNull(span);
            this.isValid = isValid;
        }

        private boolean isActive() {
            return this == ActiveAuditManagerS3A.this.getActiveAuditSpan();
        }

        @Override
        public AuditSpanS3A activate() {
            if (!this.isActive()) {
                ActiveAuditManagerS3A.this.switchToActiveSpan(this);
                this.span.activate();
            }
            return this;
        }

        public void deactivate() {
            if (!this.isActive()) {
                return;
            }
            if (this.isValid) {
                this.span.deactivate();
            }
            ActiveAuditManagerS3A.this.removeActiveSpanFromMap();
        }

        @Override
        public void requestCreated(SdkRequest.Builder builder) {
            this.span.requestCreated(builder);
        }

        public boolean isValidSpan() {
            return this.isValid && this.span.isValidSpan();
        }

        @VisibleForTesting
        AuditSpanS3A getSpan() {
            return this.span;
        }

        public void set(String key, String value) {
            this.span.set(key, value);
        }

        public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
            this.span.beforeExecution(context, executionAttributes);
        }

        public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
            this.span.afterExecution(context, executionAttributes);
        }

        public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
            this.span.onExecutionFailure(context, executionAttributes);
        }

        public void beforeMarshalling(Context.BeforeMarshalling context, ExecutionAttributes executionAttributes) {
            this.span.beforeMarshalling(context, executionAttributes);
        }

        public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
            return this.span.modifyRequest(context, executionAttributes);
        }

        public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
            this.span.afterMarshalling(context, executionAttributes);
        }

        public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
            return this.span.modifyHttpRequest(context, executionAttributes);
        }

        public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
            this.span.beforeTransmission(context, executionAttributes);
        }

        public void afterTransmission(Context.AfterTransmission context, ExecutionAttributes executionAttributes) {
            this.span.afterTransmission(context, executionAttributes);
        }

        public SdkHttpResponse modifyHttpResponse(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
            return this.span.modifyHttpResponse(context, executionAttributes);
        }

        public void beforeUnmarshalling(Context.BeforeUnmarshalling context, ExecutionAttributes executionAttributes) {
            this.span.beforeUnmarshalling(context, executionAttributes);
        }

        public void afterUnmarshalling(Context.AfterUnmarshalling context, ExecutionAttributes executionAttributes) {
            this.span.afterUnmarshalling(context, executionAttributes);
        }

        public SdkResponse modifyResponse(Context.ModifyResponse context, ExecutionAttributes executionAttributes) {
            return this.span.modifyResponse(context, executionAttributes);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("WrappingAuditSpan{");
            sb.append("span=").append(this.span);
            sb.append(", valid=").append(this.isValidSpan());
            sb.append('}');
            return sb.toString();
        }
    }
}

