/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import java.io.IOError;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLException;

public final class IoExceptionHelper {
    private IoExceptionHelper() {
    }

    public static boolean isIoError(Throwable throwable) {
        if (throwable instanceof IOException || throwable instanceof IOError) {
            return true;
        }
        Throwable cause = throwable.getCause();
        return cause != null && IoExceptionHelper.isIoError(cause);
    }

    public static boolean isSocketError(Throwable throwable) {
        if (throwable instanceof SocketException || throwable instanceof SocketTimeoutException) {
            return true;
        }
        Throwable cause = throwable.getCause();
        if (throwable instanceof SSLException && cause != null && IoExceptionHelper.isIoError(cause)) {
            return true;
        }
        return cause != null && IoExceptionHelper.isSocketError(cause);
    }

    public static boolean isReadTimedOut(IOException e) {
        return e instanceof SocketTimeoutException && e.getMessage().equalsIgnoreCase("Read timed out");
    }
}

