/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ITraceFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ITraceOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.TraceOperation;

public class TraceFactory {
    private static final ITraceFactory NOOP = new NoopTraceFactory();

    private TraceFactory() {
    }

    public static ITraceFactory get(boolean isEnabled) {
        if (isEnabled) {
            return new EnabledTraceFactory();
        }
        return NOOP;
    }

    private static class NoopTraceFactory
    implements ITraceFactory {
        private NoopTraceFactory() {
        }

        @Override
        public ITraceOperation createRootWithLogging(String name, Object context) {
            return TraceOperation.NOOP;
        }
    }

    private static class EnabledTraceFactory
    implements ITraceFactory {
        private EnabledTraceFactory() {
        }

        @Override
        public ITraceOperation createRootWithLogging(String name, Object context) {
            return TraceOperation.createRootWithLogging(name, context);
        }
    }
}

