/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.BucketAccessControl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.HmacKeyMetadata;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Notification;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.ObjectAccessControl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Policy;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageRetryStrategy;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class HttpRetryAlgorithmManager
implements Serializable {
    private static final long serialVersionUID = -3301856948991518651L;
    final StorageRetryStrategy retryStrategy;

    HttpRetryAlgorithmManager(StorageRetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    ResultRetryAlgorithm<?> idempotent() {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketAclCreate(BucketAccessControl pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketAclDelete(String pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketAclGet(String pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketAclUpdate(BucketAccessControl pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketAclList(String pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketsCreate(Bucket pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketsDelete(Bucket pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketsGet(Bucket pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketsUpdate(Bucket pb, Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_METAGENERATION_MATCH) ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketsList(Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketsLockRetentionPolicy(Bucket pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketsGetIamPolicy(String bucket, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketsSetIamPolicy(String bucket, Policy pb, Map<StorageRpc.Option, ?> optionsMap) {
        return pb.getEtag() != null ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForBucketsTestIamPermissions(String bucket, List<String> permissions, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForDefaultObjectAclCreate(ObjectAccessControl pb) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForDefaultObjectAclDelete(String pb) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForDefaultObjectAclGet(String pb) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForDefaultObjectAclUpdate(ObjectAccessControl pb) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForDefaultObjectAclList(String pb) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForHmacKeyCreate(String pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForHmacKeyDelete(HmacKeyMetadata pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForHmacKeyGet(String accessId, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForHmacKeyUpdate(HmacKeyMetadata pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForHmacKeyList(Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectAclCreate(ObjectAccessControl aclPb) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectAclDelete(String bucket, String name, Long generation, String pb) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectAclList(String bucket, String name, Long generation) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectAclGet(String bucket, String name, Long generation, String pb) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectAclUpdate(ObjectAccessControl aclPb) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectsCreate(StorageObject pb, Map<StorageRpc.Option, ?> optionsMap) {
        if (pb.getGeneration() != null && pb.getGeneration() == 0L) {
            return this.retryStrategy.getIdempotentHandler();
        }
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectsDelete(StorageObject pb, Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) || pb.getGeneration() != null && pb.getGeneration() > 0L ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectsGet(StorageObject pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectsRestore(StorageObject pb, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectsUpdate(StorageObject pb, Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_METAGENERATION_MATCH) ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectsList(String bucket, Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectsRewrite(StorageRpc.RewriteRequest pb) {
        return pb.targetOptions.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForObjectsCompose(List<StorageObject> sources, StorageObject target, Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForResumableUploadSessionCreate(Map<StorageRpc.Option, ?> optionsMap) {
        return optionsMap.containsKey((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForResumableUploadSessionWrite(Map<StorageRpc.Option, ?> optionsMap) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForServiceAccountGet(String pb) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForNotificationCreate(String bucket, Notification pb) {
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForNotificationGet(String bucket, String notificationId) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForNotificationList(String bucket) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getForNotificationDelete(String bucket, String notificationId) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpRetryAlgorithmManager)) {
            return false;
        }
        HttpRetryAlgorithmManager that = (HttpRetryAlgorithmManager)o;
        return Objects.equals(this.retryStrategy, that.retryStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.retryStrategy);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("retryStrategy", this.retryStrategy).toString();
    }
}

