/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FolderName
implements ResourceName {
    private static final PathTemplate PROJECT_BUCKET_FOLDER = PathTemplate.createWithoutUrlEncoding("projects/{project}/buckets/{bucket}/folders/{folder=**}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String bucket;
    private final String folder;

    @Deprecated
    protected FolderName() {
        this.project = null;
        this.bucket = null;
        this.folder = null;
    }

    private FolderName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.bucket = Preconditions.checkNotNull(builder.getBucket());
        this.folder = Preconditions.checkNotNull(builder.getFolder());
    }

    public String getProject() {
        return this.project;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FolderName of(String project, String bucket, String folder) {
        return FolderName.newBuilder().setProject(project).setBucket(bucket).setFolder(folder).build();
    }

    public static String format(String project, String bucket, String folder) {
        return FolderName.newBuilder().setProject(project).setBucket(bucket).setFolder(folder).build().toString();
    }

    public static FolderName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_BUCKET_FOLDER.validatedMatch(formattedString, "FolderName.parse: formattedString not in valid format");
        return FolderName.of(matchMap.get("project"), matchMap.get("bucket"), matchMap.get("folder"));
    }

    public static List<FolderName> parseList(List<String> formattedStrings) {
        ArrayList<FolderName> list = new ArrayList<FolderName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FolderName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FolderName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FolderName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_BUCKET_FOLDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FolderName folderName = this;
            synchronized (folderName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.bucket != null) {
                        fieldMapBuilder.put("bucket", this.bucket);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_BUCKET_FOLDER.instantiate("project", this.project, "bucket", this.bucket, "folder", this.folder);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FolderName that = (FolderName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.bucket);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    public static class Builder {
        private String project;
        private String bucket;
        private String folder;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getFolder() {
            return this.folder;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        private Builder(FolderName folderName) {
            this.project = folderName.project;
            this.bucket = folderName.bucket;
            this.folder = folderName.folder;
        }

        public FolderName build() {
            return new FolderName(this);
        }
    }
}

