/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.azurebfs.constants.FSOperationType;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.security.ContextEncryptionAdapter;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamStatistics;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.ReadBufferManager;
import org.apache.hadoop.fs.azurebfs.utils.CachedSASToken;
import org.apache.hadoop.fs.azurebfs.utils.Listener;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.impl.BackReference;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsInputStream
extends FSInputStream
implements CanUnbuffer,
StreamCapabilities,
IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsInputStream.class);
    public static final int FOOTER_SIZE = 16384;
    public static final int MAX_OPTIMIZED_READ_ATTEMPTS = 2;
    private int readAheadBlockSize;
    private final AbfsClient client;
    private final FileSystem.Statistics statistics;
    private final String path;
    private final long contentLength;
    private final int bufferSize;
    private final int footerReadSize;
    private final int readAheadQueueDepth;
    private final String eTag;
    private final boolean tolerateOobAppends;
    private final boolean readAheadEnabled;
    private final String inputStreamId;
    private final boolean alwaysReadBufferSize;
    private final boolean bufferedPreadDisabled;
    private final int readAheadRange;
    private boolean firstRead = true;
    private CachedSASToken cachedSasToken;
    private byte[] buffer = null;
    private long fCursor = 0L;
    private long fCursorAfterLastRead = -1L;
    private int bCursor = 0;
    private int limit = 0;
    private boolean closed = false;
    private TracingContext tracingContext;
    private final ContextEncryptionAdapter contextEncryptionAdapter;
    private int limitBkp;
    private int bCursorBkp;
    private long fCursorBkp;
    private long fCursorAfterLastReadBkp;
    private final AbfsInputStreamStatistics streamStatistics;
    private long bytesFromReadAhead;
    private long bytesFromRemoteRead;
    private Listener listener;
    private final AbfsInputStreamContext context;
    private IOStatistics ioStatistics;
    private long nextReadPos;
    private final BackReference fsBackRef;

    public AbfsInputStream(AbfsClient client, FileSystem.Statistics statistics, String path, long contentLength, AbfsInputStreamContext abfsInputStreamContext, String eTag, TracingContext tracingContext) {
        this.client = client;
        this.statistics = statistics;
        this.path = path;
        this.contentLength = contentLength;
        this.bufferSize = abfsInputStreamContext.getReadBufferSize();
        this.footerReadSize = Math.min(this.bufferSize, abfsInputStreamContext.getFooterReadBufferSize());
        this.readAheadQueueDepth = abfsInputStreamContext.getReadAheadQueueDepth();
        this.tolerateOobAppends = abfsInputStreamContext.isTolerateOobAppends();
        this.eTag = eTag;
        this.readAheadRange = abfsInputStreamContext.getReadAheadRange();
        this.readAheadEnabled = abfsInputStreamContext.isReadAheadEnabled();
        this.alwaysReadBufferSize = abfsInputStreamContext.shouldReadBufferSizeAlways();
        this.bufferedPreadDisabled = abfsInputStreamContext.isBufferedPreadDisabled();
        this.cachedSasToken = new CachedSASToken(abfsInputStreamContext.getSasTokenRenewPeriodForStreamsInSeconds());
        this.streamStatistics = abfsInputStreamContext.getStreamStatistics();
        this.inputStreamId = this.createInputStreamId();
        this.tracingContext = new TracingContext(tracingContext);
        this.tracingContext.setOperation(FSOperationType.READ);
        this.tracingContext.setStreamID(this.inputStreamId);
        this.context = abfsInputStreamContext;
        this.readAheadBlockSize = abfsInputStreamContext.getReadAheadBlockSize();
        this.fsBackRef = abfsInputStreamContext.getFsBackRef();
        this.contextEncryptionAdapter = abfsInputStreamContext.getEncryptionAdapter();
        ReadBufferManager.setReadBufferManagerConfigs(this.readAheadBlockSize);
        if (this.streamStatistics != null) {
            this.ioStatistics = this.streamStatistics.getIOStatistics();
        }
    }

    public String getPath() {
        return this.path;
    }

    private String createInputStreamId() {
        return StringUtils.right((String)UUID.randomUUID().toString(), (int)12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        AbfsInputStream abfsInputStream = this;
        synchronized (abfsInputStream) {
            if (this.closed) {
                throw new IOException("Stream is closed!");
            }
        }
        LOG.debug("pread requested offset = {} len = {} bufferedPreadDisabled = {}", new Object[]{offset, length, this.bufferedPreadDisabled});
        if (!this.bufferedPreadDisabled) {
            return super.read(position, buffer, offset, length);
        }
        this.validatePositionedReadArgs(position, buffer, offset, length);
        if (length == 0) {
            return 0;
        }
        if (this.streamStatistics != null) {
            this.streamStatistics.readOperationStarted();
        }
        int bytesRead = this.readRemote(position, buffer, offset, length, this.tracingContext);
        if (this.statistics != null) {
            this.statistics.incrementBytesRead((long)bytesRead);
        }
        if (this.streamStatistics != null) {
            this.streamStatistics.bytesRead(bytesRead);
        }
        return bytesRead;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int numberOfBytesRead = this.read(b, 0, 1);
        if (numberOfBytesRead < 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int lastReadBytes;
        if (b != null) {
            LOG.debug("read requested b.length = {} offset = {} len = {}", new Object[]{b.length, off, len});
        } else {
            LOG.debug("read requested b = null offset = {} len = {}", (Object)off, (Object)len);
        }
        int currentOff = off;
        int currentLen = len;
        int totalReadBytes = 0;
        if (this.streamStatistics != null) {
            this.streamStatistics.readOperationStarted();
        }
        this.incrementReadOps();
        do {
            long filePosAtStartOfBuffer;
            if (this.nextReadPos >= (filePosAtStartOfBuffer = this.fCursor - (long)this.limit) && this.nextReadPos <= this.fCursor) {
                this.bCursor = (int)(this.nextReadPos - filePosAtStartOfBuffer);
                if (this.bCursor != this.limit && this.streamStatistics != null) {
                    this.streamStatistics.seekInBuffer();
                }
            } else {
                this.fCursor = this.nextReadPos;
                this.limit = 0;
                this.bCursor = 0;
            }
            if ((lastReadBytes = this.shouldReadFully() ? this.readFileCompletely(b, currentOff, currentLen) : (this.shouldReadLastBlock() ? this.readLastBlock(b, currentOff, currentLen) : this.readOneBlock(b, currentOff, currentLen))) <= 0) continue;
            currentOff += lastReadBytes;
            currentLen -= lastReadBytes;
            totalReadBytes += lastReadBytes;
        } while (currentLen > 0 && currentLen <= b.length - currentOff && lastReadBytes > 0);
        return totalReadBytes > 0 ? totalReadBytes : lastReadBytes;
    }

    private boolean shouldReadFully() {
        return this.firstRead && this.context.readSmallFilesCompletely() && this.contentLength <= (long)this.bufferSize;
    }

    private boolean shouldReadLastBlock() {
        long footerStart = Math.max(0L, this.contentLength - 16384L);
        return this.firstRead && this.context.optimizeFooterRead() && this.fCursor >= footerStart;
    }

    private int readOneBlock(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (!this.validate(b, off, len)) {
            return -1;
        }
        if (this.bCursor == this.limit) {
            if (this.fCursor >= this.contentLength) {
                return -1;
            }
            long bytesRead = 0L;
            this.bCursor = 0;
            this.limit = 0;
            if (this.buffer == null) {
                LOG.debug("created new buffer size {}", (Object)this.bufferSize);
                this.buffer = new byte[this.bufferSize];
            }
            if (this.alwaysReadBufferSize) {
                bytesRead = this.readInternal(this.fCursor, this.buffer, 0, this.bufferSize, false);
            } else if (-1L == this.fCursorAfterLastRead || this.fCursorAfterLastRead == this.fCursor || b.length >= this.bufferSize) {
                LOG.debug("Sequential read with read ahead size of {}", (Object)this.bufferSize);
                bytesRead = this.readInternal(this.fCursor, this.buffer, 0, this.bufferSize, false);
            } else {
                int lengthWithReadAhead = Math.min(b.length + this.readAheadRange, this.bufferSize);
                LOG.debug("Random read with read ahead size of {}", (Object)lengthWithReadAhead);
                bytesRead = this.readInternal(this.fCursor, this.buffer, 0, lengthWithReadAhead, true);
            }
            if (this.firstRead) {
                this.firstRead = false;
            }
            if (bytesRead == -1L) {
                return -1;
            }
            this.limit = (int)((long)this.limit + bytesRead);
            this.fCursor += bytesRead;
            this.fCursorAfterLastRead = this.fCursor;
        }
        return this.copyToUserBuffer(b, off, len);
    }

    private int readFileCompletely(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (!this.validate(b, off, len)) {
            return -1;
        }
        this.savePointerState();
        this.bCursor = (int)this.fCursor;
        return this.optimisedRead(b, off, len, 0L, this.contentLength);
    }

    private int readLastBlock(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (!this.validate(b, off, len)) {
            return -1;
        }
        this.savePointerState();
        long lastBlockStart = Math.max(0L, this.contentLength - (long)this.footerReadSize);
        this.bCursor = (int)(this.fCursor - lastBlockStart);
        long actualLenToRead = Math.min((long)this.footerReadSize, this.contentLength);
        return this.optimisedRead(b, off, len, lastBlockStart, actualLenToRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int optimisedRead(byte[] b, int off, int len, long readFrom, long actualLen) throws IOException {
        this.fCursor = readFrom;
        int totalBytesRead = 0;
        int lastBytesRead = 0;
        try {
            this.buffer = new byte[this.bufferSize];
            for (int i = 0; i < 2 && this.fCursor < this.contentLength; ++i) {
                lastBytesRead = this.readInternal(this.fCursor, this.buffer, this.limit, (int)actualLen - this.limit, true);
                if (lastBytesRead <= 0) continue;
                totalBytesRead += lastBytesRead;
                this.limit += lastBytesRead;
                this.fCursor += (long)lastBytesRead;
                this.fCursorAfterLastRead = this.fCursor;
            }
        }
        catch (IOException e) {
            LOG.debug("Optimized read failed. Defaulting to readOneBlock {}", (Throwable)e);
            this.restorePointerState();
            int n = this.readOneBlock(b, off, len);
            return n;
        }
        finally {
            this.firstRead = false;
        }
        if (totalBytesRead < 1) {
            this.restorePointerState();
            return -1;
        }
        if (this.fCursor < this.contentLength && this.bCursor > this.limit) {
            this.restorePointerState();
            return this.readOneBlock(b, off, len);
        }
        return this.copyToUserBuffer(b, off, len);
    }

    private void savePointerState() {
        this.limitBkp = this.limit;
        this.fCursorBkp = this.fCursor;
        this.fCursorAfterLastReadBkp = this.fCursorAfterLastRead;
        this.bCursorBkp = this.bCursor;
    }

    private void restorePointerState() {
        this.limit = this.limitBkp;
        this.fCursor = this.fCursorBkp;
        this.fCursorAfterLastRead = this.fCursorAfterLastReadBkp;
        this.bCursor = this.bCursorBkp;
    }

    private boolean validate(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        Preconditions.checkNotNull((Object)b);
        LOG.debug("read one block requested b.length = {} off {} len {}", new Object[]{b.length, off, len});
        if (this.available() == 0) {
            return false;
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        return true;
    }

    private int copyToUserBuffer(byte[] b, int off, int len) {
        int bytesRemaining = this.limit - this.bCursor;
        int bytesToRead = Math.min(len, bytesRemaining);
        System.arraycopy(this.buffer, this.bCursor, b, off, bytesToRead);
        this.bCursor += bytesToRead;
        this.nextReadPos += (long)bytesToRead;
        if (this.statistics != null) {
            this.statistics.incrementBytesRead((long)bytesToRead);
        }
        if (this.streamStatistics != null) {
            this.streamStatistics.bytesReadFromBuffer(bytesToRead);
            this.streamStatistics.bytesRead(bytesToRead);
        }
        return bytesToRead;
    }

    private int readInternal(long position, byte[] b, int offset, int length, boolean bypassReadAhead) throws IOException {
        if (this.readAheadEnabled && !bypassReadAhead) {
            int numReadAheads;
            if (offset != 0) {
                throw new IllegalArgumentException("readahead buffers cannot have non-zero buffer offsets");
            }
            long nextOffset = position;
            long nextSize = Math.min((long)this.bufferSize, this.contentLength - nextOffset);
            LOG.debug("read ahead enabled issuing readheads num = {}", (Object)numReadAheads);
            TracingContext readAheadTracingContext = new TracingContext(this.tracingContext);
            readAheadTracingContext.setPrimaryRequestID();
            for (numReadAheads = this.readAheadQueueDepth; numReadAheads > 0 && nextOffset < this.contentLength; --numReadAheads) {
                LOG.debug("issuing read ahead requestedOffset = {} requested size {}", (Object)nextOffset, (Object)nextSize);
                ReadBufferManager.getBufferManager().queueReadAhead(this, nextOffset, (int)nextSize, new TracingContext(readAheadTracingContext));
                nextSize = Math.min((long)this.readAheadBlockSize, this.contentLength - (nextOffset += nextSize));
            }
            int receivedBytes = ReadBufferManager.getBufferManager().getBlock(this, position, length, b);
            this.bytesFromReadAhead += (long)receivedBytes;
            if (receivedBytes > 0) {
                this.incrementReadOps();
                LOG.debug("Received data from read ahead, not doing remote read");
                if (this.streamStatistics != null) {
                    this.streamStatistics.readAheadBytesRead(receivedBytes);
                }
                return receivedBytes;
            }
            receivedBytes = this.readRemote(position, b, offset, length, new TracingContext(this.tracingContext));
            return receivedBytes;
        }
        LOG.debug("read ahead disabled, reading remote");
        return this.readRemote(position, b, offset, length, new TracingContext(this.tracingContext));
    }

    int readRemote(long position, byte[] b, int offset, int length, TracingContext tracingContext) throws IOException {
        AbfsRestOperation op;
        if (position < 0L) {
            throw new IllegalArgumentException("attempting to read from negative offset");
        }
        if (position >= this.contentLength) {
            return -1;
        }
        if (b == null) {
            throw new IllegalArgumentException("null byte array passed in to read() method");
        }
        if (offset >= b.length) {
            throw new IllegalArgumentException("offset greater than length of array");
        }
        if (length < 0) {
            throw new IllegalArgumentException("requested read length is less than zero");
        }
        if (length > b.length - offset) {
            throw new IllegalArgumentException("requested read length is more than will fit after requested offset in buffer");
        }
        AbfsPerfTracker tracker = this.client.getAbfsPerfTracker();
        try (AbfsPerfInfo perfInfo = new AbfsPerfInfo(tracker, "readRemote", "read");){
            if (this.streamStatistics != null) {
                this.streamStatistics.remoteReadOperation();
            }
            LOG.trace("Trigger client.read for path={} position={} offset={} length={}", new Object[]{this.path, position, offset, length});
            op = this.client.read(this.path, position, b, offset, length, this.tolerateOobAppends ? "*" : this.eTag, this.cachedSasToken.get(), this.contextEncryptionAdapter, tracingContext);
            this.cachedSasToken.update(op.getSasToken());
            LOG.debug("issuing HTTP GET request params position = {} b.length = {} offset = {} length = {}", new Object[]{position, b.length, offset, length});
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
            this.incrementReadOps();
        }
        catch (AzureBlobFileSystemException ex) {
            AbfsRestOperationException ere;
            if (ex instanceof AbfsRestOperationException && (ere = (AbfsRestOperationException)ex).getStatusCode() == 404) {
                throw new FileNotFoundException(ere.getMessage());
            }
            throw new IOException(ex);
        }
        long bytesRead = op.getResult().getBytesReceived();
        if (this.streamStatistics != null) {
            this.streamStatistics.remoteBytesRead(bytesRead);
        }
        if (bytesRead > Integer.MAX_VALUE) {
            throw new IOException("Unexpected Content-Length");
        }
        LOG.debug("HTTP request read bytes = {}", (Object)bytesRead);
        this.bytesFromRemoteRead += bytesRead;
        return (int)bytesRead;
    }

    private void incrementReadOps() {
        if (this.statistics != null) {
            this.statistics.incrementReadOps(1);
        }
    }

    public synchronized void seek(long n) throws IOException {
        LOG.debug("requested seek to position {}", (Object)n);
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        if (n < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        if (n > this.contentLength) {
            throw new EOFException("Attempted to seek or read past the end of the file");
        }
        if (this.streamStatistics != null) {
            this.streamStatistics.seek(n, this.fCursor);
        }
        this.nextReadPos = n;
        LOG.debug("set nextReadPos to {}", (Object)this.nextReadPos);
    }

    public synchronized long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        long currentPos = this.getPos();
        if (currentPos == this.contentLength && n > 0L) {
            throw new EOFException("Attempted to seek or read past the end of the file");
        }
        long newPos = currentPos + n;
        if (newPos < 0L) {
            newPos = 0L;
            n = newPos - currentPos;
        }
        if (newPos > this.contentLength) {
            newPos = this.contentLength;
            n = newPos - currentPos;
        }
        this.seek(newPos);
        return n;
    }

    public synchronized int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        long remaining = this.contentLength - this.getPos();
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    public long length() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        return this.contentLength;
    }

    public synchronized long getPos() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        return this.nextReadPos < 0L ? 0L : this.nextReadPos;
    }

    public TracingContext getTracingContext() {
        return this.tracingContext;
    }

    public boolean seekToNewSource(long l) throws IOException {
        return false;
    }

    public synchronized void close() throws IOException {
        LOG.debug("Closing {}", (Object)this);
        this.closed = true;
        ReadBufferManager.getBufferManager().purgeBuffersForStream(this);
        this.buffer = null;
        if (this.contextEncryptionAdapter != null) {
            this.contextEncryptionAdapter.destroy();
        }
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark()/reset() not supported on this stream");
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("mark()/reset() not supported on this stream");
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void unbuffer() {
        this.buffer = null;
        this.fCursor = this.fCursor - (long)this.limit + (long)this.bCursor;
        this.fCursorAfterLastRead = -1L;
        this.bCursor = 0;
        this.limit = 0;
    }

    public boolean hasCapability(String capability) {
        return "in:unbuffer".equals(org.apache.hadoop.util.StringUtils.toLowerCase((String)capability));
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    @VisibleForTesting
    public boolean isReadAheadEnabled() {
        return this.readAheadEnabled;
    }

    @VisibleForTesting
    public int getReadAheadRange() {
        return this.readAheadRange;
    }

    @VisibleForTesting
    protected void setCachedSasToken(CachedSASToken cachedSasToken) {
        this.cachedSasToken = cachedSasToken;
    }

    @VisibleForTesting
    public String getStreamID() {
        return this.inputStreamId;
    }

    @VisibleForTesting
    public AbfsInputStreamStatistics getStreamStatistics() {
        return this.streamStatistics;
    }

    @VisibleForTesting
    public void registerListener(Listener listener1) {
        this.listener = listener1;
        this.tracingContext.setListener(this.listener);
    }

    @VisibleForTesting
    public long getBytesFromReadAhead() {
        return this.bytesFromReadAhead;
    }

    @VisibleForTesting
    public long getBytesFromRemoteRead() {
        return this.bytesFromRemoteRead;
    }

    @VisibleForTesting
    public int getBufferSize() {
        return this.bufferSize;
    }

    @VisibleForTesting
    protected int getFooterReadBufferSize() {
        return this.footerReadSize;
    }

    @VisibleForTesting
    public int getReadAheadQueueDepth() {
        return this.readAheadQueueDepth;
    }

    @VisibleForTesting
    public boolean shouldAlwaysReadBufferSize() {
        return this.alwaysReadBufferSize;
    }

    public IOStatistics getIOStatistics() {
        return this.ioStatistics;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("AbfsInputStream@(").append(((Object)((Object)this)).hashCode()).append("){");
        sb.append("[fs.azure.capability.readahead.safe]");
        if (this.streamStatistics != null) {
            sb.append(", ").append(this.streamStatistics);
        }
        sb.append("}");
        return sb.toString();
    }

    @VisibleForTesting
    int getBCursor() {
        return this.bCursor;
    }

    @VisibleForTesting
    long getFCursor() {
        return this.fCursor;
    }

    @VisibleForTesting
    long getFCursorAfterLastRead() {
        return this.fCursorAfterLastRead;
    }

    @VisibleForTesting
    long getLimit() {
        return this.limit;
    }

    @VisibleForTesting
    BackReference getFsBackRef() {
        return this.fsBackRef;
    }
}

