/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.partitioning.DimensionType;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;

@UIModel
public abstract class Dimension {
    protected String name;

    public Dimension(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public String getName() {
        return this.name;
    }

    public abstract String getType();

    public abstract DimensionValue getValueFromId(String var1);

    public abstract List<DimensionValue> getValuesFromPattern(String var1);

    public abstract DimensionType toDimensionType();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static void registerJsonAdapter() {
        JSON.registerAdapter(Dimension.class, (Object)new JSON.Adapter<Dimension>(){

            public Dimension deserialize(JsonElement elt, Type type, JsonDeserializationContext ctx) {
                String dtype;
                JsonObject json = elt.getAsJsonObject();
                switch (dtype = json.get("type").getAsString()) {
                    case "time": {
                        return TimeDimension.deserialize(json);
                    }
                    case "value": {
                        return ExactValueDimension.deserialize(json);
                    }
                }
                throw new IllegalArgumentException("Unhandled dimension type : " + dtype);
            }

            public JsonElement serialize(Dimension dimension, Type type, JsonSerializationContext ctx) {
                JsonObject json;
                if (dimension instanceof TimeDimension) {
                    json = TimeDimension.serialize((TimeDimension)dimension);
                } else if (dimension instanceof ExactValueDimension) {
                    json = ExactValueDimension.serialize((ExactValueDimension)dimension);
                } else {
                    throw new IllegalArgumentException("Unhandled dimension type : " + dimension.getClass().getCanonicalName());
                }
                json.addProperty("type", dimension.getType());
                return json;
            }
        });
        JSON.registerAdapter(TimeDimension.class, (Object)new JSON.Adapter<TimeDimension>(){

            public TimeDimension deserialize(JsonElement elt, Type type, JsonDeserializationContext ctx) {
                JsonObject json = elt.getAsJsonObject();
                String dtype = json.get("type").getAsString();
                if (dtype.equals("time")) {
                    return TimeDimension.deserialize(json);
                }
                throw new IllegalArgumentException("Unexpected dimension type : " + dtype + " instead of time");
            }

            public JsonElement serialize(TimeDimension dimension, Type type, JsonSerializationContext ctx) {
                JsonObject json = TimeDimension.serialize(dimension);
                json.addProperty("type", dimension.getType());
                return json;
            }
        });
        JSON.registerAdapter(ExactValueDimension.class, (Object)new JSON.Adapter<ExactValueDimension>(){

            public ExactValueDimension deserialize(JsonElement elt, Type type, JsonDeserializationContext ctx) {
                JsonObject json = elt.getAsJsonObject();
                String dtype = json.get("type").getAsString();
                if (dtype.equals("value")) {
                    return ExactValueDimension.deserialize(json);
                }
                throw new IllegalArgumentException("Unexpected dimension type : " + dtype + " instead of value");
            }

            public JsonElement serialize(ExactValueDimension dimension, Type type, JsonSerializationContext ctx) {
                JsonObject json = ExactValueDimension.serialize(dimension);
                json.addProperty("type", dimension.getType());
                return json;
            }
        });
    }
}

