/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.beans.BeanUtils;

public class NullChecker {
    public static void checkObject(Object object) throws UnexpectedNullValue {
        if (object == null) {
            throw new UnexpectedNullValue("root object", null);
        }
        if (BeanUtils.isSimpleValueType(object.getClass())) {
            return;
        }
        if (object instanceof Collection) {
            NullChecker.checkCollection((Collection)object);
        } else if (object instanceof Map) {
            NullChecker.checkMap((Map)object);
        } else if (object.getClass().isArray()) {
            NullChecker.checkArray(object);
        } else {
            NullChecker.checkObjectFields(object);
        }
    }

    private static void checkArray(Object array) throws UnexpectedNullValue {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            return;
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array, i);
            if (value == null) continue;
            try {
                NullChecker.checkObject(value);
                continue;
            }
            catch (UnexpectedNullValue unexpectedNullValue) {
                throw new UnexpectedNullValue("" + i, unexpectedNullValue);
            }
        }
    }

    private static boolean isNullCheckEnabledForClass(Class<?> clazz) {
        do {
            if (clazz.getAnnotation(UIModel.class) == null) continue;
            return true;
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    private static void checkObjectFields(Object object) throws UnexpectedNullValue {
        Class<?> clazz = object.getClass();
        boolean checkFields = NullChecker.isNullCheckEnabledForClass(clazz);
        for (Field field : FieldUtils.getAllFields(clazz)) {
            Object fieldValue;
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                fieldValue = field.get(object);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Error while reading value of field " + field.getName(), e);
            }
            if (checkFields && fieldValue == null && field.getAnnotation(Nullable.class) == null && field.getAnnotation(UINullable.class) == null && !Modifier.isTransient(field.getModifiers())) {
                throw new UnexpectedNullValue(field.getName() + " (" + clazz.getName() + ")", null);
            }
            try {
                if (fieldValue == null) continue;
                NullChecker.checkObject(fieldValue);
            }
            catch (UnexpectedNullValue unexpectedNullValue) {
                throw new UnexpectedNullValue(field.getName(), unexpectedNullValue);
            }
        }
    }

    private static void checkMap(Map<?, ?> map) throws UnexpectedNullValue {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            try {
                Object value = entry.getValue();
                if (value == null) continue;
                NullChecker.checkObject(value);
            }
            catch (UnexpectedNullValue unexpectedNullValue) {
                throw new UnexpectedNullValue(String.valueOf(entry.getKey()), unexpectedNullValue);
            }
        }
    }

    private static void checkCollection(Collection<?> collection) throws UnexpectedNullValue {
        int i = 0;
        for (Object item : collection) {
            try {
                if (item != null) {
                    NullChecker.checkObject(item);
                }
            }
            catch (UnexpectedNullValue unexpectedNullValue) {
                throw new UnexpectedNullValue("" + i, unexpectedNullValue);
            }
            ++i;
        }
    }

    public static class UnexpectedNullValue
    extends RuntimeException {
        final String location;

        UnexpectedNullValue(String location, UnexpectedNullValue replacedException) {
            super("Unexpected null property: " + UnexpectedNullValue.appendLocation(location, replacedException));
            this.location = UnexpectedNullValue.appendLocation(location, replacedException);
        }

        static String appendLocation(String location, UnexpectedNullValue replacedException) {
            if (replacedException == null) {
                return location;
            }
            return location + "." + replacedException.location;
        }
    }
}

