/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.logging.AutoClosableAppenderWrapper;
import com.dataiku.dip.utils.CRLineReader;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.InheritableNDC;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StreamUtils;
import com.dataiku.dip.utils.WindowsUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class DKUtils {
    private static Map<String, String> extensionToType = Maps.newHashMap();
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    public static final String UNFILTERED_LOG_EVENT_KEY = "__dku_unfiltered";
    private static DKULogger logger;

    public static <T> T lastElement(T[] array) {
        return array[array.length - 1];
    }

    public static void unsafeSleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void setStdoutNotBuffered() {
        System.setOut(new PrintStream(StreamUtils.readFD(FileDescriptor.in, "UTF-8")));
    }

    public static String isoFormat(long ts) {
        return ISODateTimeFormat.basicDateTime().withZone(DateTimeZone.UTC).print(ts);
    }

    public static String isoFormatReadableByDateFormat(long ts) {
        return ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print(ts) + "Z";
    }

    public static String isoFormatReadableByDateOnlyFormat(long ts) {
        return ISODateTimeFormat.date().withZone(DateTimeZone.UTC).print(ts);
    }

    public static String isoFormatReadableByDatetimeNoTzFormat(long ts) {
        return ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print(ts).replace('T', ' ');
    }

    public static String isoFormatReadableByDateFormatFromTimestampWithCorrectToString(Timestamp ts) {
        return ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.getDefault()).print(ts.getTime()) + "Z";
    }

    public static String isoFormatPretty(Date date) {
        return ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print(date.getTime()) + "Z";
    }

    public static String isoFormatPretty(long ts) {
        return ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print(ts);
    }

    public static String formatTSFileCompatible(Long ts) {
        if (ts == null) {
            ts = System.currentTimeMillis();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(new Date(ts));
    }

    public static String indent(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void unsafeClose(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            logger.warn("Could not safely close SQL connection " + String.valueOf(conn), e);
        }
    }

    public static void closeACWithLog(@Nullable AutoCloseable ac, String name) {
        if (ac == null) {
            return;
        }
        try {
            ac.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close " + name, e);
        }
    }

    public static String[] parseClassPath(String classPath) {
        String[] jars;
        ArrayList<String> out = new ArrayList<String>();
        for (String jar : jars = classPath.trim().split(":")) {
            if (jar.endsWith("*")) {
                File[] files = new File(jar.substring(0, jar.length() - 2)).listFiles();
                if (files != null) {
                    for (File file : files) {
                        out.add(file.getAbsolutePath());
                    }
                    continue;
                }
                logger.warn("Invalid jar directory:" + jar);
                continue;
            }
            File file = new File(jar);
            if (file.exists()) {
                out.add(jar);
                continue;
            }
            logger.warn("Invalid jar file:" + jar);
        }
        return out.toArray(new String[out.size()]);
    }

    public static void unsafeRollbackAndClose(Connection conn) {
        try {
            conn.rollback();
            logger.info("Closing " + String.valueOf(conn));
            conn.close();
            logger.info("Conn " + String.valueOf(conn) + " is now " + conn.isClosed());
        }
        catch (Exception e) {
            logger.warn("Could not safely close SQL connection " + String.valueOf(conn), e);
        }
    }

    public static Map<String, String> getEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>();
        if (DKUtils.isOsWindows()) {
            for (Map.Entry<String, String> variable : System.getenv().entrySet()) {
                String name = variable.getKey();
                if (name.startsWith("=")) continue;
                env.put(name, variable.getValue());
            }
        } else {
            env.putAll(System.getenv());
        }
        return env;
    }

    public static String[] environmentArray(Map<String, String> env) {
        String[] result = new String[env.size()];
        int i = 0;
        for (Map.Entry<String, String> e : env.entrySet()) {
            result[i] = e.getKey() + "=" + e.getValue();
            ++i;
        }
        return result;
    }

    public static int execAndLog(String[] args, Map<String, String> env) throws IOException, InterruptedException {
        return new ExecBuilder().withArgs(args).withEnv(env).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(new LoggingLineSubscription(Level.WARN)).exec();
    }

    public static int execAndLog(String[] args, Map<String, String> env, File cwd, String input) throws IOException, InterruptedException {
        return new ExecBuilder().withArgs(args).withEnv(env).withCwd(cwd).withInput(input).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(new LoggingLineSubscription(Level.WARN)).exec();
    }

    public static void execAndLogThrows(String[] args, Map<String, String> env, File cwd) throws IOException, InterruptedException {
        new ExecBuilder().withArgs(args).withEnv(env).withCwd(cwd).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withCompletionHandler(new SimpleExceptionExecCompletionHandler(Lists.newArrayList((Object[])args))).exec();
    }

    public static void execAndLogUnfilteredThrows(String[] args, Map<String, String> env, SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException {
        TailerLineSubscription tailerLineSubscription = new TailerLineSubscription(logTailBuilder);
        String threadName = Thread.currentThread().getName();
        new ExecBuilder().withArgs(args).withEnv(env).withOutputConsumer(new UnfilteredLoggingLineSubscription(Level.DEBUG, threadName)).withOutputConsumer(tailerLineSubscription).withErrorConsumer(new UnfilteredLoggingLineSubscription(Level.DEBUG, threadName)).withErrorConsumer(tailerLineSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(Lists.newArrayList((Object[])args)).withLogTailBuilder(logTailBuilder)).exec();
    }

    public static void execAndLogUnfilteredThrows(String[] args, Map<String, String> env, String input, SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException {
        TailerLineSubscription tailerLineSubscription = new TailerLineSubscription(logTailBuilder);
        String threadName = Thread.currentThread().getName();
        new ExecBuilder().withArgs(args).withEnv(env).withInput(input).withOutputConsumer(new UnfilteredLoggingLineSubscription(Level.DEBUG, threadName)).withOutputConsumer(tailerLineSubscription).withErrorConsumer(new UnfilteredLoggingLineSubscription(Level.DEBUG, threadName)).withErrorConsumer(tailerLineSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(Lists.newArrayList((Object[])args)).withLogTailBuilder(logTailBuilder)).exec();
    }

    public static void execAndLogThrows(String[] args, Map<String, String> env, SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException {
        TailerLineSubscription tailerLineSubscription = new TailerLineSubscription(logTailBuilder);
        new ExecBuilder().withArgs(args).withEnv(env).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withOutputConsumer(tailerLineSubscription).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(tailerLineSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(Lists.newArrayList((Object[])args)).withLogTailBuilder(logTailBuilder)).exec();
    }

    public static void execAndLogThrows(ProcessBuilder pb) throws IOException, InterruptedException {
        DKUtils.execAndLogThrows(pb, "");
    }

    public static void execAndLogThrows(ProcessBuilder pb, String threadBaseName) throws IOException, InterruptedException {
        ExecBuilder execBuilder = new ExecBuilder();
        if (StringUtils.isNotBlank((String)threadBaseName)) {
            execBuilder.withThreadsBaseName(threadBaseName);
        }
        execBuilder.withProcessBuilder(pb).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command())).exec();
    }

    public static void execAndLogToFileThrows(ProcessBuilder pb, File f) throws IOException, InterruptedException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(new OutputStreamSubscription(fos, false)).withErrorConsumer(new OutputStreamSubscription(fos, false)).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command())).exec();
        }
    }

    public static void execAndLogUnfilteredThrows(ProcessBuilder pb, SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException {
        TailerLineSubscription tailerLineSubscription = new TailerLineSubscription(logTailBuilder);
        String threadName = Thread.currentThread().getName();
        new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(new UnfilteredLoggingLineSubscription(Level.DEBUG, threadName)).withOutputConsumer(tailerLineSubscription).withErrorConsumer(new UnfilteredLoggingLineSubscription(Level.DEBUG, threadName)).withErrorConsumer(tailerLineSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command()).withLogTailBuilder(logTailBuilder)).exec();
    }

    public static void execAndLogThrows(ProcessBuilder pb, SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException {
        TailerLineSubscription tailerLineSubscription = new TailerLineSubscription(logTailBuilder);
        new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withOutputConsumer(tailerLineSubscription).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(tailerLineSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command()).withLogTailBuilder(logTailBuilder)).exec();
    }

    public static void execAndLogWithErrorInException(ProcessBuilder pb, SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException {
        TailerLineSubscription tailerLineSubscription = new TailerLineSubscription(logTailBuilder);
        ErrorCollectingExecCompletionHandler completionHandler = new ErrorCollectingExecCompletionHandler(pb.command());
        new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(tailerLineSubscription).withOutputConsumer(completionHandler).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(tailerLineSubscription).withErrorConsumer(completionHandler).withCompletionHandler(completionHandler).exec();
    }

    public static int execAndLogToFileMirrorWithThreadBaseName(String[] args, Map<String, String> env, File cwd, String threadsBaseName, File f, boolean appendToLog) throws IOException, InterruptedException {
        try (FileOutputStream fos = new FileOutputStream(f, appendToLog);){
            int n = new ExecBuilder().withArgs(args).withEnv(env).withCwd(cwd).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withOutputConsumer(new OutputStreamSubscription(fos, false)).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(new OutputStreamSubscription(fos, false)).withThreadsBaseName(threadsBaseName).exec();
            return n;
        }
    }

    public static void execAndLogThrowsMirror(String[] args, Map<String, String> env, File cwd, File log) throws IOException, InterruptedException {
        try (FileOutputStream os = new FileOutputStream(log, true);){
            OutputStreamSubscription osSubscription = new OutputStreamSubscription(os, false);
            new ExecBuilder().withArgs(args).withEnv(env).withCwd(cwd).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withOutputConsumer(osSubscription).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(osSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(Lists.newArrayList((Object[])args))).exec();
        }
    }

    public static void execAndLogThrowsMirror(ProcessBuilder pb, File log) throws IOException, InterruptedException {
        try (FileOutputStream os = new FileOutputStream(log, true);){
            OutputStreamSubscription osSubscription = new OutputStreamSubscription(os, false);
            new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withOutputConsumer(osSubscription).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(osSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command())).exec();
        }
    }

    public static void execAndLogThrowsMirror(ProcessBuilder pb, SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        try (FileOutputStream os = new FileOutputStream(log, true);){
            TailerLineSubscription tailerLineSubscription = new TailerLineSubscription(logTailBuilder);
            OutputStreamSubscription osSubscription = new OutputStreamSubscription(os, false);
            new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withOutputConsumer(osSubscription).withOutputConsumer(tailerLineSubscription).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(osSubscription).withErrorConsumer(tailerLineSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command())).exec();
        }
    }

    public static void execAndLogThrowsMirror(ProcessBuilder pb, SmartLogTailBuilder logTailBuilder, File log, String failureMessage) throws IOException, InterruptedException {
        try (FileOutputStream os = new FileOutputStream(log, true);){
            TailerLineSubscription tailerLineSubscription = new TailerLineSubscription(logTailBuilder);
            OutputStreamSubscription osSubscription = new OutputStreamSubscription(os, false);
            new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(new LoggingLineSubscription(Level.INFO)).withOutputConsumer(osSubscription).withOutputConsumer(tailerLineSubscription).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(osSubscription).withErrorConsumer(tailerLineSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(failureMessage)).exec();
        }
    }

    public static byte[] execAndGetOutput(String[] args, Map<String, String> env) throws IOException, InterruptedException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        new ExecBuilder().withArgs(args).withEnv(env).withOutputConsumer(outputCollector).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withCompletionHandler(new SimpleExceptionExecCompletionHandler(Lists.newArrayList((Object[])args))).exec();
        return outputCollector.getCollected();
    }

    public static byte[] execAndGetOutputWithThreadsBaseName(String threadsBaseName, String[] args, Map<String, String> env) throws IOException, InterruptedException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        new ExecBuilder().withArgs(args).withEnv(env).withThreadsBaseName(threadsBaseName).withOutputConsumer(outputCollector).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withCompletionHandler(new SimpleExceptionExecCompletionHandler(Lists.newArrayList((Object[])args))).exec();
        return outputCollector.getCollected();
    }

    public static byte[] execAndGetOutput(ProcessBuilder pb) throws IOException, InterruptedException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(outputCollector).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command())).exec();
        return outputCollector.getCollected();
    }

    public static byte[] execAndLogAndGetOutput(ProcessBuilder pb, File log) throws IOException, InterruptedException {
        try (FileOutputStream os = new FileOutputStream(log, true);){
            ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
            OutputStreamSubscription osSubscription = new OutputStreamSubscription(os, false);
            new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(outputCollector).withOutputConsumer(osSubscription).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(osSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command())).exec();
            byte[] byArray = outputCollector.getCollected();
            return byArray;
        }
    }

    public static byte[] execAndLogAndGetOutput(ProcessBuilder pb, SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        try (FileOutputStream os = new FileOutputStream(log, true);){
            ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
            OutputStreamSubscription osSubscription = new OutputStreamSubscription(os, false);
            TailerLineSubscription tailerLineSubscription = new TailerLineSubscription(logTailBuilder);
            new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(outputCollector).withOutputConsumer(osSubscription).withOutputConsumer(tailerLineSubscription).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(osSubscription).withErrorConsumer(tailerLineSubscription).withCompletionHandler(new SimpleExceptionExecCompletionHandler(pb.command())).exec();
            byte[] byArray = outputCollector.getCollected();
            return byArray;
        }
    }

    public static byte[] execAndGetOutput(ProcessBuilder pb, String message) throws IOException, InterruptedException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(outputCollector).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withCompletionHandler(new SimpleExceptionExecCompletionHandler(message)).exec();
        return outputCollector.getCollected();
    }

    public static byte[] execAndGetOutputWithErrorInException(String[] args, Map<String, String> env) throws IOException, InterruptedException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        ErrorCollectingExecCompletionHandler completionHandler = new ErrorCollectingExecCompletionHandler();
        new ExecBuilder().withArgs(args).withEnv(env).withOutputConsumer(outputCollector).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(completionHandler).withCompletionHandler(completionHandler).exec();
        return outputCollector.getCollected();
    }

    public static byte[] execAndGetOutputWithErrorInException(ProcessBuilder pb, String message) throws IOException, InterruptedException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        ErrorCollectingExecCompletionHandler completionHandler = new ErrorCollectingExecCompletionHandler(message);
        return DKUtils.execAndGetOutputWithErrorInException(pb, outputCollector, completionHandler);
    }

    public static byte[] execAndGetOutputWithErrorInException(ProcessBuilder pb, ByteCollectingSubscription outputCollector, ErrorCollectingExecCompletionHandler completionHandler) throws IOException, InterruptedException {
        new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(outputCollector).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withErrorConsumer(completionHandler).withCompletionHandler(completionHandler).exec();
        return outputCollector.getCollected();
    }

    public static void execAndWriteOutput(String[] args, Map<String, String> env, File cwd, OutputStream output) throws IOException, InterruptedException {
        new ExecBuilder().withArgs(args).withEnv(env).withCwd(cwd).withOutputConsumer(new OutputStreamSubscription(output, false)).withErrorConsumer(new LoggingLineSubscription(Level.INFO)).withCompletionHandler(new SimpleExceptionExecCompletionHandler(Lists.newArrayList((Object[])args))).exec();
    }

    public static ExecutionResults execAndGetOutputAndErrors(ProcessBuilder pb) throws InterruptedException, IOException {
        return DKUtils.execAndGetOutputAndErrors(pb, null);
    }

    public static ExecutionResults execAndGetOutputAndErrors(ProcessBuilder pb, Long timeout) throws InterruptedException, IOException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        ByteCollectingSubscription errorCollector = new ByteCollectingSubscription();
        ExecutionResults er = new ExecutionResults();
        er.rv = new ExecBuilder().withProcessBuilder(pb).withOutputConsumer(outputCollector).withErrorConsumer(errorCollector).withTimeout(timeout).exec();
        er.out = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
        er.err = new String(errorCollector.getCollected(), StandardCharsets.UTF_8);
        return er;
    }

    public static ExecutionResults execAndGetOutputAndErrors(String[] args, Map<String, String> env) throws InterruptedException, IOException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        ByteCollectingSubscription errorCollector = new ByteCollectingSubscription();
        ExecutionResults er = new ExecutionResults();
        er.rv = new ExecBuilder().withArgs(args).withEnv(env).withOutputConsumer(outputCollector).withErrorConsumer(errorCollector).exec();
        er.out = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
        er.err = new String(errorCollector.getCollected(), StandardCharsets.UTF_8);
        return er;
    }

    public static ExecutionResults execAndGetOutputAndErrors(String[] args, Map<String, String> env, SmartLogTailBuilder tailBuilder) throws InterruptedException, IOException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        ByteCollectingSubscription errorCollector = new ByteCollectingSubscription();
        TailerLineSubscription tailerLineSubscription = new TailerLineSubscription(tailBuilder);
        ExecutionResults er = new ExecutionResults();
        er.rv = new ExecBuilder().withArgs(args).withEnv(env).withOutputConsumer(outputCollector).withOutputConsumer(tailerLineSubscription).withErrorConsumer(errorCollector).withErrorConsumer(tailerLineSubscription).exec();
        er.out = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
        er.err = new String(errorCollector.getCollected(), StandardCharsets.UTF_8);
        return er;
    }

    public static ExecutionResults execAndGetOutputAndErrorsWithThreadsBasename(String[] args, Map<String, String> env, String threadsBaseName) throws InterruptedException, IOException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        ByteCollectingSubscription errorCollector = new ByteCollectingSubscription();
        ExecutionResults er = new ExecutionResults();
        er.rv = new ExecBuilder().withArgs(args).withEnv(env).withOutputConsumer(outputCollector).withErrorConsumer(errorCollector).withThreadsBaseName(threadsBaseName).exec();
        er.out = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
        er.err = new String(errorCollector.getCollected(), StandardCharsets.UTF_8);
        return er;
    }

    public static ExecutionResults execAndGetOutputAndErrors(String[] args, Map<String, String> env, String input) throws InterruptedException, IOException {
        ByteCollectingSubscription outputCollector = new ByteCollectingSubscription();
        ByteCollectingSubscription errorCollector = new ByteCollectingSubscription();
        ExecutionResults er = new ExecutionResults();
        er.rv = new ExecBuilder().withArgs(args).withEnv(env).withInput(input).withOutputConsumer(outputCollector).withErrorConsumer(errorCollector).exec();
        er.out = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
        er.err = new String(errorCollector.getCollected(), StandardCharsets.UTF_8);
        return er;
    }

    public static String tailFile(File f, int nlines) throws IOException {
        long skip = Math.max(0L, f.length() - (long)nlines * 2000L);
        LinkedList<String> lines = new LinkedList<String>();
        try (InputStream fis = DKUFileUtils.readWithAutoDecompress(f);){
            String line;
            fis.skip(skip);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis, "utf8"));
            while ((line = br.readLine()) != null) {
                lines.add(line);
                if (lines.size() <= nlines) continue;
                lines.remove(0);
            }
        }
        lines.add("");
        return Joiner.on((char)'\n').join(lines);
    }

    public static SmartLogTail smartTailFile(File f, int nlines) throws IOException {
        SmartLogTailBuilder builder = new SmartLogTailBuilder(nlines);
        try (InputStream is = DKUFileUtils.readWithAutoDecompress(f);
             BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line = br.readLine();
            while (line != null) {
                builder.appendLine(line);
                line = br.readLine();
            }
        }
        return builder.get();
    }

    public static Map<String, String> parseKVStringArray(String[] array) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String val : array) {
            String[] chunks = val.split("=");
            if (chunks.length < 2) {
                throw new IllegalArgumentException("Illegal param: " + val + ", expected key=value");
            }
            String paramValue = val.substring(chunks[0].length() + 1);
            map.put(chunks[0], paramValue);
        }
        return map;
    }

    public static Map<String, String> parseKVStringArray(Collection<String> array) {
        return DKUtils.parseKVStringArray(array.toArray(new String[0]));
    }

    public static byte[] getResourceFileContent(String file) throws IOException {
        try (InputStream is = DKUtils.class.getClassLoader().getResourceAsStream(file);){
            if (is == null) {
                throw new Error("Can't open resource file " + file);
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    public static String getResourceFileContentUTF8(String file) throws IOException {
        try (InputStream is = DKUtils.class.getClassLoader().getResourceAsStream(file);){
            if (is == null) {
                throw new Error("Can't open resource file " + file);
            }
            String string = IOUtils.toString((InputStream)is, (String)"utf8");
            return string;
        }
    }

    public static <T> Map<String, T> listToMap(List<T> list, String memberOrFunction) {
        HashMap<String, T> ret = new HashMap<String, T>();
        if (list.isEmpty()) {
            return ret;
        }
        Class<?> tclazz = list.get(0).getClass();
        try {
            if (memberOrFunction.endsWith("()")) {
                Method m = tclazz.getMethod(memberOrFunction.replace("()", ""), new Class[0]);
                for (T obj : list) {
                    String key = (String)m.invoke(obj, new Object[0]);
                    ret.put(key, obj);
                }
            } else {
                Field f = tclazz.getField(memberOrFunction);
                for (T obj : list) {
                    String key = (String)f.get(obj);
                    ret.put(key, obj);
                }
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return ret;
    }

    public static <T> void listRemove(List<T> list, String memberOrFunction, String needle) {
        if (list.isEmpty()) {
            return;
        }
        Class<?> tclazz = list.get(0).getClass();
        try {
            if (memberOrFunction.endsWith("()")) {
                Method m = tclazz.getMethod(memberOrFunction.replace("()", ""), new Class[0]);
                ListIterator<T> it = list.listIterator();
                while (it.hasNext()) {
                    String key = (String)m.invoke(it.next(), new Object[0]);
                    if (!key.equals(needle)) continue;
                    it.remove();
                }
            } else {
                ListIterator<T> it = list.listIterator();
                Field f = tclazz.getField(memberOrFunction);
                while (it.hasNext()) {
                    String key = (String)f.get(it.next());
                    if (!key.equals(needle)) continue;
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static <T> T listFind(List<T> list, String memberOrFunction, String needle) {
        if (list.isEmpty()) {
            return null;
        }
        Class<?> tclazz = list.get(0).getClass();
        try {
            if (memberOrFunction.endsWith("()")) {
                Method m = tclazz.getMethod(memberOrFunction.replace("()", ""), new Class[0]);
                for (T obj : list) {
                    String key = (String)m.invoke(obj, new Object[0]);
                    if (!key.equals(needle)) continue;
                    return obj;
                }
            } else {
                Field f = tclazz.getField(memberOrFunction);
                for (T obj : list) {
                    String key = (String)f.get(obj);
                    if (!key.equals(needle)) continue;
                    return obj;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static <T> void listSort(List<T> list, String memberOrFunction, final boolean reverse) {
        block7: {
            if (list.isEmpty()) {
                return;
            }
            Class<?> tclazz = list.get(0).getClass();
            try {
                if (memberOrFunction.endsWith("()")) {
                    final Method m = tclazz.getMethod(memberOrFunction.replace("()", ""), new Class[0]);
                    Collections.sort(list, new Comparator<T>(){

                        @Override
                        public int compare(T o1, T o2) {
                            try {
                                String s1 = (String)m.invoke(o1, new Object[0]);
                                String s2 = (String)m.invoke(o2, new Object[0]);
                                return reverse ? s2.compareTo(s1) : s1.compareTo(s2);
                            }
                            catch (Exception e) {
                                throw new Error(e);
                            }
                        }
                    });
                    break block7;
                }
                final Field f = tclazz.getField(memberOrFunction);
                if (!f.getType().isPrimitive()) {
                    Collections.sort(list, new Comparator<T>(){

                        @Override
                        public int compare(T o1, T o2) {
                            try {
                                String s1 = (String)f.get(o1);
                                String s2 = (String)f.get(o1);
                                return reverse ? s2.compareTo(s1) : s1.compareTo(s2);
                            }
                            catch (Exception e) {
                                throw new Error(e);
                            }
                        }
                    });
                    break block7;
                }
                if (f.getType() == Integer.TYPE) {
                    Collections.sort(list, new Comparator<T>(){

                        @Override
                        public int compare(T o1, T o2) {
                            try {
                                int i1 = f.getInt(o1);
                                int i2 = f.getInt(o2);
                                return reverse ? Integer.compare(i2, i1) : Integer.compare(i1, i2);
                            }
                            catch (Exception e) {
                                throw new Error(e);
                            }
                        }
                    });
                    break block7;
                }
                if (f.getType() == Long.TYPE) {
                    Collections.sort(list, new Comparator<T>(){

                        @Override
                        public int compare(T o1, T o2) {
                            try {
                                long i1 = f.getLong(o1);
                                long i2 = f.getLong(o2);
                                return reverse ? Long.compare(i2, i1) : Long.compare(i1, i2);
                            }
                            catch (Exception e) {
                                throw new Error(e);
                            }
                        }
                    });
                    break block7;
                }
                throw new Error("Unsupported type for sort : " + String.valueOf(f.getType()));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    public static int getPid(Process p) {
        return !DKUtils.isOsWindows() ? DKUtils.getUnixPid(p) : WindowsUtils.getPid(p);
    }

    public static int getOwnPid() {
        return !DKUtils.isOsWindows() ? DKUtils.getUnixOwnPid() : WindowsUtils.getOwnPid();
    }

    private static int getUnixPid(Process p) {
        if (p.getClass().getName().equals("java.lang.UNIXProcess") || p.getClass().getName().equals("java.lang.ProcessImpl")) {
            return (int)p.pid();
        }
        return 0;
    }

    private static int getUnixOwnPid() {
        int pid = 0;
        try {
            byte[] output = DKUtils.execAndGetOutput(new String[]{"sh", "-c", "echo $PPID"}, new HashMap<String, String>());
            return Integer.parseInt(new String(output, StandardCharsets.UTF_8).trim());
        }
        catch (Exception e) {
            logger.info("Unable to inspect JVM to grab its PID", e);
            return pid;
        }
    }

    private static List<Long> getChildrenPids(long pid) {
        try {
            Optional<ProcessHandle> ph = ProcessHandle.of(pid);
            if (ph.isEmpty()) {
                logger.warnV("Process %d does not exist", pid);
                return new ArrayList<Long>();
            }
            List<Long> children = ph.get().children().map(ProcessHandle::pid).toList();
            logger.infoV("Found %d children for process PID %d", children.size(), pid);
            return children;
        }
        catch (Exception e) {
            logger.warnV(e, "Unable to list children of process PID %d", pid);
            return new ArrayList<Long>();
        }
    }

    private static void evilKillPIDNoException(long pid, Long parentPid) {
        Object formattedParentPid = parentPid == null ? "root of tree" : "parent PID " + parentPid;
        logger.infoV("Killing process PID %d (%s)", pid, formattedParentPid);
        String killCommand = (DKUtils.isOsWindows() ? "taskkill /F /PID " : "kill -SIGKILL ") + pid;
        try {
            Runtime.getRuntime().exec(killCommand).waitFor();
        }
        catch (IOException | InterruptedException e) {
            logger.errorV(e, "Failed to kill process PID %d", pid);
        }
    }

    private static void recursiveEvilKillChildrenProcesses(long pid, Long parentPid) {
        List<Long> childrenPids = DKUtils.getChildrenPids(pid);
        DKUtils.evilKillPIDNoException(pid, parentPid);
        for (long childPid : childrenPids) {
            DKUtils.recursiveEvilKillChildrenProcesses(childPid, pid);
        }
    }

    public static void evilKillWholeProcessTree(Process p) {
        int pid = DKUtils.getPid(p);
        logger.infoV("Killing whole process tree rooted at PID: %d, from root to leaves", pid);
        DKUtils.recursiveEvilKillChildrenProcesses(pid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killProcessTree(Process p) throws IOException {
        int pid = DKUtils.getPid(p);
        if (pid > 0) {
            logger.info("Killing pid " + pid);
            boolean interrupted = Thread.interrupted();
            try {
                if (!DKUtils.isOsWindows()) {
                    Runtime.getRuntime().exec("/usr/bin/pkill -KILL -P " + pid).waitFor();
                    Runtime.getRuntime().exec("/bin/kill -9 " + pid).waitFor();
                }
                Runtime.getRuntime().exec("taskkill /T /PID " + pid).waitFor();
                Runtime.getRuntime().exec("taskkill /T /F /PID " + pid).waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Interrupted while killing");
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            throw new IOException("Unable to find pid of process to kill");
        }
    }

    public static void niceKill(Process p) {
        int pid = DKUtils.getPid(p);
        try {
            if (!DKUtils.isOsWindows()) {
                Runtime.getRuntime().exec("kill -SIGINT " + pid);
            } else {
                Runtime.getRuntime().exec("taskkill /T /PID " + pid);
            }
        }
        catch (IOException e) {
            logger.error("Nice kill failed (pid=" + pid + ")", e);
        }
    }

    public static void dumpJvmStacks(int pid, File dir) {
        try {
            if (!DKUtils.isOsWindows()) {
                Runtime.getRuntime().exec("kill -SIGQUIT " + pid);
                Thread.sleep(1000L);
            } else {
                File javabin = new File(System.getenv("DKUJAVABIN"));
                javabin = javabin.getCanonicalFile();
                File jstackbin = new File(javabin.getParentFile(), "jstack.exe");
                DKUtils.execAndLogToFileThrows(new ProcessBuilder(jstackbin.getAbsolutePath(), String.valueOf(pid)), new File(dir, "jek.stacks"));
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("Threaddump failed (pid=" + pid + ")", e);
        }
    }

    public static void evilKill(Process p) {
        int pid = DKUtils.getPid(p);
        logger.info(String.format("Killing process PID: %d", pid));
        try {
            if (DKUtils.isOsWindows()) {
                Runtime.getRuntime().exec("taskkill /T /F /PID " + pid).waitFor();
                p.destroy();
            } else {
                p.destroy();
                Runtime.getRuntime().exec("kill -SIGKILL " + pid);
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("Evil kill failed (pid=" + pid + ")", e);
        }
    }

    public static void forceInit(Class<?> cl) {
        try {
            Class.forName(cl.getName(), true, cl.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static <T> Iterable<T> iterSafe(Iterable<T> input) {
        if (input != null) {
            return input;
        }
        return new ArrayList();
    }

    public static String md5Base64(String data) {
        return Base64.encodeBase64String((byte[])DigestUtils.md5((String)data)).substring(0, 22);
    }

    public static Calendar getUTCCalendar() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setLenient(false);
        return cal;
    }

    public static SimpleDateFormat getSimpleDateFormatUTCStrict(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(false);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    }

    public static DateTimeFormatter getDateFormatter(String format) {
        return DateTimeFormat.forPattern((String)format).withZone(DateTimeZone.UTC);
    }

    public static DateTimeFormatter getISODateFormatter() {
        return ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    }

    public static File nextFileInSequence(File folder, String prefix) {
        if (!folder.isDirectory()) {
            return new File(folder, prefix + "1");
        }
        HashSet names = Sets.newHashSet((Object[])folder.list());
        int i = 0;
        while (names.contains(prefix + ++i)) {
        }
        return new File(folder, prefix + i);
    }

    public static File nextFileInSequence(File folder, String prefix, String suffix) {
        String[] folderList = folder.list();
        if (!folder.isDirectory() || folderList == null) {
            return new File(folder, prefix + "1" + suffix);
        }
        int maxId = 0;
        Pattern seqPattern = Pattern.compile(String.format("^%s(?<id>[0-9]+)%s$", Pattern.quote(prefix), Pattern.quote(suffix)));
        Matcher seqMatcher = seqPattern.matcher("");
        for (String element : folderList) {
            if (!seqMatcher.reset(element).find()) continue;
            maxId = Math.max(maxId, Integer.parseInt(seqMatcher.group("id")));
        }
        return new File(folder, prefix + ++maxId + suffix);
    }

    public static File lastFileInSequence(File folder, String prefix) {
        if (!folder.isDirectory() || folder.list() == null || folder.list().length == 0) {
            return null;
        }
        HashSet names = Sets.newHashSet((Object[])folder.list());
        int i = 0;
        while (names.contains(prefix + ++i)) {
        }
        return new File(folder, prefix + (i - 1));
    }

    public static String probeContentTypeWithFallback(File file) {
        String mimeType = null;
        try {
            String extensionMimeType;
            mimeType = Files.probeContentType(file.toPath());
            if (mimeType != null && "text/plain".equals(mimeType) && DKUtils.isTextLikeMimeType(extensionMimeType = DKUtils.guessMimeTypeFromExtension(file.getName()))) {
                mimeType = extensionMimeType;
            }
        }
        catch (IOException e) {
            logger.warn("Could not probe a file's content type", e);
        }
        if (mimeType == null) {
            mimeType = DKUtils.guessMimeTypeFromFile(file);
        }
        return mimeType;
    }

    public static String guessMimeTypeFromExtension(String file) {
        String extension;
        if (file.indexOf(46) > 0 && extensionToType.containsKey(extension = file.substring(file.lastIndexOf(46) + 1).toLowerCase())) {
            return extensionToType.get(extension);
        }
        return DEFAULT_MIME_TYPE;
    }

    private static boolean isInRecipesFolder(File file) {
        File parent = file.getParentFile();
        return parent != null && parent.getName().equals("recipes");
    }

    public static String guessMimeTypeFromFile(File file) {
        String mimeType = DKUtils.guessMimeTypeFromExtension(file.getName());
        if (mimeType.equals(DEFAULT_MIME_TYPE) && DKUtils.isInRecipesFolder(file)) {
            return "application/json";
        }
        return mimeType;
    }

    public static boolean isTextLikeMimeType(String mimeType) {
        boolean isText = false;
        for (String prefix : new String[]{"text"}) {
            if (mimeType == null || !mimeType.startsWith(prefix)) continue;
            isText = true;
            break;
        }
        for (String suffix : new String[]{"/plain", "+json", "/json", "/javascript", "python", "scala", "sql"}) {
            if (mimeType == null || !mimeType.endsWith(suffix)) continue;
            isText = true;
            break;
        }
        return isText;
    }

    public static void startLogAppender(Appender appender) {
        Logger rootLogger = Logger.getRootLogger();
        if (!rootLogger.isAttached(appender)) {
            String pattern = "%-4r [%t] %-5p %c %x - %m%n";
            Enumeration enumeration = rootLogger.getAllAppenders();
            while (enumeration.hasMoreElements()) {
                Appender a = (Appender)enumeration.nextElement();
                if (a.getLayout() == null || !(a.getLayout() instanceof PatternLayout)) continue;
                PatternLayout pl = (PatternLayout)a.getLayout();
                pattern = pl.getConversionPattern();
                break;
            }
            appender.setLayout((Layout)new PatternLayout(pattern));
            rootLogger.addAppender(appender);
        }
    }

    public static AutoClosableAppenderWrapper appendCurrentThreadLogsToLogFile(File log) throws Exception {
        String threadName = Thread.currentThread().getName();
        return DKUtils.appendThreadLogsToLogFile(log, threadName);
    }

    public static AutoClosableAppenderWrapper appendThreadLogsToLogFile(File log, final String threadName) throws Exception {
        try {
            RollingFileAppender logFileAppender = new RollingFileAppender();
            logFileAppender.setMaximumFileSize(0xA00000L);
            logFileAppender.setMaxBackupIndex(4);
            logFileAppender.setThreshold((Priority)Level.DEBUG);
            logFileAppender.setFile(log.getAbsolutePath(), true, false, 0);
            logFileAppender.addFilter(new Filter(){

                public int decide(LoggingEvent loggingEvent) {
                    if (StringUtils.equals((String)loggingEvent.getThreadName(), (String)threadName) || loggingEvent.getPropertyKeySet().contains(DKUtils.UNFILTERED_LOG_EVENT_KEY) && StringUtils.equals((String)loggingEvent.getProperty(DKUtils.UNFILTERED_LOG_EVENT_KEY), (String)threadName)) {
                        return 1;
                    }
                    return -1;
                }
            });
            DKUtils.startLogAppender((Appender)logFileAppender);
            return new AutoClosableAppenderWrapper((Appender)logFileAppender);
        }
        catch (Exception e) {
            Object message = "Error setting saving of thread logs";
            if (log != null) {
                message = (String)message + " in " + log.getAbsolutePath();
            }
            throw new Exception((String)message, e);
        }
    }

    public static int hashCode(Object ... args) {
        int h = 17;
        for (Object arg : args) {
            h = 31 * h + Objects.hashCode((Object[])new Object[]{arg});
        }
        return h;
    }

    public static String escapeRegex(String p) {
        if (p == null) {
            return null;
        }
        return p.replaceAll("([\\\\\\*\\+\\.\\|\\^\\$\\?\\(\\[\\{\\)\\]\\}])", "\\\\$1");
    }

    public static Double defaultIfNan(Double value, double defaultValue) {
        if (value == null || !Double.isNaN(value)) {
            return value;
        }
        return defaultValue;
    }

    public static boolean isOsWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static boolean isOsMacOS() {
        return SystemUtils.IS_OS_MAC_OSX;
    }

    public static boolean isOnMacSilicon() {
        if (!DKUtils.isOsMacOS()) {
            return false;
        }
        try {
            ProcessBuilder pb = new ProcessBuilder("env", "/usr/bin/arch", "-arm64", "uname", "-p");
            String output = new String(DKUtils.execAndGetOutput(pb, "Unable to detect MacOs base architecture."), StandardCharsets.UTF_8).trim();
            if ("arm".equals(output)) {
                return true;
            }
        }
        catch (IOException | InterruptedException e) {
            logger.info("Unable to detect MacOs base architecture.");
        }
        return false;
    }

    public static String getElapsed(Stopwatch sw) {
        return sw.elapsed(TimeUnit.MILLISECONDS) + " ms";
    }

    public static void easyScheduleRecurring(String threadName, Runnable function, long delayMS) {
        ScheduledExecutorService es = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, threadName));
        es.scheduleWithFixedDelay(function, 0L, delayMS, TimeUnit.MILLISECONDS);
    }

    static {
        extensionToType.put("txt", "text/plain");
        extensionToType.put("text", "text/plain");
        extensionToType.put("log", "text/plain");
        extensionToType.put("xhtml", "application/xhtml+xml");
        extensionToType.put("xht", "application/xhtml+xml");
        extensionToType.put("xml", "application/xml");
        extensionToType.put("xsl", "application/xml");
        extensionToType.put("dtd", "application/xml-dtd");
        extensionToType.put("xslt", "application/xslt+xml");
        extensionToType.put("html", "text/html");
        extensionToType.put("htm", "text/html");
        extensionToType.put("tar", "application/x-tar");
        extensionToType.put("pdf", "application/pdf");
        extensionToType.put("bz", "application/x-bzip");
        extensionToType.put("bz2", "application/x-bzip2");
        extensionToType.put("boz", "application/x-bzip2");
        extensionToType.put("zip", "application/zip");
        extensionToType.put("gz", "application/x-gzip");
        extensionToType.put("gzip", "application/x-gzip");
        extensionToType.put("jar", "application/java-archive");
        extensionToType.put("js", "application/javascript");
        extensionToType.put("geojson", "application/vnd.geo+json");
        extensionToType.put("json", "application/json");
        extensionToType.put("bmp", "image/bmp");
        extensionToType.put("gif", "image/gif");
        extensionToType.put("jpeg", "image/jpeg");
        extensionToType.put("jpg", "image/jpeg");
        extensionToType.put("jpe", "image/jpeg");
        extensionToType.put("png", "image/png");
        extensionToType.put("svg", "image/svg+xml");
        extensionToType.put("svgz", "image/svg+xml");
        extensionToType.put("tiff", "image/tiff");
        extensionToType.put("tif", "image/tiff");
        extensionToType.put("ico", "image/x-icon");
        extensionToType.put("ico", "image/x-icon");
        extensionToType.put("py", "text/x-python");
        extensionToType.put("jl", "text/x-julia");
        extensionToType.put("r", "text/x-rsrc");
        extensionToType.put("scala", "text/x-scala");
        extensionToType.put("sh", "text/x-sh");
        extensionToType.put("sql", "text/x-sql");
        extensionToType.put("csv", "text/plain");
        extensionToType.put("md", "text/x-markdown");
        extensionToType.put("h5", "application/x-hdf");
        extensionToType.put("ipynb", "application/x-ipynb+json");
        logger = DKULogger.getLogger("dku.utils");
    }

    public static class ExecBuilder {
        private String threadsBaseName;
        private List<ExecSubscription> outputConsumers = Lists.newArrayList();
        private List<ExecSubscription> errorConsumers = Lists.newArrayList();
        private List<ExecCleanuper> cleanupers = Lists.newArrayList();
        private ProcessBuilder pb;
        private String[] args;
        private Map<String, String> env;
        private File cwd;
        private String input;
        private ExecCompletionHandler completionHandler;
        private LazyInitExecKiller killer;
        private Long timeout;

        public ExecBuilder withThreadsBaseName(String threadsBaseName) {
            this.threadsBaseName = threadsBaseName;
            return this;
        }

        public ExecBuilder withCompletionHandler(ExecCompletionHandler completionHandler) {
            this.completionHandler = completionHandler;
            completionHandler.init(this);
            return this;
        }

        public ExecBuilder withOutputConsumer(ExecSubscription consumer) {
            this.outputConsumers.add(consumer);
            return this;
        }

        public ExecBuilder withErrorConsumer(ExecSubscription consumer) {
            this.errorConsumers.add(consumer);
            return this;
        }

        public ExecBuilder withOutputConsumers(List<ExecSubscription> consumers) {
            this.outputConsumers.addAll(consumers);
            return this;
        }

        public ExecBuilder withErrorConsumers(List<ExecSubscription> consumers) {
            this.errorConsumers.addAll(consumers);
            return this;
        }

        public ExecBuilder withCleanuper(ExecCleanuper cleanuper) {
            this.cleanupers.add(cleanuper);
            return this;
        }

        public ExecBuilder withCleanupers(List<ExecCleanuper> cleanupers) {
            this.cleanupers.addAll(cleanupers);
            return this;
        }

        public ExecBuilder withProcessBuilder(ProcessBuilder pb) {
            if (this.args != null) {
                throw new IllegalArgumentException("Cannot set process builder after args");
            }
            this.pb = pb;
            return this;
        }

        public ExecBuilder withTimeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public ExecBuilder withArgs(List<String> args) {
            return this.withArgs(args.toArray(new String[0]));
        }

        public ExecBuilder withArgs(String[] args) {
            if (this.pb != null) {
                throw new IllegalArgumentException("Cannot set args after process builder");
            }
            this.args = args;
            return this;
        }

        public ExecBuilder withEnv(Map<String, String> env) {
            if (this.env == null) {
                this.env = env;
            } else {
                this.env.putAll(env);
            }
            return this;
        }

        public ExecBuilder withEnv(String key, String value) {
            if (this.env == null) {
                this.env = Maps.newHashMap();
            }
            this.env.put(key, value);
            return this;
        }

        public ExecBuilder withCwd(File cwd) {
            this.cwd = cwd;
            return this;
        }

        public ExecBuilder withInput(String input) {
            this.input = input;
            return this;
        }

        public ExecBuilder withKiller(LazyInitExecKiller killer) {
            this.killer = killer;
            return this;
        }

        public ExecKiller makeNiceThenEvilKiller() {
            NiceThenEvilKiller evilKiller = new NiceThenEvilKiller();
            this.withKiller(evilKiller);
            return evilKiller;
        }

        public int exec() throws IOException, InterruptedException {
            if (this.args != null) {
                this.pb = new ProcessBuilder(this.args);
            }
            if (this.env != null) {
                this.pb.environment().putAll(this.env);
            }
            if (this.cwd != null) {
                this.pb = this.pb.directory(this.cwd);
            }
            final Process p = this.pb.start();
            ExecOutputConsumer consumer = new ExecOutputConsumer().withInput(this.input).withOutputConsumers(this.outputConsumers).withErrorConsumers(this.errorConsumers).withThreadsBaseName(this.threadsBaseName);
            consumer.start(p.getInputStream(), p.getErrorStream(), p.getOutputStream());
            ExecWaitingThead waitingThread = new ExecWaitingThead(this.threadsBaseName == null ? this.pb.command().get(0) : this.threadsBaseName, p, this.timeout);
            waitingThread.start();
            if (this.killer != null) {
                this.killer.setWaitingThread(waitingThread);
            }
            try {
                FutureAborter.AutoCloseableAbortHook abortHook = FutureAborter.pushAutoCloseableHook(new Runnable(){

                    @Override
                    public void run() {
                        this.terminateProcess(p);
                    }
                });
                try {
                    int rv = waitingThread.waitFor();
                    consumer.finish();
                    if (this.completionHandler != null) {
                        this.completionHandler.handle(rv);
                    }
                    int n = rv;
                    if (abortHook != null) {
                        abortHook.close();
                    }
                    return n;
                }
                catch (Throwable throwable) {
                    try {
                        if (abortHook != null) {
                            try {
                                abortHook.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ProcessDiedException e) {
                        throw e;
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new IOException("Process failure", e);
                    }
                }
            }
            finally {
                this.terminateProcess(p);
                for (ExecCleanuper cleanuper : this.cleanupers) {
                    cleanuper.cleanup();
                }
            }
        }

        private void terminateProcess(Process p) {
            if (p != null && p.isAlive()) {
                p.descendants().forEach(ProcessHandle::destroy);
                DKUtils.evilKill(p);
            }
        }
    }

    public static class LoggingLineSubscription
    implements LineSubscriptionAttacher {
        private final Level level;
        private final DKULogger logger;

        public LoggingLineSubscription(Level level) {
            this.level = level;
            this.logger = logger;
        }

        public LoggingLineSubscription(DKULogger logger, Level level) {
            this.level = level;
            this.logger = logger;
        }

        @Override
        public void handle(String line, boolean replace) {
            this.logger.log((Priority)this.level, line);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public LineSubscription getSubSubscription(final String prefix) {
            return new LineSubscription(){

                @Override
                public void close() throws IOException {
                }

                @Override
                public void handle(String line, boolean replace) throws IOException {
                    this.handle(prefix + line, replace);
                }
            };
        }
    }

    public static interface ExecSubscription {
        public void close() throws IOException;
    }

    public static class SimpleExceptionExecCompletionHandler
    implements ExecCompletionHandler {
        private String commandName;
        private String message;
        private SmartLogTailBuilder logTailBuilder;

        public SimpleExceptionExecCompletionHandler() {
        }

        public SimpleExceptionExecCompletionHandler(String message) {
            this.message = message;
        }

        public SimpleExceptionExecCompletionHandler(List<String> command) {
            if (!command.isEmpty() && command.get(0).length() < 100) {
                this.commandName = command.get(0);
            }
        }

        public SimpleExceptionExecCompletionHandler withLogTailBuilder(SmartLogTailBuilder logTailBuilder) {
            this.logTailBuilder = logTailBuilder;
            return this;
        }

        @Override
        public void init(ExecBuilder builder) {
        }

        @Override
        public void handle(int rv) throws IOException {
            if (rv != 0) {
                Object description = "";
                if (StringUtils.isNotBlank((String)this.message)) {
                    description = (String)description + this.message + " ";
                }
                if (StringUtils.isNotBlank((String)this.commandName)) {
                    description = (String)description + String.format("Command failed: '%s'", this.commandName);
                }
                description = StringUtils.defaultIfEmpty((String)((String)description).trim(), (String)"Execution failed");
                throw ProcessDiedException.getExceptionOnProcessDeath((String)description, null, null, false, rv, this.logTailBuilder);
            }
        }
    }

    public static interface ExecCompletionHandler {
        public void init(ExecBuilder var1);

        public void handle(int var1) throws IOException;
    }

    public static class TailerLineSubscription
    implements LineSubscription {
        private final SmartLogTailBuilder tailBuilder;

        public TailerLineSubscription(SmartLogTailBuilder tailBuilder) {
            this.tailBuilder = tailBuilder;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void handle(String line, boolean replace) throws IOException {
            if (replace) {
                this.tailBuilder.replaceLastLine(line);
            } else {
                this.tailBuilder.appendLine(line);
            }
        }
    }

    public static class SmartLogTailBuilder {
        private int maxLines = 80;
        private int totalLines = 0;
        private final List<String> tail = new LinkedList<String>();

        public SmartLogTailBuilder() {
        }

        public SmartLogTailBuilder(int maxLines) {
            this.maxLines = maxLines;
        }

        public void setMaxLines(int maxLines) {
            this.maxLines = maxLines;
        }

        public synchronized void appendLine(String line) {
            this.appendLine(line, false);
        }

        public void appendLine(String line, DKULogger logger, Priority priority) {
            this.appendLine(line, false);
            logger.log(priority, line);
        }

        public void appendLine(String line, DKULogger logger, Priority priority, boolean replaceLastLine) {
            this.appendLine(line, replaceLastLine);
            logger.log(priority, line);
        }

        public synchronized void replaceLastLine(String line) {
            this.appendLine(line, true);
        }

        public void replaceLastLine(String line, DKULogger logger, Priority priority) {
            this.appendLine(line, true);
            logger.log(priority, line);
        }

        public synchronized void appendLine(String line, boolean replaceLastLine) {
            if (replaceLastLine && !this.tail.isEmpty()) {
                this.tail.remove(this.tail.size() - 1);
                --this.totalLines;
            } else if (this.tail.size() >= this.maxLines) {
                this.tail.remove(0);
            }
            this.tail.add(line);
            ++this.totalLines;
        }

        public synchronized SmartLogTail get() {
            SmartLogTail ret = new SmartLogTail();
            for (String line : this.tail) {
                ret.appendLine(line);
            }
            ret.totalLines = this.totalLines;
            return ret;
        }
    }

    public static class UnfilteredLoggingLineSubscription
    implements LineSubscription {
        private final Level level;
        private final String threadName;
        private final Logger logger = Logger.getLogger((String)"dku.process.output");

        public UnfilteredLoggingLineSubscription(Level level, String threadName) {
            this.level = level;
            this.threadName = threadName;
        }

        @Override
        public void handle(String line, boolean replace) {
            LoggingEvent evt = new LoggingEvent("dku", (Category)this.logger, (Priority)this.level, (Object)line, null);
            evt.setProperty(DKUtils.UNFILTERED_LOG_EVENT_KEY, this.threadName);
            this.logger.callAppenders(evt);
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class OutputStreamSubscription
    implements BytesSubscription {
        private final OutputStream os;
        private final boolean doCloseStream;

        public OutputStreamSubscription(OutputStream os, boolean doCloseStream) {
            this.os = os;
            this.doCloseStream = doCloseStream;
        }

        @Override
        public void handle(byte[] buffer, int count) throws IOException {
            this.os.write(buffer, 0, count);
        }

        @Override
        public void close() throws IOException {
            this.os.flush();
            if (this.doCloseStream) {
                this.os.close();
            }
        }
    }

    public static class ErrorCollectingExecCompletionHandler
    implements ExecCompletionHandler,
    BytesSubscription {
        protected String commandName;
        protected String message;
        protected ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public ErrorCollectingExecCompletionHandler() {
        }

        public ErrorCollectingExecCompletionHandler(String message) {
            this.message = message;
        }

        public ErrorCollectingExecCompletionHandler(List<String> command) {
            if (!command.isEmpty() && command.get(0).length() < 100) {
                this.commandName = command.get(0);
            }
        }

        @Override
        public void init(ExecBuilder builder) {
        }

        @Override
        public void handle(int rv) throws IOException {
            if (rv != 0) {
                String collected = this.baos.toString(StandardCharsets.UTF_8.name());
                if (this.commandName != null) {
                    throw new IOException("Process execution failed (" + this.commandName + ") (return code " + rv + ") (error=" + collected + ")");
                }
                if (this.message != null) {
                    throw new IOException(this.message + " (return code " + rv + ") (error=" + collected + ")");
                }
                throw new IOException("Process execution failed (return code " + rv + ") (error=" + collected + ")");
            }
        }

        @Override
        public void handle(byte[] buffer, int count) throws IOException {
            this.baos.write(buffer, 0, count);
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class ByteCollectingSubscription
    implements BytesSubscription {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public byte[] getCollected() {
            return this.baos.toByteArray();
        }

        @Override
        public void handle(byte[] buffer, int count) throws IOException {
            this.baos.write(buffer, 0, count);
        }

        @Override
        public void close() throws IOException {
            this.baos.flush();
        }
    }

    public static class ExecutionResults {
        public String out;
        public String err;
        public int rv;
    }

    public static class LineOrientedThreadSafeCopyStreamEaterWithSubscription
    extends LineOrientedThreadSafeCopyStreamEater {
        private final LineSubscription subscription;

        public LineOrientedThreadSafeCopyStreamEaterWithSubscription(InputStream is, OutputStream os, LineSubscription subscription) {
            super(is, os);
            this.subscription = subscription;
        }

        @Override
        protected void handle(String line) throws UnsupportedEncodingException, IOException {
            this.subscription.handle(line, false);
            super.handle(line);
        }
    }

    public static class LineOrientedThreadSafeCopyStreamEaterWithLogging
    extends LineOrientedThreadSafeCopyStreamEater {
        public LineOrientedThreadSafeCopyStreamEaterWithLogging(InputStream is, OutputStream os) {
            super(is, os);
        }

        @Override
        protected void handle(String line) throws UnsupportedEncodingException, IOException {
            logger.info((Object)line);
            super.handle(line);
        }
    }

    public static class LineOrientedThreadSafeCopyStreamEater
    extends Thread {
        static Logger logger = Logger.getLogger((String)"process");
        OutputStream os;
        InputStream is;

        public LineOrientedThreadSafeCopyStreamEater(InputStream is, OutputStream os) {
            this.is = is;
            this.os = os;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("Exec-" + Thread.currentThread().getId());
            InheritableNDC.inheritNDC();
            try (BufferedReader br = StreamUtils.readStream(this.is);){
                String line = br.readLine();
                while (line != null) {
                    this.handle(line);
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                logger.error((Object)"Logging failed", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handle(String line) throws UnsupportedEncodingException, IOException {
            OutputStream outputStream = this.os;
            synchronized (outputStream) {
                this.os.write((line + "\n").getBytes("utf8"));
                this.os.flush();
            }
        }
    }

    public static class StreamTailer
    extends LoggingStreamEater {
        private final SmartLogTailBuilder tailBuilder;

        public StreamTailer(InputStream is, Level level, String threadName, SmartLogTailBuilder tailBuilder) {
            super(is, level, threadName);
            this.tailBuilder = tailBuilder;
        }

        public StreamTailer(InputStream is, Level level, SmartLogTailBuilder tailBuilder) {
            super(is, level);
            this.tailBuilder = tailBuilder;
        }

        @Override
        protected synchronized void handle(String line) throws IOException {
            super.handle(line);
            this.tailBuilder.appendLine(line);
        }
    }

    public static class LoggingStreamEater
    extends Thread {
        private Level level;
        InputStream is;
        private String threadName;
        private static Logger _logger = Logger.getLogger((String)"process");

        public LoggingStreamEater(InputStream is, Level level, String threadName) {
            this.is = is;
            this.level = level;
            this.threadName = threadName;
        }

        public LoggingStreamEater(InputStream is, Level level) {
            this.is = is;
            this.level = level;
        }

        @Override
        public void run() {
            if (this.threadName == null) {
                Thread.currentThread().setName("Exec-" + Thread.currentThread().getId());
            } else {
                Thread.currentThread().setName(this.threadName + "-" + Thread.currentThread().getId());
            }
            InheritableNDC.inheritNDC();
            try {
                String line;
                BufferedReader br = StreamUtils.readStream(this.is);
                while ((line = br.readLine()) != null) {
                    this.handle(line);
                }
                br.close();
            }
            catch (IOException e) {
                _logger.error((Object)"", (Throwable)e);
            }
        }

        protected void handle(String line) throws IOException {
            logger.log((Priority)this.level, line);
        }
    }

    public static class ExecOutputConsumer {
        private String threadsBaseName;
        private List<ExecSubscription> outputConsumers = Lists.newArrayList();
        private List<ExecSubscription> errorConsumers = Lists.newArrayList();
        private String input;
        private List<Thread> outputConsumingThreads;
        private List<Thread> errorConsumingThreads;
        private boolean addTimestampsToLine = false;

        public ExecOutputConsumer withThreadsBaseName(String threadsBaseName) {
            this.threadsBaseName = threadsBaseName;
            return this;
        }

        public ExecOutputConsumer withOutputConsumer(ExecSubscription consumer) {
            this.outputConsumers.add(consumer);
            return this;
        }

        public ExecOutputConsumer withErrorConsumer(ExecSubscription consumer) {
            this.errorConsumers.add(consumer);
            return this;
        }

        public ExecOutputConsumer withOutputConsumers(List<ExecSubscription> consumers) {
            this.outputConsumers.addAll(consumers);
            return this;
        }

        public ExecOutputConsumer withErrorConsumers(List<ExecSubscription> consumers) {
            this.errorConsumers.addAll(consumers);
            return this;
        }

        public ExecOutputConsumer withInput(String input) {
            this.input = input;
            return this;
        }

        public ExecOutputConsumer withTimestamps(boolean addTimestampsToLine) {
            this.addTimestampsToLine = addTimestampsToLine;
            return this;
        }

        public void start(InputStream processOutput, InputStream processError, OutputStream processInput) throws IOException {
            this.outputConsumingThreads = this.build(processOutput, this.threadsBaseName + "-out", this.outputConsumers);
            this.errorConsumingThreads = this.build(processError, this.threadsBaseName + "-err", this.errorConsumers);
            for (Thread t : this.outputConsumingThreads) {
                t.start();
            }
            for (Thread t : this.errorConsumingThreads) {
                t.start();
            }
            if (this.input != null) {
                PrintStream stream = new PrintStream(processInput);
                stream.append(this.input);
                stream.close();
                processInput.close();
            }
        }

        public void finish() throws InterruptedException {
            for (Thread t : this.outputConsumingThreads) {
                t.join();
            }
            for (Thread t : this.errorConsumingThreads) {
                t.join();
            }
        }

        private List<Thread> build(InputStream is, String threadBaseName, List<ExecSubscription> consumers) throws IOException {
            ArrayList bytesSubscription = Lists.newArrayList();
            ArrayList lineSubscriptions = Lists.newArrayList();
            for (ExecSubscription consumer : consumers) {
                if (consumer instanceof BytesSubscription) {
                    bytesSubscription.add((BytesSubscription)consumer);
                    continue;
                }
                if (consumer instanceof LineSubscription) {
                    lineSubscriptions.add((LineSubscription)consumer);
                    continue;
                }
                throw new IllegalArgumentException("Unhandled process output stream consumer of type " + consumer.getClass().getCanonicalName());
            }
            ArrayList threads = Lists.newArrayList();
            if (bytesSubscription.isEmpty() && lineSubscriptions.isEmpty()) {
                threads.add(new Blackhole(is));
            } else if (bytesSubscription.isEmpty()) {
                threads.add(new StreamToLine(threadBaseName, is, lineSubscriptions, this.addTimestampsToLine));
            } else if (!lineSubscriptions.isEmpty()) {
                PipedOutputStream pos = new PipedOutputStream();
                PipedInputStream pis = new PipedInputStream(pos);
                bytesSubscription.add(new OutputStreamSubscription(pos, true));
                threads.add(new StreamDuplicator(is, bytesSubscription));
                threads.add(new StreamToLine(threadBaseName, pis, lineSubscriptions, this.addTimestampsToLine));
            } else {
                threads.add(new StreamDuplicator(is, bytesSubscription));
            }
            return threads;
        }
    }

    public static class ExecWaitingThread
    extends Thread {
        private final ExecBuilder builder;
        private final ExecKiller killer;

        public ExecWaitingThread(ExecBuilder builder) {
            this.builder = builder;
            this.killer = builder.makeNiceThenEvilKiller();
        }

        @Override
        public void run() {
            try {
                this.builder.exec();
            }
            catch (Exception e) {
                logger.error("Failed", e);
            }
        }

        public void abort() {
            this.killer.kill();
        }
    }

    private static class ExecWaitingThead
    extends Thread {
        private int rv;
        private final Process p;
        private final String name;
        private final Long timeout;
        private boolean timedOut;

        private ExecWaitingThead(String name, Process p) {
            this(name, p, null);
        }

        private ExecWaitingThead(String name, Process p, Long timeout) {
            this.name = name;
            this.p = p;
            this.timeout = timeout;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                if (this.timeout != null) {
                    boolean success = this.p.waitFor(this.timeout, TimeUnit.MILLISECONDS);
                    if (!success) {
                        this.timedOut = true;
                        throw new InterruptedException("Process " + this.name + " has timed out");
                    }
                    this.rv = this.p.exitValue();
                } else {
                    this.rv = this.p.waitFor();
                }
                if (this.rv == 0) {
                    logger.debug("Process " + this.name + " done (return code 0)");
                    return;
                }
                logger.info("Process " + this.name + " completed, return code " + this.rv);
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Exec wait interrupted", e);
            }
        }

        public boolean isRunning() {
            return this.isAlive();
        }

        public int waitFor() throws InterruptedException {
            this.join();
            if (this.hasTimedOut()) {
                logger.info("Process " + this.name + " has timed out");
                throw new InterruptedException("Process " + this.name + " has timed out");
            }
            return this.rv;
        }

        public int waitFor(long timeout) throws InterruptedException {
            this.join(timeout);
            return this.rv;
        }

        public void niceKill() {
            DKUtils.niceKill(this.p);
        }

        public void evilKill() {
            DKUtils.evilKill(this.p);
        }

        public boolean hasTimedOut() {
            return this.timedOut;
        }
    }

    public static class AbortFromFutureKiller
    implements LazyInitExecKiller,
    Runnable {
        private ExecWaitingThead p;

        @Override
        public void setWaitingThread(ExecWaitingThead p) {
            this.p = p;
        }

        @Override
        public void kill() {
            if (this.p == null) {
                logger.warn("No process launched that could be killed");
                return;
            }
            if (!this.p.isRunning()) {
                logger.warn("Process launched but not running, no killing needed");
                return;
            }
            logger.info("Process is still running, sending SIGKILL...");
            this.p.evilKill();
        }

        @Override
        public void run() {
            this.kill();
        }
    }

    public static class NiceThenEvilKiller
    implements LazyInitExecKiller {
        private ExecWaitingThead p;

        @Override
        public void setWaitingThread(ExecWaitingThead p) {
            this.p = p;
        }

        @Override
        public void kill() {
            if (this.p == null) {
                logger.warn("No process launched that could be killed");
                return;
            }
            if (!this.p.isRunning()) {
                logger.warn("Process launched but not running, no killing needed");
                return;
            }
            logger.info("Process is still running, sending SIGINT...");
            this.p.niceKill();
            try {
                this.p.waitFor(15000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption", e);
            }
            if (this.p.isRunning()) {
                logger.info("Process is still running after 15000ms, sending SIGKILL...");
                this.p.evilKill();
                try {
                    this.p.waitFor(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error("Unexpected interruption", e);
                }
                if (this.p.isRunning()) {
                    logger.info("Process is still alive after SIGINT and SIGKILL. Too strong for us...");
                } else {
                    logger.info("Process has been abruptly killed. Cleanup may be incomplete.");
                }
            } else {
                logger.info("Process has been nicely interrupted!");
            }
        }
    }

    public static interface LazyInitExecKiller
    extends ExecKiller {
        public void setWaitingThread(ExecWaitingThead var1);
    }

    public static interface ExecCleanuper {
        public void cleanup();
    }

    public static interface ExecKiller {
        public void kill();
    }

    public static class FileOrLogLineSubscription
    implements LineSubscription {
        private final Level level;
        private PrintWriter output;

        public FileOrLogLineSubscription(Level level) {
            this.level = level;
        }

        public synchronized void setOutput(PrintWriter output) {
            this.output = output;
        }

        @Override
        public synchronized void handle(String line, boolean replace) {
            if (this.output != null) {
                this.output.println(line);
            } else {
                logger.log((Priority)this.level, line);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class SendToAppenderLineSubscription
    implements LineSubscription {
        private final Appender appender;
        private final Level level;
        private final String loggerName;
        private final Logger dummyLogger;

        public SendToAppenderLineSubscription(Appender appender, Level level, String loggerName) {
            this.appender = appender;
            this.level = level;
            this.loggerName = loggerName;
            this.dummyLogger = Logger.getLogger((String)loggerName);
        }

        @Override
        public void handle(String line, boolean replace) {
            LoggingEvent evt = new LoggingEvent(this.loggerName, (Category)this.dummyLogger, (Priority)this.level, (Object)line, null);
            this.appender.doAppend(evt);
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class OutputWriterSubscription
    implements LineSubscription {
        private final Writer wr;
        private final boolean doCloseWriter;
        private volatile boolean closed;

        public OutputWriterSubscription(Writer wr, boolean doCloseWriter) {
            this.wr = wr;
            this.doCloseWriter = doCloseWriter;
        }

        @Override
        public void handle(String line, boolean replace) throws IOException {
            if (this.closed) {
                logger.warn("Writer already closed, cannot write: " + line);
                return;
            }
            this.wr.write(line);
            this.wr.write("\n");
            this.wr.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.wr.flush();
            if (this.doCloseWriter) {
                this.wr.close();
            }
        }
    }

    private static class Blackhole
    extends Thread {
        private final InputStream src;
        private static Logger _logger = Logger.getLogger((String)"process");

        Blackhole(InputStream src) {
            this.src = src;
        }

        @Override
        public void run() {
            try {
                long total = 0L;
                byte[] buffer = new byte[4096];
                int read = this.src.read(buffer);
                while (read >= 0) {
                    total += (long)read;
                    read = this.src.read(buffer);
                }
                logger.info("Read and ignored " + total + " bytes");
            }
            catch (IOException e) {
                _logger.error((Object)"Failed to dev/null stream", (Throwable)e);
            }
        }
    }

    private static class StreamToLine
    extends Thread {
        private static final java.time.format.DateTimeFormatter dateFormat = java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
        private static final int MAX_LINE_LENGTH = 524288;
        private final InputStream src;
        private final List<LineSubscription> dsts;
        private final String threadBaseName;
        private final boolean addTimestampsToLine;
        private static Logger _logger = Logger.getLogger((String)"process");

        StreamToLine(String threadBaseName, InputStream src, List<LineSubscription> dsts, boolean addTimestampsToLine) {
            this.threadBaseName = threadBaseName;
            this.src = src;
            this.dsts = dsts;
            this.addTimestampsToLine = addTimestampsToLine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            Thread.currentThread().setName(this.threadBaseName + "-" + Thread.currentThread().getId());
            InheritableNDC.inheritNDC();
            try (CRLineReader reader = new CRLineReader(new InputStreamReader(this.src, StandardCharsets.UTF_8), 524288);){
                Object line = reader.readLine();
                while (line != null) {
                    if (this.addTimestampsToLine) {
                        line = "[" + dateFormat.format(Instant.now()) + "] " + (String)line;
                    }
                    Iterator<LineSubscription> iterator = this.dsts.iterator();
                    while (iterator.hasNext()) {
                        LineSubscription dst;
                        LineSubscription lineSubscription = dst = iterator.next();
                        synchronized (lineSubscription) {
                            dst.handle((String)line, reader.startsWithCR());
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (EOFException e) {
                _logger.debug((Object)"StreamToLine: EOF");
            }
            catch (IOException e) {
                if ("Stream closed".equals(e.getMessage())) {
                    _logger.debug((Object)"StreamToLine: EOF (stream closed)");
                }
                _logger.error((Object)"Failed to duplicate stream", (Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                for (LineSubscription dst : this.dsts) {
                    try {
                        dst.close();
                    }
                    catch (IOException e) {
                        _logger.error((Object)"Failed to shutdown output log line handler", (Throwable)e);
                    }
                }
            }
            for (LineSubscription dst : this.dsts) {
                try {
                    dst.close();
                }
                catch (IOException e) {
                    _logger.error((Object)"Failed to shutdown output log line handler", (Throwable)e);
                }
            }
        }
    }

    public static class TagSniffingLineSubscription
    implements LineSubscription {
        private final Pattern pattern;
        private boolean found = false;
        private boolean closed = false;

        public TagSniffingLineSubscription(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean hasFoundTag() {
            return this.found;
        }

        public boolean isClosed() {
            return this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(String line, boolean replace) {
            Matcher matcher;
            if (line != null && (matcher = this.pattern.matcher(line)).matches()) {
                logger.info("Found tag in line '" + line + "'");
                this.handleTag(line, matcher);
                TagSniffingLineSubscription tagSniffingLineSubscription = this;
                synchronized (tagSniffingLineSubscription) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.closed = true;
            TagSniffingLineSubscription tagSniffingLineSubscription = this;
            synchronized (tagSniffingLineSubscription) {
                this.notifyAll();
            }
        }

        protected void handleTag(String line, Matcher matcher) {
            this.found = true;
        }
    }

    public static class LockedRotatingLoggingSubscription
    extends RotatingLoggingSubscription {
        private final File logFile;

        public LockedRotatingLoggingSubscription(File folder, String logName, int maxRotated, long maxSizeInBytes) throws IOException {
            super(folder, logName, maxRotated, maxSizeInBytes);
            this.logFile = new File(folder.getAbsolutePath(), logName);
            DKUFileUtils.lockFile(this.logFile);
        }

        @Override
        public void close() throws IOException {
            DKUFileUtils.unlockFile(this.logFile);
            super.close();
        }
    }

    public static class RotatingLoggingSubscription
    implements LineSubscription,
    LineSubscriptionAttacher,
    AutoCloseable {
        private final File folder;
        private final String logName;
        private final int maxRotated;
        private final long maxSizeInBytes;
        private FileOutputStream headLogOutputStream;
        private long currentSizeInBytes;

        public RotatingLoggingSubscription(File folder, String logName, int maxRotated, long maxSizeInBytes) throws FileNotFoundException {
            this.folder = folder;
            this.logName = logName;
            this.maxRotated = maxRotated;
            this.maxSizeInBytes = maxSizeInBytes;
            this.headLogOutputStream = new FileOutputStream(new File(folder, logName));
            this.currentSizeInBytes = 0L;
        }

        @Override
        public LineSubscription getSubSubscription(final String prefix) {
            return new LineSubscription(){

                @Override
                public void close() throws IOException {
                }

                @Override
                public void handle(String line, boolean replace) throws IOException {
                    this.handle(prefix + line, replace);
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.headLogOutputStream.close();
        }

        @Override
        public synchronized void handle(String line, boolean replace) throws IOException {
            byte[] bytes = (line + "\n").getBytes(StandardCharsets.UTF_8);
            this.write(bytes, 0, bytes.length);
        }

        private void write(byte[] buffer, int st, int en) throws IOException {
            this.headLogOutputStream.write(buffer, st, en - st);
            this.currentSizeInBytes += (long)(en - st);
            if (this.currentSizeInBytes > this.maxSizeInBytes) {
                this.rotate();
            }
        }

        private void rotate() throws IOException {
            this.headLogOutputStream.flush();
            this.headLogOutputStream.close();
            for (int i = this.maxRotated; i > 0; --i) {
                File logFile = new File(this.folder, this.logName + "." + (i - 1));
                if (!logFile.exists()) continue;
                logFile.renameTo(new File(this.folder, this.logName + "." + i));
            }
            File logFile = new File(this.folder, this.logName);
            if (logFile.exists()) {
                logFile.renameTo(new File(this.folder, this.logName + ".1"));
            }
            this.headLogOutputStream = new FileOutputStream(new File(this.folder, this.logName));
            this.currentSizeInBytes = 0L;
        }
    }

    public static interface LineSubscriptionAttacher
    extends LineSubscription {
        public LineSubscription getSubSubscription(String var1);
    }

    public static interface BytesSubscription
    extends ExecSubscription {
        public void handle(byte[] var1, int var2) throws IOException;
    }

    public static interface LineSubscription
    extends ExecSubscription {
        public void handle(String var1, boolean var2) throws IOException;
    }

    private static class StreamDuplicator
    extends Thread {
        private final InputStream src;
        private final List<BytesSubscription> dsts;
        private static Logger _logger = Logger.getLogger((String)"process");

        StreamDuplicator(InputStream src, List<BytesSubscription> dsts) {
            this.src = src;
            this.dsts = dsts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object buffer;
            try {
                buffer = new byte[4096];
                int read = this.src.read((byte[])buffer);
                while (read >= 0) {
                    Iterator<BytesSubscription> iterator = this.dsts.iterator();
                    while (iterator.hasNext()) {
                        BytesSubscription dst;
                        BytesSubscription bytesSubscription = dst = iterator.next();
                        synchronized (bytesSubscription) {
                            dst.handle((byte[])buffer, read);
                        }
                    }
                    read = this.src.read((byte[])buffer);
                }
                buffer = this.dsts.iterator();
            }
            catch (IOException e) {
                _logger.error((Object)"Failed to duplicate stream", (Throwable)e);
            }
            finally {
                for (BytesSubscription dst : this.dsts) {
                    try {
                        dst.close();
                    }
                    catch (IOException e) {
                        _logger.error((Object)"Failed to shutdown output log line handler", (Throwable)e);
                    }
                }
            }
            while (buffer.hasNext()) {
                BytesSubscription dst = (BytesSubscription)buffer.next();
                try {
                    dst.close();
                }
                catch (IOException e) {
                    _logger.error((Object)"Failed to shutdown output log line handler", (Throwable)e);
                }
            }
        }
    }
}

