/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.connections;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ExternalTable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.catalog.external.ExternalTableSummary;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexingSessionContextData {
    @Autowired
    private UsersService usersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private TimelinesInternalDB timelinesDB;
    private FlowGraph flowGraph;
    private Map<DatabaseObjectKey, TableRelatedDatasets> relatedDatasetsCache = new HashMap<DatabaseObjectKey, TableRelatedDatasets>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.catalog.indexing.related");

    public IndexingSessionContextData() throws Exception {
        SpringUtils.getInstance().autowire((Object)this);
        this.buildRelatedDatasetsCache();
    }

    public ExternalTableSummary.DSSItemsResponse getRelatedItems(ExternalTable table) throws Exception {
        ExternalTableSummary.DSSItemsResponse itemsResponse = new ExternalTableSummary.DSSItemsResponse();
        TableRelatedDatasets relatedDatasets = this.relatedDatasetsCache.get(table.key);
        if (relatedDatasets == null) {
            return itemsResponse;
        }
        ArrayList<UnfinishedItemsDataset> unfinishedItemsDatasets = new ArrayList<UnfinishedItemsDataset>();
        try (Transaction t = this.transactionService.beginRead();){
            HashMap<String, ExternalTableSummary.DSSItemsProject> builtProjectItems = new HashMap<String, ExternalTableSummary.DSSItemsProject>();
            for (String relatedProjectKey : relatedDatasets.getDistinctProjectKeysIncludingExposed()) {
                SerializedProject sp = this.projectsService.getOrNullUnsafe(relatedProjectKey);
                if (sp == null) {
                    logger.warnV("External table [%s] is related to a deleted project [%s]", new Object[]{table.key, relatedProjectKey});
                    continue;
                }
                builtProjectItems.put(sp.projectKey, new ExternalTableSummary.DSSItemsProject(sp.name, sp.projectKey));
            }
            for (AnyLoc loc : relatedDatasets.datasetLocs) {
                SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc);
                unfinishedItemsDatasets.add(this.addUnfinishedItemsDataset(builtProjectItems, sd, loc.getProjectKey()));
                SerializedProject containingSP = this.projectsService.getMandatoryUnsafe(loc.getProjectKey());
                for (String exposedToProjectKey : containingSP.exposedObjects.getProjectsExposedTo(ITaggingService.TaggableType.DATASET, loc.getId())) {
                    if (builtProjectItems.get(exposedToProjectKey) == null) continue;
                    unfinishedItemsDatasets.add(this.addUnfinishedItemsDataset(builtProjectItems, sd, exposedToProjectKey));
                }
            }
            itemsResponse.projects.addAll(builtProjectItems.values());
        }
        this.finishItemsDatasets_NT(unfinishedItemsDatasets);
        return itemsResponse;
    }

    private void finishItemsDatasets_NT(List<UnfinishedItemsDataset> itemsDatasetsToFinish) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        for (UnfinishedItemsDataset itemsDatasetToFinish : itemsDatasetsToFinish) {
            itemsDatasetToFinish.finish();
        }
    }

    private UnfinishedItemsDataset addUnfinishedItemsDataset(Map<String, ExternalTableSummary.DSSItemsProject> builtProjectItems, SerializedDataset sd, String projectKey) throws Exception {
        ExternalTableSummary.DSSItemsDataset datasetItems = this.makeUnfinishedItemsDataset(projectKey, sd);
        builtProjectItems.get((Object)projectKey).datasets.add(datasetItems);
        return new UnfinishedItemsDataset(projectKey, sd, datasetItems);
    }

    private void buildRelatedDatasetsCache() throws Exception {
        List projectKeys = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.flowGraph = this.flowGraphService.getGlobalGraphUnsafe(true);
            projectKeys = this.projectsService.listKeys();
        }
        for (String projectKey : projectKeys) {
            Transaction t = this.transactionService.beginRead();
            try {
                for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
                    try {
                        DatabaseObjectKey dok = null;
                        if (DatasetInspector.isSQLTable((SerializedDataset)sd)) {
                            AbstractSQLDatasetHandler.AbstractSQLConfig config = ((AbstractSQLDatasetHandler.AbstractSQLConfig)sd.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class)).getResolved(projectKey);
                            dok = new DatabaseObjectKey(config.connection, config.catalog, config.schema, config.table);
                        } else if (DatasetInspector.canHiveTable((SerializedDataset)sd)) {
                            SQLUtils.SQLTable htr = HiveSchemaHandler.getResolvedHiveTableRefFromDataset((Dataset)Dataset.fromSerializedUnsafe((SerializedDataset)sd));
                            dok = new DatabaseObjectKey("@virtual(hive-jdbc):" + htr.getSchemaNullIfBlank(), htr.getCatalog(), htr.getSchemaNullIfBlank(), htr.getTable());
                        }
                        if (dok == null) continue;
                        TableRelatedDatasets trd = this.relatedDatasetsCache.get(dok);
                        if (trd == null) {
                            trd = new TableRelatedDatasets();
                            this.relatedDatasetsCache.put(dok, trd);
                        }
                        trd.datasetLocs.add(new AnyLoc(projectKey, sd.name));
                    }
                    catch (Throwable th) {
                        logger.warn((Object)("Failed to build mapping for dataset" + sd.projectKey + "." + sd.name + ": " + ExceptionUtils.getMessageWithCauses((Throwable)th)));
                    }
                }
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
    }

    private ExternalTableSummary.DSSItemsDataset makeUnfinishedItemsDataset(String inProject, SerializedDataset sd) throws Exception {
        ExternalTableSummary.DSSItemsDataset res = new ExternalTableSummary.DSSItemsDataset();
        res.name = sd.name;
        res.creationDate = sd.creationTag == null ? 0L : sd.creationTag.getLastModifiedOn();
        res.description = sd.description;
        res.type = sd.type;
        if (!sd.projectKey.equals(inProject)) {
            res.foreign = true;
            res.exposedFromProjectKey = sd.projectKey;
            res.exposedFromDataset = sd.getDisplayName();
        } else {
            SerializedProject containingSP = this.projectsService.getMandatoryUnsafe(sd.getProjectKey());
            for (String exposedToProjectKey : containingSP.exposedObjects.getProjectsExposedTo(ITaggingService.TaggableType.DATASET, sd.getId())) {
                SerializedProject exposedSp = this.projectsService.getOrNullUnsafe(exposedToProjectKey);
                if (exposedSp == null) {
                    logger.warnV("Dataset [%s] is shared to a deleted project [%s]", new Object[]{sd.name, exposedToProjectKey});
                    continue;
                }
                ExternalTableSummary.DSSItemsExposedProject p = new ExternalTableSummary.DSSItemsExposedProject();
                p.name = exposedSp.name;
                p.key = exposedSp.projectKey;
                if (res.exposedInProjects == null) {
                    res.exposedInProjects = new ArrayList<ExternalTableSummary.DSSItemsExposedProject>();
                }
                res.exposedInProjects.add(p);
            }
        }
        return res;
    }

    private List<PublicUser> getObjectContributors(ITaggingService.TaggableType objectType, String projectKey, String objectId) throws IOException {
        List userNames = this.timelinesDB.getContributorsForObject(objectType, projectKey, objectId);
        ArrayList<PublicUser> ret = new ArrayList<PublicUser>();
        try (Transaction t = this.transactionService.beginRead();){
            for (String login : userNames) {
                ret.add(this.usersService.getPublicUser(login));
            }
        }
        return ret;
    }

    private class TableRelatedDatasets {
        List<AnyLoc> datasetLocs = new ArrayList<AnyLoc>();

        private TableRelatedDatasets() {
        }

        Set<String> getDistinctProjectKeys() {
            HashSet<String> ret = new HashSet<String>();
            for (AnyLoc loc : this.datasetLocs) {
                ret.add(loc.getProjectKey());
            }
            return ret;
        }

        Set<String> getDistinctProjectKeysIncludingExposed() throws IOException {
            Set<String> ret = this.getDistinctProjectKeys();
            for (AnyLoc loc : this.datasetLocs) {
                SerializedProject sp = IndexingSessionContextData.this.projectsService.getMandatoryUnsafe(loc.getProjectKey());
                ret.addAll(sp.exposedObjects.getProjectsExposedTo(ITaggingService.TaggableType.DATASET, loc.getId()));
            }
            return ret;
        }
    }

    private class UnfinishedItemsDataset {
        final String projectKey;
        final SerializedDataset sd;
        final ExternalTableSummary.DSSItemsDataset datasetItemToFinish;
        final boolean fetchContributors;

        private UnfinishedItemsDataset(String projectKey, SerializedDataset sd, ExternalTableSummary.DSSItemsDataset datasetItemToFinish) {
            this.projectKey = projectKey;
            this.sd = sd;
            this.datasetItemToFinish = datasetItemToFinish;
            this.fetchContributors = !datasetItemToFinish.foreign;
        }

        void finish() throws IOException {
            if (this.fetchContributors) {
                this.datasetItemToFinish.contributors = IndexingSessionContextData.this.getObjectContributors(ITaggingService.TaggableType.DATASET, this.projectKey, this.sd.name);
            }
            this.datasetItemToFinish.recipes = this.retrieveRecipesForDatasetInProject(this.projectKey, this.sd);
        }

        private List<ExternalTableSummary.DSSItemsRecipe> retrieveRecipesForDatasetInProject(String inProject, SerializedDataset sd) throws IOException {
            ArrayList<ExternalTableSummary.DSSItemsRecipe> result = new ArrayList<ExternalTableSummary.DSSItemsRecipe>();
            FlowDataset fd = IndexingSessionContextData.this.flowGraph.getDataset(sd.projectKey, sd.name);
            if (fd != null) {
                for (GraphNode gn : Iterables.concat((Iterable)fd.getSuccessors(), (Iterable)fd.getPredecessors())) {
                    if (!(gn instanceof FlowRecipe)) continue;
                    SerializedRecipe sr = ((FlowRecipe)gn).getModel();
                    if (!sr.projectKey.equals(inProject)) continue;
                    ExternalTableSummary.DSSItemsRecipe res = new ExternalTableSummary.DSSItemsRecipe();
                    res.name = sr.name;
                    res.contributors = IndexingSessionContextData.this.getObjectContributors(sr.getTaggableType(), sr.getProjectKey(), sr.getId());
                    res.type = sr.type;
                    result.add(res);
                }
            }
            return result;
        }
    }
}

