/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.fs.ifaces.RelFileOutputStream;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.git.IGitManager;
import com.dataiku.dip.transactions.git.jgit.MultiRepositoryProjectsGitManager;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DoomerController {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService metaAuthService;
    private static final Logger logger = Logger.getLogger(DoomerController.class);

    private static void makeDirectoryRecursiveAndReturnCreated(ReadWriteFS dstFS, RelFile directory, List<RelFile> created) throws IOException {
        if (directory == null || dstFS.isDirectory(directory)) {
            return;
        }
        DoomerController.makeDirectoryRecursiveAndReturnCreated(dstFS, directory.getParent(), created);
        if (!dstFS.isDirectory(directory)) {
            if (!dstFS.makeDirectory(directory)) {
                throw new IOException("Could not create directory " + String.valueOf(directory));
            }
            created.add(directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RelFile> unzipAsync(ZipInputStream zis, ReadWriteFS dstFS, RelFile dstDir, int nThreads) throws IOException, InterruptedException {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(2 * nThreads), new ThreadPoolExecutor.CallerRunsPolicy());
        List<RelFile> unzippedFiles = Collections.synchronizedList(new ArrayList());
        try {
            ZipEntry entry;
            byte[] buffer = new byte[0x200000];
            while ((entry = zis.getNextEntry()) != null) {
                int pos;
                int read;
                RelFile targetFile = dstDir.appendChildPath(entry.getName());
                unzippedFiles.add(targetFile);
                if (entry.isDirectory()) {
                    executor.submit(() -> {
                        try {
                            DoomerController.makeDirectoryRecursiveAndReturnCreated(dstFS, targetFile, unzippedFiles);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    continue;
                }
                boolean hasMore = true;
                for (pos = 0; pos < buffer.length; pos += read) {
                    read = zis.read(buffer, pos, buffer.length - pos);
                    if (read != -1) continue;
                    hasMore = false;
                    break;
                }
                if (hasMore) {
                    RelFileOutputStream os = dstFS.writeStream(targetFile);
                    try {
                        os.write(buffer);
                        IOUtils.copyLarge((InputStream)zis, (OutputStream)os);
                        continue;
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                        continue;
                    }
                }
                byte[] oldBuffer = buffer;
                int oldPos = pos;
                buffer = new byte[buffer.length];
                executor.submit(() -> {
                    try {
                        DoomerController.makeDirectoryRecursiveAndReturnCreated(dstFS, targetFile.getParent(), unzippedFiles);
                        try (RelFileOutputStream os = dstFS.writeStreamNoMkdir(targetFile);){
                            os.write(oldBuffer, 0, oldPos);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            executor.shutdown();
            while (!executor.awaitTermination(1L, TimeUnit.DAYS)) {
                logger.info((Object)"Waiting for async unzipper to finish");
            }
        }
        finally {
            executor.shutdownNow();
        }
        return unzippedFiles;
    }

    private int invalidateConfigCache(List<RelFile> filesInDataDir) {
        ArrayList<RelFile> invalidatedFiles = new ArrayList<RelFile>();
        for (RelFile rf : filesInDataDir) {
            if (!rf.isChildOf(RelFile.fromPath((String)"config"))) continue;
            invalidatedFiles.add(rf.skipHead(1));
        }
        invalidatedFiles.sort(Comparator.comparing(RelFile::length));
        HashSet<RelFile> alreadyInvalidatedFilesSet = new HashSet<RelFile>(invalidatedFiles);
        for (RelFile file : invalidatedFiles) {
            if (!file.isRoot() && alreadyInvalidatedFilesSet.contains(file.getParent())) continue;
            alreadyInvalidatedFilesSet.add(file);
            logger.info((Object)("INVALIDATED " + String.valueOf(file)));
            this.transactionService.invalidateCache(file);
        }
        return invalidatedFiles.size();
    }

    @AuditedCall(value={"msgType", "dump-datadir"})
    @RequestMapping(value={"/api/doomer/list-datadir"})
    @ResponseBody
    public List<RelFile> listDatadir(HttpServletRequest req, HttpServletResponse resp, String path) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        NativeFS dataDir = NativeFS.from((File)DKUApp.getBaseFolderF()).build();
        return dataDir.listFiles(path);
    }

    @AuditedCall(value={"msgType", "dump-datadir"})
    @RequestMapping(value={"/api/doomer/mass-export"}, method={RequestMethod.GET})
    public void readDatadir(HttpServletRequest req, HttpServletResponse resp, String path) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        NativeFS dataDir = NativeFS.from((File)DKUApp.getBaseFolderF()).build();
        if (dataDir.isDirectory(path)) {
            try (ZipWriteFS zip = new ZipWriteFS((OutputStream)resp.getOutputStream(), 1);){
                FSUtils.newRecursiveCopy().from((ReadOnlyFS)dataDir, path).to((ReadWriteFS)zip).run();
            }
        } else if (dataDir.isFile(path)) {
            try (RelFileInputStream is = dataDir.readStream(path);){
                IOUtils.copyLarge((InputStream)is, (OutputStream)resp.getOutputStream());
            }
        } else {
            throw new RuntimeException(String.valueOf(dataDir.resolve(RelFile.fromPath((String)path))) + " does not exist");
        }
    }

    @AuditedCall(value={"msgType", "mass-import"})
    @RequestMapping(value={"/api/doomer/mass-import"}, method={RequestMethod.POST})
    @ResponseBody
    public long patchDatadir(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        try (ZipInputStream zis = new ZipInputStream((InputStream)req.getInputStream());){
            NativeFS dataDirFs = NativeFS.from((File)DKUApp.getBaseFolderF()).skipFileTypeCheck(true).atomicWrite(false).rejectSymlinks(false).build();
            List<RelFile> unzippedFiles = DoomerController.unzipAsync(zis, (ReadWriteFS)dataDirFs, RelFile.fromPath((String)""), 4);
            int nbInvalidatedFiles = this.invalidateConfigCache(unzippedFiles);
            logger.info((Object)("Imported " + unzippedFiles.size() + " files (invalidated " + nbInvalidatedFiles + " files)"));
            long l = unzippedFiles.size();
            return l;
        }
    }

    @AuditedCall(value={"msgType", "patch-datadir"})
    @RequestMapping(value={"/api/doomer/mass-delete"}, method={RequestMethod.POST})
    public void massDelete(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<RelFile> paths) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        NativeFS dataDir = NativeFS.from((File)DKUApp.getBaseFolderF()).build();
        paths.parallelStream().forEach(ExceptionUtils.checkedConsumer(arg_0 -> ((NativeFS)dataDir).deleteFileOrDirectory(arg_0)));
        this.invalidateConfigCache(paths);
    }

    @AuditedCall(value={"msgType", "fix-subgits"})
    @RequestMapping(value={"/api/doomer/fix-subgits"}, method={RequestMethod.POST})
    public void fixSubgits(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        IGitManager gitManager = this.transactionService.getGitManager();
        if (gitManager instanceof MultiRepositoryProjectsGitManager) {
            ((MultiRepositoryProjectsGitManager)gitManager).invalidateSubGits();
        }
    }
}

