/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibtd.com.fasterxml.jackson.datatype.jsonorg;

import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.core.JsonToken;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.type.LogicalType;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.util.ClassUtil;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.datatype.jsonorg.JSONObjectDeserializer;
import com.dataiku.dss.shadelibtd.org.json.JSONArray;
import com.dataiku.dss.shadelibtd.org.json.JSONObject;
import java.io.IOException;

public class JSONArrayDeserializer
extends StdDeserializer<JSONArray> {
    private static final long serialVersionUID = 1L;
    public static final JSONArrayDeserializer instance = new JSONArrayDeserializer();

    public JSONArrayDeserializer() {
        super(JSONArray.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public JSONArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2;
        if (!p.isExpectedStartArrayToken()) {
            JsonToken t3 = p.currentToken();
            return (JSONArray)ctxt.handleUnexpectedToken(this.handledType(), t3, p, "Unexpected token (%s), expected START_ARRAY for %s value", new Object[]{t3, ClassUtil.nameOf(this.handledType())});
        }
        JSONArray array = new JSONArray();
        block11: while ((t2 = p.nextToken()) != JsonToken.END_ARRAY) {
            switch (t2) {
                case START_ARRAY: {
                    array.put(this.deserialize(p, ctxt));
                    continue block11;
                }
                case START_OBJECT: {
                    array.put(JSONObjectDeserializer.instance.deserialize(p, ctxt));
                    continue block11;
                }
                case VALUE_STRING: {
                    array.put(p.getText());
                    continue block11;
                }
                case VALUE_NULL: {
                    array.put(JSONObject.NULL);
                    continue block11;
                }
                case VALUE_TRUE: {
                    array.put(Boolean.TRUE);
                    continue block11;
                }
                case VALUE_FALSE: {
                    array.put(Boolean.FALSE);
                    continue block11;
                }
                case VALUE_NUMBER_INT: {
                    array.put(p.getNumberValue());
                    continue block11;
                }
                case VALUE_NUMBER_FLOAT: {
                    array.put(p.getDecimalValue());
                    continue block11;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    array.put(p.getEmbeddedObject());
                    continue block11;
                }
            }
            return (JSONArray)ctxt.handleUnexpectedToken(this.handledType(), p);
        }
        return array;
    }
}

