/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibtd.org.msgpack.value.impl;

import com.dataiku.dss.shadelibtd.org.msgpack.core.MessageFormat;
import com.dataiku.dss.shadelibtd.org.msgpack.core.MessageIntegerOverflowException;
import com.dataiku.dss.shadelibtd.org.msgpack.core.MessagePacker;
import com.dataiku.dss.shadelibtd.org.msgpack.value.ImmutableIntegerValue;
import com.dataiku.dss.shadelibtd.org.msgpack.value.ImmutableNumberValue;
import com.dataiku.dss.shadelibtd.org.msgpack.value.IntegerValue;
import com.dataiku.dss.shadelibtd.org.msgpack.value.Value;
import com.dataiku.dss.shadelibtd.org.msgpack.value.ValueType;
import com.dataiku.dss.shadelibtd.org.msgpack.value.impl.AbstractImmutableValue;
import java.io.IOException;
import java.math.BigInteger;

public class ImmutableBigIntegerValueImpl
extends AbstractImmutableValue
implements ImmutableIntegerValue {
    private final BigInteger value;
    private static final BigInteger BYTE_MIN = BigInteger.valueOf(-128L);
    private static final BigInteger BYTE_MAX = BigInteger.valueOf(127L);
    private static final BigInteger SHORT_MIN = BigInteger.valueOf(-32768L);
    private static final BigInteger SHORT_MAX = BigInteger.valueOf(32767L);
    private static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);

    public static MessageFormat mostSuccinctMessageFormat(IntegerValue integerValue) {
        if (integerValue.isInByteRange()) {
            return MessageFormat.INT8;
        }
        if (integerValue.isInShortRange()) {
            return MessageFormat.INT16;
        }
        if (integerValue.isInIntRange()) {
            return MessageFormat.INT32;
        }
        if (integerValue.isInLongRange()) {
            return MessageFormat.INT64;
        }
        return MessageFormat.UINT64;
    }

    public ImmutableBigIntegerValueImpl(BigInteger bigInteger) {
        this.value = bigInteger;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.INTEGER;
    }

    @Override
    public ImmutableIntegerValue immutableValue() {
        return this;
    }

    @Override
    public ImmutableNumberValue asNumberValue() {
        return this;
    }

    @Override
    public ImmutableIntegerValue asIntegerValue() {
        return this;
    }

    @Override
    public byte toByte() {
        return this.value.byteValue();
    }

    @Override
    public short toShort() {
        return this.value.shortValue();
    }

    @Override
    public int toInt() {
        return this.value.intValue();
    }

    @Override
    public long toLong() {
        return this.value.longValue();
    }

    @Override
    public BigInteger toBigInteger() {
        return this.value;
    }

    @Override
    public float toFloat() {
        return this.value.floatValue();
    }

    @Override
    public double toDouble() {
        return this.value.doubleValue();
    }

    @Override
    public boolean isInByteRange() {
        return 0 <= this.value.compareTo(BYTE_MIN) && this.value.compareTo(BYTE_MAX) <= 0;
    }

    @Override
    public boolean isInShortRange() {
        return 0 <= this.value.compareTo(SHORT_MIN) && this.value.compareTo(SHORT_MAX) <= 0;
    }

    @Override
    public boolean isInIntRange() {
        return 0 <= this.value.compareTo(INT_MIN) && this.value.compareTo(INT_MAX) <= 0;
    }

    @Override
    public boolean isInLongRange() {
        return 0 <= this.value.compareTo(LONG_MIN) && this.value.compareTo(LONG_MAX) <= 0;
    }

    @Override
    public MessageFormat mostSuccinctMessageFormat() {
        return ImmutableBigIntegerValueImpl.mostSuccinctMessageFormat(this);
    }

    @Override
    public byte asByte() {
        if (!this.isInByteRange()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return this.value.byteValue();
    }

    @Override
    public short asShort() {
        if (!this.isInShortRange()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return this.value.shortValue();
    }

    @Override
    public int asInt() {
        if (!this.isInIntRange()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return this.value.intValue();
    }

    @Override
    public long asLong() {
        if (!this.isInLongRange()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return this.value.longValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.value;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packBigInteger(this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isIntegerValue()) {
            return false;
        }
        IntegerValue integerValue = value.asIntegerValue();
        return this.value.equals(integerValue.toBigInteger());
    }

    public int hashCode() {
        if (INT_MIN.compareTo(this.value) <= 0 && this.value.compareTo(INT_MAX) <= 0) {
            return (int)this.value.longValue();
        }
        if (LONG_MIN.compareTo(this.value) <= 0 && this.value.compareTo(LONG_MAX) <= 0) {
            long l = this.value.longValue();
            return (int)(l ^ l >>> 32);
        }
        return this.value.hashCode();
    }

    @Override
    public String toJson() {
        return this.value.toString();
    }

    public String toString() {
        return this.toJson();
    }
}

