/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.util.Preconditions;
import java.util.List;

public class ExpressionUtils {
    public static Predicate asPredicate(Expression expression) {
        Preconditions.checkArgument(expression instanceof Predicate, "Expected predicate but got %s", expression);
        return (Predicate)expression;
    }

    public static Expression getLeft(Expression expression) {
        List<Expression> list = expression.getChildren();
        Preconditions.checkArgument(list.size() == 2, "%s: expected two inputs, but got %s", expression, list.size());
        return list.get(0);
    }

    public static Expression getRight(Expression expression) {
        List<Expression> list = expression.getChildren();
        Preconditions.checkArgument(list.size() == 2, "%s: expected two inputs, but got %s", expression, list.size());
        return list.get(1);
    }

    public static Expression getUnaryChild(Expression expression) {
        List<Expression> list = expression.getChildren();
        Preconditions.checkArgument(list.size() == 1, "%s: expected one inputs, but got %s", expression, list.size());
        return list.get(0);
    }
}

