/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.xor;

import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.EncryptionVerifier;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.LittleEndianInput;

public class XOREncryptionVerifier
extends EncryptionVerifier
implements EncryptionRecord {
    protected XOREncryptionVerifier() {
        this.setEncryptedKey(new byte[2]);
        this.setEncryptedVerifier(new byte[2]);
    }

    protected XOREncryptionVerifier(LittleEndianInput is) {
        byte[] key = new byte[2];
        is.readFully(key);
        this.setEncryptedKey(key);
        byte[] verifier = new byte[2];
        is.readFully(verifier);
        this.setEncryptedVerifier(verifier);
    }

    protected XOREncryptionVerifier(XOREncryptionVerifier other) {
        super(other);
    }

    @Override
    public void write(LittleEndianByteArrayOutputStream bos) {
        bos.write(this.getEncryptedKey());
        bos.write(this.getEncryptedVerifier());
    }

    @Override
    public XOREncryptionVerifier copy() {
        return new XOREncryptionVerifier(this);
    }

    @Override
    public final void setEncryptedVerifier(byte[] encryptedVerifier) {
        super.setEncryptedVerifier(encryptedVerifier);
    }

    @Override
    public final void setEncryptedKey(byte[] encryptedKey) {
        super.setEncryptedKey(encryptedKey);
    }
}

