/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.krb;

import java.io.File;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class Krb5KeytabLoginContext {
    private static Logger logger = Logger.getLogger((String)"dip.krb.login");
    private static boolean isIBMJavaSec = System.getProperty("java.vendor").contains("IBM") && System.getProperty("java.specification.version").matches("1.[78]");
    private static Method gssImpersonateMethod;
    private String principal;
    private String keytab;
    private long keytabLastModified;
    private final Subject subject = new Subject();

    public Krb5KeytabLoginContext(String principal, String keytab) {
        this.principal = principal;
        this.keytab = keytab;
    }

    private long checkKeytabAndGetKeytabLastModified() {
        File keytabFile = new File(this.keytab);
        if (!keytabFile.exists()) {
            throw new IllegalArgumentException("Keytab file doesn't exist");
        }
        return keytabFile.lastModified();
    }

    public void close() throws LoginException {
    }

    private void login() throws LoginException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String krb5LoginModuleName;
        logger.info((Object)("Logging in to Kerberos, principal=" + this.principal + " keytab=" + this.keytab));
        this.keytabLastModified = this.checkKeytabAndGetKeytabLastModified();
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (isIBMJavaSec) {
            krb5LoginModuleName = "com.ibm.security.auth.module.Krb5LoginModule";
            options.put("useKeytab", "file://" + new File(this.keytab).getAbsolutePath());
            options.put("principal", this.principal);
            options.put("credsType", "both");
        } else {
            krb5LoginModuleName = "com.sun.security.auth.module.Krb5LoginModule";
            options.put("doNotPrompt", "true");
            options.put("useKeyTab", "true");
            options.put("keyTab", this.keytab);
            options.put("principal", this.principal);
        }
        if ("true".equalsIgnoreCase(System.getenv("DKU_JAAS_DEBUG"))) {
            options.put("debug", "true");
        }
        LoginModule krb5Module = (LoginModule)Class.forName(krb5LoginModuleName).newInstance();
        CallbackHandler callbackHandler = null;
        HashMap sharedState = new HashMap();
        krb5Module.initialize(this.subject, callbackHandler, sharedState, options);
        if (!krb5Module.login()) {
            throw new LoginException("Krb5 login failed");
        }
        this.subject.getPrincipals().clear();
        this.subject.getPublicCredentials().clear();
        this.subject.getPrivateCredentials().clear();
        if (!krb5Module.commit()) {
            throw new LoginException("Login from keytab failed for principal " + this.principal);
        }
        if (logger.isInfoEnabled()) {
            KerberosTicket tgt = this.getTGT();
            logger.info((Object)("Successfully logged subject = " + String.valueOf(this.subject.getPrincipals()) + ", TGT end time = " + String.valueOf(tgt == null ? "<null>" : tgt.getEndTime())));
        }
    }

    private KerberosTicket getTGT() {
        for (KerberosTicket ticket : this.subject.getPrivateCredentials(KerberosTicket.class)) {
            if (!ticket.isInitial()) continue;
            return ticket;
        }
        return null;
    }

    private boolean needsRefresh() {
        if (this.checkKeytabAndGetKeytabLastModified() != this.keytabLastModified) {
            return true;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt == null) {
            return true;
        }
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        return !tgt.isCurrent() || System.currentTimeMillis() > start + (end - start) / 2L;
    }

    public Subject getSubject() throws Exception {
        if (this.needsRefresh()) {
            this.login();
        }
        return this.subject;
    }

    public static GSSCredential getImpersonatedCredential(Subject doAs, String userPrincipal) throws Exception {
        if (gssImpersonateMethod == null) {
            throw new Exception("Kerberos constrained delegation requires Java 8");
        }
        logger.info((Object)("Retrieving impersonated Kerberos credentials for " + userPrincipal));
        final GSSManager manager = GSSManager.getInstance();
        GSSCredential gssCred = Subject.doAs(doAs, new PrivilegedExceptionAction<GSSCredential>(){

            @Override
            public GSSCredential run() throws GSSException {
                return manager.createCredential(1);
            }
        });
        GSSName user = manager.createName(userPrincipal, GSSName.NT_USER_NAME);
        return (GSSCredential)gssImpersonateMethod.invoke((Object)gssCred, user);
    }

    static {
        String extendedGSSCredentialClassName = isIBMJavaSec ? "com.ibm.security.jgss.ExtendedGSSCredential" : "com.sun.security.jgss.ExtendedGSSCredential";
        try {
            gssImpersonateMethod = Class.forName(extendedGSSCredentialClassName).getMethod("impersonate", GSSName.class);
        }
        catch (Throwable e) {
            logger.warn((Object)"Impersonation not available, java8 needed", e);
        }
    }
}

