/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;

public class CalibrationMethodStrategyExtractorJson
implements ModelExtractor<String> {
    private final String jsonPath;
    private final JsonPath compiled;

    public CalibrationMethodStrategyExtractorJson(String jsonPath) {
        this.jsonPath = jsonPath;
        this.compiled = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        try {
            String modelCalibrationMethodName = (String)documentContext.read(this.compiled);
            for (CalibrationMethodName calibrationMethodName : CalibrationMethodName.values()) {
                if (!calibrationMethodName.name().equals(modelCalibrationMethodName)) continue;
                return calibrationMethodName.getUserFriendlyName();
            }
            return CalibrationMethodName.NO_CALIBRATION.getUserFriendlyName();
        }
        catch (PathNotFoundException e) {
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
    }

    private static enum CalibrationMethodName {
        ISOTONIC("Isotonic Regression"),
        SIGMOID("Sigmoid (Platt scaling)"),
        NO_CALIBRATION("No calibration");

        private String userFriendlyName;

        private CalibrationMethodName(String userFriendlyName) {
            this.userFriendlyName = userFriendlyName;
        }

        String getUserFriendlyName() {
            return this.userFriendlyName;
        }
    }
}

