/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ExplicitPairwiseFeatureTableExtractor
implements ModelExtractor<List<List<String>>> {
    private boolean isNumeric(String variableName, DocumentContext documentContext) {
        String variableType = (String)documentContext.read(JsonPath.compile((String)("$.preprocessing.per_feature['" + Utils.escape((String)variableName, (boolean)true) + "'].type"), (Predicate[])new Predicate[0]));
        return "NUMERIC".equals(variableType);
    }

    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        try {
            ArrayList<List<String>> features = new ArrayList<List<String>>();
            List interactions = (List)documentContext.read(JsonPath.compile((String)"$.preprocessing.feature_generation.manual_interactions.interactions", (Predicate[])new Predicate[0]));
            features.add(Arrays.asList("Column 1", "Column 2", "Max features", "rescale"));
            if (interactions != null) {
                for (Map interaction : interactions) {
                    if (!interaction.containsKey("column_1") || !interaction.containsKey("column_2")) continue;
                    String column1 = interaction.get("column_1").toString();
                    String column2 = interaction.get("column_2").toString();
                    if (this.isNumeric(column1, documentContext) && this.isNumeric(column2, documentContext)) {
                        if (interaction.containsKey("rescale")) {
                            if ("true".equals(interaction.get("rescale").toString())) {
                                features.add(Arrays.asList(column1, column2, "N/A", "Yes"));
                                continue;
                            }
                            features.add(Arrays.asList(column1, column2, "N/A", "No"));
                            continue;
                        }
                        features.add(Arrays.asList(column1, column2, "N/A", "N/A"));
                        continue;
                    }
                    if (interaction.containsKey("max_features")) {
                        features.add(Arrays.asList(column1, column2, interaction.get("max_features").toString(), "N/A"));
                        continue;
                    }
                    features.add(Arrays.asList(column1, column2, "N/A", "N/A"));
                }
            }
            if (features.size() == 1) {
                features.clear();
                features.add(Collections.singletonList("No explicit pairwise interaction defined."));
            }
            return features;
        }
        catch (PathNotFoundException | ClassCastException e) {
            throw new IOException("Cannot extract the JsonPath \"$.preprocessing.feature_generation.manual_interactions.interactions\".");
        }
    }
}

