/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.validator;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.docgen.validator.ModelValidator;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dss.shadelib.com.google.common.collect.Sets;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.Set;

public class FeatureImportanceStatusValidator
implements ModelExtractor<String>,
ModelValidator {
    private static final Set<PreTrainPredictionModelingParams.Algorithm> compatibleAlgorithms = Sets.newHashSet((Object[])new PreTrainPredictionModelingParams.Algorithm[]{PreTrainPredictionModelingParams.Algorithm.RANDOM_FOREST_CLASSIFICATION, PreTrainPredictionModelingParams.Algorithm.RANDOM_FOREST_REGRESSION, PreTrainPredictionModelingParams.Algorithm.GBT_CLASSIFICATION, PreTrainPredictionModelingParams.Algorithm.GBT_REGRESSION, PreTrainPredictionModelingParams.Algorithm.LIGHTGBM_CLASSIFICATION, PreTrainPredictionModelingParams.Algorithm.LIGHTGBM_CLASSIFICATION, PreTrainPredictionModelingParams.Algorithm.XGBOOST_CLASSIFICATION, PreTrainPredictionModelingParams.Algorithm.XGBOOST_REGRESSION, PreTrainPredictionModelingParams.Algorithm.DECISION_TREE_CLASSIFICATION, PreTrainPredictionModelingParams.Algorithm.DECISION_TREE_REGRESSION, PreTrainPredictionModelingParams.Algorithm.EXTRA_TREES, PreTrainPredictionModelingParams.Algorithm.CUSTOM_PLUGIN, PreTrainPredictionModelingParams.Algorithm.MLLIB_RANDOM_FOREST, PreTrainPredictionModelingParams.Algorithm.MLLIB_CUSTOM});
    private static final Set<PreTrainClusteringModelingParams.Algorithm> compatibleClusteringAlgorithms = Sets.newHashSet((Object[])new PreTrainClusteringModelingParams.Algorithm[]{PreTrainClusteringModelingParams.Algorithm.KMEANS, PreTrainClusteringModelingParams.Algorithm.GMM, PreTrainClusteringModelingParams.Algorithm.MiniBatchKMeans, PreTrainClusteringModelingParams.Algorithm.WARD, PreTrainClusteringModelingParams.Algorithm.SPECTRAL, PreTrainClusteringModelingParams.Algorithm.DBSCAN, PreTrainClusteringModelingParams.Algorithm.HDBSCAN, PreTrainClusteringModelingParams.Algorithm.PY_TWO_STEP, PreTrainClusteringModelingParams.Algorithm.PY_ISOLATION_FOREST, PreTrainClusteringModelingParams.Algorithm.SCIKIT_MODEL, PreTrainClusteringModelingParams.Algorithm.MLLIB_KMEANS, PreTrainClusteringModelingParams.Algorithm.MLLIB_GAUSSIAN_MIXTURE, PreTrainClusteringModelingParams.Algorithm.MLLIB_ISOLATION_FOREST, PreTrainClusteringModelingParams.Algorithm.MLLIB_TWO_STEP, PreTrainClusteringModelingParams.Algorithm.MLLIB_CUSTOM, PreTrainClusteringModelingParams.Algorithm.SPARKLING_KMEANS});

    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) {
        return FeatureImportanceStatusValidator.isCompatible(model) ? "Yes" : "No";
    }

    @Override
    public void validate(ModelDetailsBase model) throws IOException {
        if (model instanceof ClassicalPredictionModelDetails && ((ClassicalPredictionModelDetails)model).modeling != null) {
            ClassicalPredictionModelDetails predictionModelDetails = (ClassicalPredictionModelDetails)model;
            if (!compatibleAlgorithms.contains((Object)predictionModelDetails.modeling.algorithm)) {
                throw new IOException("it is not supported with the algorithm " + predictionModelDetails.modeling.algorithm.name() + ".");
            }
        } else if (model instanceof ClusteringModelDetails && ((ClusteringModelDetails)model).modeling != null) {
            ClusteringModelDetails clusteringModelDetails = (ClusteringModelDetails)model;
            if (!compatibleClusteringAlgorithms.contains((Object)clusteringModelDetails.modeling.algorithm)) {
                throw new IOException("it is not supported with the algorithm " + clusteringModelDetails.modeling.algorithm.name() + ".");
            }
        } else {
            throw new IOException("The model is invalid.");
        }
    }

    private static boolean isCompatible(ModelDetailsBase model) {
        if (model instanceof ClassicalPredictionModelDetails && ((ClassicalPredictionModelDetails)model).modeling != null) {
            ClassicalPredictionModelDetails predictionModel = (ClassicalPredictionModelDetails)model;
            if (predictionModel.coreParams != null && predictionModel.coreParams.partitionedModel != null && predictionModel.coreParams.partitionedModel.enabled) {
                return false;
            }
            return compatibleAlgorithms.contains((Object)predictionModel.modeling.algorithm);
        }
        if (model instanceof ClusteringModelDetails && ((ClusteringModelDetails)model).modeling != null) {
            ClusteringModelDetails clusteringModelDetails = (ClusteringModelDetails)model;
            return compatibleClusteringAlgorithms.contains((Object)clusteringModelDetails.modeling.algorithm);
        }
        return false;
    }
}

