/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.guess;

import com.dataiku.dip.analysis.ml.prediction.guess.CausalPredictionGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.CustomPredictionGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.DecisionTreeGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.DeepHubPredictionGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.DeepLearningTimeseriesForecastingGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.DefaultPredictionGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.DefaultTimeseriesForecastingGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.ExplanatoryModelsGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.InterpretableGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.PerformanceGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.PredictionGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.SimpleFormulaGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.StatisticalTimeseriesForecastingGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.TimeseriesForecastingGuesser;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface GuessPolicyMeta {
    public List<MLTask.BackendType> supportedBackends();

    public String analysisDefaultName();

    public String name();

    public String description();

    public String thumbnail();

    public String icon();

    public PredictionGuesser<? extends PredictionMLTask> getGuesser(PredictionMLTask var1, MemTable var2);

    public static class TimeseriesForecastingDeepLearningPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Collections.singletonList(MLTask.BackendType.PY_MEMORY);
        }

        @Override
        public String analysisDefaultName() {
            return "Time series modeling of {target} on {dataset}, using deep learning models";
        }

        @Override
        public String name() {
            return "Deep Learning Models";
        }

        @Override
        public String thumbnail() {
            return "deep-learning";
        }

        @Override
        public String icon() {
            return "dku-icon-deep-learning";
        }

        @Override
        public String description() {
            return "Start with deep learning models only.";
        }

        public TimeseriesForecastingGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new DeepLearningTimeseriesForecastingGuesser((PredictionMLTask.TimeseriesForecastingMLTask)task, data);
        }
    }

    public static class TimeseriesForecastingStatisticalPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Collections.singletonList(MLTask.BackendType.PY_MEMORY);
        }

        @Override
        public String analysisDefaultName() {
            return "Time series modeling of {target} on {dataset}, using statistical models";
        }

        @Override
        public String name() {
            return "Statistical Models";
        }

        @Override
        public String thumbnail() {
            return "statistical";
        }

        @Override
        public String icon() {
            return "dku-icon-modelize";
        }

        @Override
        public String description() {
            return "Start with statistical models only.";
        }

        public TimeseriesForecastingGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new StatisticalTimeseriesForecastingGuesser((PredictionMLTask.TimeseriesForecastingMLTask)task, data);
        }
    }

    public static class TimeseriesForecastingDefaultPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Collections.singletonList(MLTask.BackendType.PY_MEMORY);
        }

        @Override
        public String analysisDefaultName() {
            return "Quick time series modeling of {target} on {dataset}";
        }

        @Override
        public String name() {
            return "Quick Prototypes";
        }

        @Override
        public String thumbnail() {
            return "quick-proto";
        }

        @Override
        public String icon() {
            return "dku-icon-api-connect";
        }

        @Override
        public String description() {
            return "Get some forecasting models, generic and quick.";
        }

        public TimeseriesForecastingGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new DefaultTimeseriesForecastingGuesser((PredictionMLTask.TimeseriesForecastingMLTask)task, data);
        }
    }

    public static class CausalPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY);
        }

        @Override
        public String analysisDefaultName() {
            return "Predict effect of \"{treatment}\" on \"{target}\"";
        }

        @Override
        public String name() {
            return "Causal Prediction";
        }

        @Override
        public String description() {
            return "Analyze the causal effect of a treatment on an outcome";
        }

        @Override
        public String thumbnail() {
            return "causal-prediction";
        }

        @Override
        public String icon() {
            return "dku-icon-causal";
        }

        public CausalPredictionGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new CausalPredictionGuesser((PredictionMLTask.CausalPredictionMLTask)task, data);
        }
    }

    public static class DeepHubObjectDetectionPolicyMeta
    extends DeepHubPolicyMeta {
        @Override
        public String analysisDefaultName() {
            return "Object detection of {target} on {dataset}";
        }

        @Override
        public String description() {
            return "Object detection models";
        }
    }

    public static class DeepHubImageClassificationPolicyMeta
    extends DeepHubPolicyMeta {
        @Override
        public String analysisDefaultName() {
            return "Image classification of {target} on {dataset}";
        }

        @Override
        public String description() {
            return "Image classification models";
        }
    }

    public static abstract class DeepHubPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Collections.singletonList(MLTask.BackendType.DEEP_HUB);
        }

        @Override
        public String name() {
            return "Deep Hub";
        }

        @Override
        public String thumbnail() {
            return "quick-proto";
        }

        @Override
        public String icon() {
            return "dku-icon-api-connect";
        }

        public DeepHubPredictionGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new DeepHubPredictionGuesser((PredictionMLTask.DeepHubPredictionMLTask)task, data);
        }
    }

    public static class ExplanatoryPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB);
        }

        @Override
        public String analysisDefaultName() {
            return "Insights into {target} for {dataset}";
        }

        @Override
        public String name() {
            return "Insights";
        }

        @Override
        public String thumbnail() {
            return "quick-proto";
        }

        @Override
        public String icon() {
            return "dku-icon-thumbs-up";
        }

        @Override
        public String description() {
            return "Generate several models to gather insights into the target variable.";
        }

        public ExplanatoryModelsGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new ExplanatoryModelsGuesser((PredictionMLTask.ClassicalPredictionMLTask)task, data);
        }
    }

    public static class DecisionTreePolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB);
        }

        @Override
        public String analysisDefaultName() {
            return "Decision Tree for {target} on {dataset}";
        }

        @Override
        public String name() {
            return "Decision Tree";
        }

        @Override
        public String thumbnail() {
            return "quick-proto";
        }

        @Override
        public String icon() {
            return "dku-icon-sitemap";
        }

        @Override
        public String description() {
            return "Build a decision tree to explain the value of a column in your dataset through decision rules.";
        }

        public DecisionTreeGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new DecisionTreeGuesser((PredictionMLTask.ClassicalPredictionMLTask)task, data);
        }
    }

    public static class SimpleFormulaPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB, MLTask.BackendType.H2O, MLTask.BackendType.KERAS);
        }

        @Override
        public String analysisDefaultName() {
            return "Simple formula for {target} on {dataset}";
        }

        @Override
        public String name() {
            return "Simple Formula";
        }

        @Override
        public String thumbnail() {
            return "quick-proto";
        }

        @Override
        public String icon() {
            return "dku-icon-text-superscript";
        }

        @Override
        public String description() {
            return "Generate a simple linear model to predict the target";
        }

        public SimpleFormulaGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new SimpleFormulaGuesser((PredictionMLTask.ClassicalPredictionMLTask)task, data);
        }
    }

    public static class CustomPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB);
        }

        @Override
        public String analysisDefaultName() {
            return "Write your own estimator for {target} on {dataset}";
        }

        @Override
        public String name() {
            return "Write Your Own Estimator";
        }

        @Override
        public String thumbnail() {
            return "predictors";
        }

        @Override
        public String icon() {
            return "dku-icon-keyboard";
        }

        @Override
        public String description() {
            return "Train your own Python or Scala models.";
        }

        public CustomPredictionGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new CustomPredictionGuesser((PredictionMLTask.ClassicalPredictionMLTask)task, data);
        }
    }

    public static class DeepLearningPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Collections.singletonList(MLTask.BackendType.KERAS);
        }

        @Override
        public String analysisDefaultName() {
            return "Deep learning for {target} on {dataset}";
        }

        @Override
        public String name() {
            return "Deep Learning";
        }

        @Override
        public String thumbnail() {
            return "deep-learning";
        }

        @Override
        public String icon() {
            return "dku-icon-keras";
        }

        @Override
        public String description() {
            return "Create the architecture of your deep learning models and train them.";
        }

        public DefaultPredictionGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new DefaultPredictionGuesser((PredictionMLTask.ClassicalPredictionMLTask)task, data);
        }
    }

    public static class AlgorithmsPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB, MLTask.BackendType.H2O);
        }

        @Override
        public String analysisDefaultName() {
            return "Choose Algorithms for {target} on {dataset}";
        }

        @Override
        public String name() {
            return "Choose Algorithms";
        }

        @Override
        public String thumbnail() {
            return "algorithms";
        }

        @Override
        public String icon() {
            return "dku-icon-menu-grid-dots";
        }

        @Override
        public String description() {
            return "Select the algorithms and the hyper parameters to use in cross-validation.";
        }

        public DefaultPredictionGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new DefaultPredictionGuesser((PredictionMLTask.ClassicalPredictionMLTask)task, data);
        }
    }

    public static class PerformancePolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Lists.newArrayList((Object[])new MLTask.BackendType[]{MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB, MLTask.BackendType.H2O});
        }

        @Override
        public String analysisDefaultName() {
            return "Performance modeling of {target} on {dataset}";
        }

        @Override
        public String name() {
            return "High Performance Models";
        }

        @Override
        public String thumbnail() {
            return "high-perf";
        }

        @Override
        public String icon() {
            return "dku-icon-gpu-card";
        }

        @Override
        public String description() {
            return "Be patient and get even more accurate models.";
        }

        public PerformanceGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new PerformanceGuesser((PredictionMLTask.ClassicalPredictionMLTask)task, data);
        }
    }

    public static class InterpretablePolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB, MLTask.BackendType.H2O);
        }

        @Override
        public String analysisDefaultName() {
            return "Interpretable modeling of {target} on {dataset}";
        }

        @Override
        public String name() {
            return "Interpretable Models for Business Analysts";
        }

        @Override
        public String thumbnail() {
            return "interpretable";
        }

        @Override
        public String icon() {
            return "dku-icon-comment-multiple";
        }

        @Override
        public String description() {
            return "Start with decision tree and simple linear models.";
        }

        public InterpretableGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new InterpretableGuesser((PredictionMLTask.ClassicalPredictionMLTask)task, data);
        }
    }

    public static class PrototypesPolicyMeta
    implements GuessPolicyMeta {
        @Override
        public List<MLTask.BackendType> supportedBackends() {
            return Arrays.asList(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.MLLIB, MLTask.BackendType.H2O);
        }

        @Override
        public String analysisDefaultName() {
            return "Quick modeling of {target} on {dataset}";
        }

        @Override
        public String name() {
            return "Quick Prototypes";
        }

        @Override
        public String thumbnail() {
            return "quick-proto";
        }

        @Override
        public String icon() {
            return "dku-icon-api-connect";
        }

        @Override
        public String description() {
            return "Get some models, generic and quick.";
        }

        public DefaultPredictionGuesser getGuesser(PredictionMLTask task, MemTable data) {
            return new DefaultPredictionGuesser((PredictionMLTask.ClassicalPredictionMLTask)task, data);
        }
    }
}

