/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import java.util.ArrayList;
import java.util.List;

public class ClusteringModelingParams {
    public DBScanParams db_scan_clustering = new DBScanParams();
    public HDBScanParams hdb_scan_clustering = new HDBScanParams();
    public SpectralParams spectral_clustering = new SpectralParams();
    public WardParams ward_clustering = new WardParams();
    public KMeansParams kmeans_clustering = new KMeansParams();
    public MiniBatchKMeansParams mini_batch_kmeans_clustering = new MiniBatchKMeansParams();
    public GMMParams gmm_clustering = new GMMParams();
    public MLLibKMeansParams mllib_kmeans_clustering = new MLLibKMeansParams();
    public MLLibGaussianMixtureParams mllib_gaussian_mixture_clustering = new MLLibGaussianMixtureParams();
    public H2OKMeansModelingParams h2o_kmeans = new H2OKMeansModelingParams();
    public TwoStepParams two_step = new TwoStepParams();
    public IsolationForestParams isolation_forest = new IsolationForestParams();
    @Deprecated
    public VerticaKMeansParams vertica_kmeans_clustering = new VerticaKMeansParams();
    public MetricParams metrics = new MetricParams();
    public List<ClusteringCustomPythonParams> custom_python = new ArrayList<ClusteringCustomPythonParams>();
    public List<PredictionModelingParams.MLLibCustomGridParams> custom_mllib = new ArrayList<PredictionModelingParams.MLLibCustomGridParams>();

    public void disableAll() {
        this.db_scan_clustering.enabled = false;
        this.hdb_scan_clustering.enabled = false;
        this.spectral_clustering.enabled = false;
        this.ward_clustering.enabled = false;
        this.kmeans_clustering.enabled = false;
        this.mini_batch_kmeans_clustering.enabled = false;
        this.gmm_clustering.enabled = false;
        this.mllib_kmeans_clustering.enabled = false;
        this.mllib_gaussian_mixture_clustering.enabled = false;
        this.h2o_kmeans.enabled = false;
        this.two_step.enabled = false;
        this.isolation_forest.enabled = false;
        for (ClusteringCustomPythonParams customPythonParams : this.custom_python) {
            customPythonParams.enabled = false;
        }
        for (PredictionModelingParams.MLLibCustomGridParams customMLLib : this.custom_mllib) {
            customMLLib.enabled = false;
        }
    }

    public static class DBScanParams {
        public double[] epsilon = new double[0];
        public double min_sample_ratio;
        public boolean enabled;
    }

    public static class HDBScanParams {
        public double[] min_cluster_size_ratio = new double[]{0.01, 0.03, 0.1, 0.3};
        public boolean enabled;
    }

    public static class SpectralParams
    extends KBasedModelingParams {
        public boolean enabled;
        public boolean affinity_rbf;
        public boolean affinity_nearest_neighbors;
        public boolean affinity_sigmoid;
        public boolean affinity_polynomial = true;
        public double[] gamma = new double[]{0.0};
        public double coef0;
        public int seed = 1337;
    }

    public static class WardParams
    extends KBasedModelingParams {
        public boolean enabled;
    }

    public static class KMeansParams
    extends KBasedModelingParams {
        private static boolean isMacOSX = "Mac OS X".equals(System.getProperty("os.name"));
        private static int defaultNJobs = Integer.parseInt(DKUApp.getProperty((String)"dku.kmeans.default_n_jobs", (String)"2"));
        public boolean enabled;
        public int seed = 1337;
        public int n_jobs = isMacOSX ? 1 : defaultNJobs;
        public boolean allow_sparse_matrices = false;
        public Integer n_init = 1;
    }

    public static class MiniBatchKMeansParams
    extends KBasedModelingParams {
        public boolean enabled;
        public int seed = 1337;
        public boolean allow_sparse_matrices = false;
        public Integer n_init = 1;
    }

    public static class GMMParams
    extends KBasedModelingParams {
        public boolean enabled;
        public int max_iterations;
        public int seed = 1337;
    }

    public static class MLLibKMeansParams
    extends KBasedModelingParams {
        public boolean enabled;
        public int seed = 1337;
        public int max_iterations;
    }

    public static class MLLibGaussianMixtureParams
    extends KBasedModelingParams {
        public int seed = 1337;
        public boolean enabled;
        public int max_iterations;
    }

    public static class H2OKMeansModelingParams
    extends KBasedModelingParams {
        public boolean enabled;
        public int seed = 1337;
        public int max_iterations;
        public String init;
    }

    public static class TwoStepParams {
        public int kmeans_k = 50;
        public int n_clusters = 5;
        public int seed = 1337;
        public int max_iterations = 30;
        public boolean enabled;
    }

    public static class IsolationForestParams {
        public int k = 2;
        public boolean enabled;
        public int n_estimators = 100;
        public float max_samples = 0.5f;
        public float max_features = 1.0f;
        public float contamination = 0.05f;
        public boolean use_auto_contamination = false;
        public boolean bootstrap = true;
        public int max_anomalies = 100;
        public int n_samples = 256;
        public int max_depth = 15;
        public int seed = 1337;
        public boolean allow_sparse_matrices = false;
        public int n_jobs = 1;
    }

    @Deprecated
    public static class VerticaKMeansParams {
        public boolean enabled;
        public int[] k = new int[]{5};
        public double[] epsilon = new double[]{1.0E-4};
        public int max_iterations = 50;
        public String description;
    }

    public static class MetricParams {
        public EvaluationMetric evaluationMetric = EvaluationMetric.SILHOUETTE;
        public String customEvaluationMetricName;
    }

    public static class ClusteringCustomPythonParams {
        public boolean enabled;
        public String code;
        public String name;
        public boolean custom_has_k;
        public int[] k = new int[0];
    }

    public static enum EvaluationMetric {
        SILHOUETTE,
        INERTIA,
        NB_CLUSTERS,
        CUSTOM;

    }

    static class KBasedModelingParams {
        public int[] k = new int[]{3, 5, 7};
        public boolean useClusterRange = false;
        public ClusterNumbersLinearRange range = new ClusterNumbersLinearRange(3, 7, 3);

        KBasedModelingParams() {
        }

        public int[] kValues() {
            return this.useClusterRange ? this.range.getClusters() : this.k;
        }

        public void setFactoryKValues() {
            this.k = new int[]{3, 5, 7};
            this.useClusterRange = false;
            this.range = new ClusterNumbersLinearRange(3, 7, 3);
        }
    }

    public static class ClusterNumbersLinearRange {
        public final int min;
        public final int max;
        public final int nbValues;

        public ClusterNumbersLinearRange(int min, int max, int nbValues) {
            if (min <= 0 || max <= 0 || nbValues <= 0) {
                throw new IllegalArgumentException("min, max  or nbValues must be greater than 0.");
            }
            if (min > max) {
                throw new IllegalArgumentException("min value must be less than max value");
            }
            this.min = min;
            this.max = max;
            this.nbValues = nbValues;
        }

        public int[] getClusters() {
            int[] k = new int[Math.max(0, Math.min(this.max - this.min + 1, this.nbValues))];
            float offset = 0.0f;
            float interval = (float)(this.max - this.min) / (float)(k.length - 1);
            for (int i = 0; i < k.length; ++i) {
                k[i] = Math.round((float)this.min + offset);
                offset += interval;
            }
            return k;
        }
    }
}

