/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms.python;

import com.dataiku.dip.analysis.ml.shared.ParameterAutoCompleter;
import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.ScikitAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import java.util.ArrayList;
import java.util.List;

public class PyGMMMeta
extends ScikitAlgorithmMeta {
    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return "Gaussian Mixture (k=" + rpmp.k + ")";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "k=" + rpmp.k;
    }

    @Override
    public ParameterAutoCompleter autoCompleter() {
        return new ParameterAutoCompleter.DummyDropAutoCompleter();
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
        ClusteringModelingParams.GMMParams gmm = task.modeling.gmm_clustering;
        if (gmm.enabled) {
            checks.checkAllPositive(gmm.kValues(), "Gaussian Mixture requires a (positive) number of clusters");
            for (FeaturePreprocessingParams p : task.preprocessing.per_feature.values()) {
                if (p.role != FeaturePreprocessingParams.Role.INPUT || p.type != FeaturePreprocessingParams.FeatureType.CATEGORY && p.type != FeaturePreprocessingParams.FeatureType.TEXT) continue;
                checks.addWarning("Categorical/Text in Gaussian Mixture", "Warning: you have selected categorical or text features to train a Gaussian Mixture Model. This may result in poor or even undefined clusterings. You may want to select only proper numerical features.");
                break;
            }
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        ClusteringModelingParams.GMMParams gmm = task.modeling.gmm_clustering;
        if (gmm.enabled) {
            for (int k : gmm.kValues()) {
                PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.GMM);
                rcmp.k = k;
                rcmp.max_iterations = gmm.max_iterations;
                if (gmm.seed != 0) {
                    rcmp.seed = gmm.seed;
                }
                ret.add(new WorkSet.ModelingSet(rcmp));
            }
        }
        return ret;
    }
}

