/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithDatabricksCredentials;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelib.com.databricks.sdk.core.DatabricksConfig;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DatabricksVolumeConnection
extends AbstractCloudStorageConnection
implements ConnectionWithDatabricksCredentials,
ConnectionWithEncryptedFields {
    public Params params = new Params();
    public static final String connectionType = "DatabricksVolume";
    private static final Logger logger = Logger.getLogger((String)"dku.databricksVolume");

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public List<String> getProviderTypes() {
        return Lists.newArrayList((Object[])new String[]{connectionType});
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials.class));
        ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials creds = this.getResolvedDatabricksCredentials(ctx);
        return clazz.cast(creds);
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.host = vc.expand(this.params.host);
        this.params.catalog = vc.expand(this.params.catalog);
        this.params.schema = vc.expand(this.params.schema);
        this.params.chvolume = vc.expand(this.params.chvolume);
        this.params.chroot = vc.expand(this.params.chroot);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.params.clientSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.clientSecret);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.clientSecret = cryptoService.decryptIfEncrypted(this.params.clientSecret);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean allowManagedFolders() {
        return this.allowManagedFolders;
    }

    @Override
    public boolean allowManagedDatasets() {
        return this.allowManagedDatasets;
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    @Override
    public com.dataiku.dip.utils.Params getDkuPropertiesAsParams() {
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.params.dkuProperties);
    }

    @Override
    public String getHDFSScheme() {
        return "dbfs";
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential("", this.params.password);
    }

    @Override
    @Nonnull
    public ConnectionWithDatabricksCredentials.IDatabricksParams getNonResolvedParams() {
        return this.params;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public String getDefaultAuthScope() {
        return "2ff814a6-3304-4ab8-85cb-cd0e6f879c1d/.default offline_access";
    }

    @Override
    public boolean useOfflineConsentForOauth2() {
        return false;
    }

    public JsonObject getResolvedParams(AuthCtx authCtx, @Nullable String projectKey) throws IOException {
        Params resolvedParams = (Params)JSON.deepCopy((Object)this.params);
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = projectKey == null ? variablesService.getForConnection(this, authCtx) : variablesService.getForConnectionAndProject(this, authCtx, projectKey);
        resolvedParams.host = vc.expand(resolvedParams.host);
        resolvedParams.catalog = vc.expand(resolvedParams.catalog);
        resolvedParams.schema = vc.expand(resolvedParams.schema);
        JsonObject result = JSON.toJsonObject((Object)resolvedParams);
        return result;
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    public String getResolvedHDFSRoot(AuthCtx authCtx, String projectKey) {
        String volume = StringUtils.isNotBlank((String)this.params.chvolume) ? this.params.chvolume : this.params.defaultManagedVolume;
        return "dbfs:/Volumes/" + this.params.catalog + "/" + this.params.schema + "/" + volume + PathUtils.makeLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)this.params.chroot, (String)""));
    }

    public ApiClient getApiClient(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials cred = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials.class);
        DatabricksConfig config = new DatabricksConfig();
        config.setHost(this.params.host);
        switch (cred.authType) {
            case PERSONAL_ACCESS_TOKEN: {
                config.setAuthType("pat").setToken(cred.personalToken);
                break;
            }
            case OAUTH2_APP: {
                if (StringUtils.defaultIfBlank((String)this.params.tokenEndpoint, (String)"").endsWith("/oidc/v1/token")) {
                    logger.info((Object)"Using oauth-m2m");
                    config.setAuthType("oauth-m2m").setHost(this.params.host).setClientId(this.params.getOAuth2ClientId()).setClientSecret(this.params.getOAuth2ClientSecret());
                    break;
                }
                logger.info((Object)"Using azure-client-secret");
                config.setAuthType("azure-client-secret").setAzureTenantId(this.params.getOAuth2AzureTenantId()).setAzureClientId(this.params.getOAuth2ClientId()).setAzureClientSecret(this.params.getOAuth2ClientSecret());
                break;
            }
            default: {
                throw new Error("Unreachable");
            }
        }
        return new ApiClient(config);
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testDatabricksVolume(authCtx, this);
    }

    public static class Params
    implements ConnectionWithDatabricksCredentials.IDatabricksParams {
        public String host;
        public ConnectionWithDatabricksCredentials.AuthType authType = ConnectionWithDatabricksCredentials.AuthType.PERSONAL_ACCESS_TOKEN;
        public String password;
        public String clientId;
        public String tenantId;
        public String clientSecret;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String scope;
        public boolean refreshTokenRotation;
        public String catalog;
        public String schema;
        public String defaultManagedVolume;
        public String defaultManagedPath;
        public String chvolume;
        public String chroot;
        public HDFSConnection.HiveSynchronizationMode metastoreSynchronizationMode = HDFSConnection.HiveSynchronizationMode.NO_SYNC;
        public String defaultMetastoreDatabase;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public FSProviderizableConnection.MetastoreAwareFilesBasedDatasetNamingRule namingRule = new FSProviderizableConnection.MetastoreAwareFilesBasedDatasetNamingRule();

        public String getDefaultManagedVolume() {
            return StringUtils.isNotBlank((String)this.chvolume) ? this.chvolume : this.defaultManagedVolume;
        }

        @Override
        public ConnectionWithDatabricksCredentials.AuthType getAuthType() {
            return this.authType;
        }

        @Override
        public String getOAuth2ClientId() {
            return this.clientId;
        }

        @Override
        public String getOAuth2ClientSecret() {
            return this.clientSecret;
        }

        @Override
        public String getOAuth2AuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        @Override
        public String getOAuth2TokenEndpoint() {
            return this.tokenEndpoint;
        }

        @Override
        public String getOAuth2AzureTenantId() {
            if (StringUtils.isBlank((String)this.tenantId)) {
                if (StringUtils.isBlank((String)this.tokenEndpoint)) {
                    throw new IllegalArgumentException("No tenant id nor token endpoint");
                }
                Pattern endpointPattern = Pattern.compile("^https://login.microsoftonline.com/(.*)/oauth2/v2.0/token$");
                Matcher tenantMatcher = endpointPattern.matcher(this.tokenEndpoint);
                if (tenantMatcher.matches()) {
                    return tenantMatcher.group(1);
                }
                return null;
            }
            return this.tenantId;
        }

        @Override
        public String getOAuth2Scope() {
            return this.scope;
        }

        @Override
        public boolean getRefreshTokenRotation() {
            return this.refreshTokenRotation;
        }
    }
}

