/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.security.AuthCtx;
import java.sql.Driver;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public interface SQLConnectionService {
    public SQLConnectionProvider.SQLConnectionWrapper take(AuthCtx var1, SQLConnectionKey var2) throws Exception;

    public static class SQLConnectionKey {
        public final String authCtxIdentifier;
        public final String jdbcUrl;
        public final Properties properties;
        public final String driverClass;
        public final String jarsDirectory;
        public final List<String> fallThroughPackages;
        public final String postConnectStatements;
        public final String jobOnlyPostConnectStatements;
        public final SQLConnectionProvider.SQLConnectionData sqlConnectionData;
        public final String displayableJdbcUrl;
        public final Driver driver;
        public final String debugId;
        public final boolean verboseRollback;

        public SQLConnectionKey(AuthCtx authCtx, SQLConnectionProvider.JdbcConnectionData jdbcConnectionData, SQLConnectionProvider.AbstractSQLConnectionData sqlConnectionData, String driverClass, Driver driver, String debugId, boolean verboseRollback) {
            this.authCtxIdentifier = authCtx.getIdentifier();
            this.jdbcUrl = jdbcConnectionData.getJdbcUrl();
            this.displayableJdbcUrl = jdbcConnectionData.getDisplayableJdbcUrl();
            this.properties = jdbcConnectionData.getProperties();
            this.driverClass = driverClass;
            this.sqlConnectionData = sqlConnectionData;
            this.jarsDirectory = sqlConnectionData.getJarsDirectory();
            this.fallThroughPackages = sqlConnectionData.getJarsFallThroughPackages();
            this.postConnectStatements = sqlConnectionData.postConnectStatements;
            this.jobOnlyPostConnectStatements = sqlConnectionData.jobOnlyPostConnectStatements;
            this.driver = driver;
            this.debugId = debugId;
            this.verboseRollback = verboseRollback;
        }

        public AbstractSQLConnection.ConnectionPoolSettings getConnectionPoolSettings() {
            return this.sqlConnectionData.getConnection().getParams().connectionPoolSettings;
        }

        public String toString() {
            return "SQLConnectionKey{authCtxIdentifier='" + this.authCtxIdentifier + "', displayableJdbcUrl='" + this.displayableJdbcUrl + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SQLConnectionKey that = (SQLConnectionKey)o;
            return Objects.equals(this.authCtxIdentifier, that.authCtxIdentifier) && Objects.equals(this.jdbcUrl, that.jdbcUrl) && Objects.equals(this.properties, that.properties) && Objects.equals(this.driverClass, that.driverClass) && Objects.equals(this.jarsDirectory, that.jarsDirectory) && Objects.equals(this.fallThroughPackages, that.fallThroughPackages) && Objects.equals(this.postConnectStatements, that.postConnectStatements) && Objects.equals(this.jobOnlyPostConnectStatements, that.jobOnlyPostConnectStatements);
        }

        public int hashCode() {
            return Objects.hash(this.authCtxIdentifier, this.jdbcUrl, this.properties, this.driverClass, this.jarsDirectory, this.fallThroughPackages, this.postConnectStatements, this.jobOnlyPostConnectStatements);
        }
    }
}

