/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPackageSystems;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.code.PythonCodeEnvUtils;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public abstract class BaseDockerFilePreparer {
    public static final String WORKDIR = "/opt/dataiku";
    protected final CodeEnvModel.AbstractEnvDesc envDesc;
    protected final GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings;
    protected final CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> specData;
    protected final CodeEnvModel.EnvLang envLang;
    protected final String envName;
    protected final String envVersion;
    protected final String envDir;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.containers.dockerfilepreparer");

    public final String getCondaPackagesFile() {
        return this.envDir + "/conda.packages.txt";
    }

    public final String getPipPackagesFile() {
        return this.envDir + "/pip.packages.txt";
    }

    public final String getRPackagesFile() {
        return this.envDir + "/R.packages.txt";
    }

    public final String getResourcesInitScriptFile() {
        return this.envDir + "/resources_init.py";
    }

    public final String getResourcesEnvJsonFile() {
        return this.envDir + "/resources_env.json";
    }

    public final String getResourcesModelMetaJsonFile() {
        return this.envDir + "/models_meta.json";
    }

    public final String getResourcesDir() {
        return this.envDir + "/resources";
    }

    public BaseDockerFilePreparer(CodeEnvModel.AbstractEnvDesc envDesc, GeneralSettingsDAO.AbstractCodeEnvExtraSettings envSettings, CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> specData, String envName, String envVersion, String envDir) {
        this.envDesc = (CodeEnvModel.AbstractEnvDesc)Preconditions.checkNotNull((Object)envDesc);
        this.envSettings = envSettings;
        this.specData = specData;
        this.envName = envName;
        this.envVersion = envVersion;
        this.envDir = envDir;
        if (envDesc instanceof CodeEnvModel.PythonEnvDesc) {
            this.envLang = CodeEnvModel.EnvLang.PYTHON;
        } else if (envDesc instanceof CodeEnvModel.REnvDesc) {
            this.envLang = CodeEnvModel.EnvLang.R;
        } else {
            throw new Error("unreachable");
        }
    }

    private void copyResourcesEnvJsonFile(StringBuilder build, File buildDir) {
        File resourcesEnvJsonFile = DKUFileUtils.getWithin((File)buildDir, (String[])new String[]{this.getResourcesEnvJsonFile()});
        if (resourcesEnvJsonFile.exists()) {
            build.append("COPY ").append(this.getResourcesEnvJsonFile()).append(" /opt/dataiku/" + this.getResourcesEnvJsonFile()).append("\n");
        }
    }

    private void copyCodeEnvRefJsonFile(StringBuilder build, File buildDir) throws IOException {
        CodeEnvModel.EnvFullRef envRef = new CodeEnvModel.EnvFullRef(this.envLang, this.envName, this.envVersion);
        String srcFile = "dku-codeenv-ref." + this.envName + ".json";
        File envRefFile = new File(buildDir, srcFile);
        JSON.prettyToFile((Object)envRef, (File)envRefFile);
        build.append("COPY ").append(srcFile).append(" ").append(this.envDir).append("/").append("dku-codeenv-ref.json").append("\n");
    }

    private void applyPysparkAddition(StringBuilder build, File buildDir) throws IOException {
        build.append("# Hook pyspark if it exists\n");
        String pysparkAdditionFile = "dku-pyspark-addition.py";
        String pysparkAdditionScriptFile = "dku-pyspark-addition.sh";
        String pysparkAddition = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "env-image", "pyspark_init_addition.py"}));
        String pysparkAdditionScript = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "env-image", "pyspark_init_addition.sh"}));
        pysparkAdditionScript = pysparkAdditionScript.replace("__CODE_ENV_LOCATION__", this.envDir);
        DKUFileUtils.writeFileUTF8((File)new File(buildDir, "dku-pyspark-addition.py"), (String)pysparkAddition);
        DKUFileUtils.writeFileUTF8((File)new File(buildDir, "dku-pyspark-addition.sh"), (String)pysparkAdditionScript);
        build.append("COPY ").append("dku-pyspark-addition.py").append(" ").append(this.envDir).append("/").append("dku-pyspark-addition.py").append("\n");
        build.append("COPY ").append("dku-pyspark-addition.sh").append(" ").append(this.envDir).append("/").append("dku-pyspark-addition.sh").append("\n");
        build.append("RUN sh ").append(this.envDir).append("/").append("dku-pyspark-addition.sh").append("\n");
        build.append("\n");
    }

    protected abstract VirtualEnvParams getVirtualEnvParams();

    protected abstract String getPythonBasePackageDir();

    protected String getRScriptRootDir() {
        return "build";
    }

    public String preparePythonDockerFileFragment(File buildDir) throws IOException {
        CodeEnvModel.PythonEnvDesc envDesc = (CodeEnvModel.PythonEnvDesc)this.envDesc;
        Preconditions.checkArgument((envDesc.pythonInterpreter != StandardPythonInterpreter.CUSTOM ? 1 : 0) != 0, (Object)"Building Docker image of custom Python interpreter is not supported");
        StringBuilder build = new StringBuilder();
        StringBuilder packages = new StringBuilder();
        if (envDesc.containerCacheBustingLocation == CodeEnvModel.ContainerCacheBustingLocation.BEGINNING) {
            build.append("ENV DKU_IMAGE_BUILD_TIMESTAMP=" + System.currentTimeMillis() + "\n\n");
        }
        this.applyAtStartContainerHooks(build, buildDir);
        this.applyCustomAtStartContainerHooks(build);
        if (envDesc.containerCacheBustingLocation == CodeEnvModel.ContainerCacheBustingLocation.AFTER_START_DOCKERFILE) {
            build.append("ENV DKU_IMAGE_BUILD_TIMESTAMP=" + System.currentTimeMillis() + "\n\n");
        }
        if (envDesc.conda) {
            build.append("# Conda install\n");
            String condaInstall = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "env-image", "Miniconda.Dockerfile"}));
            build.append('\n').append(condaInstall).append('\n');
            build.append("RUN /opt/conda/bin/conda create --prefix ").append(WORKDIR).append("/").append(this.envDir).append(" -y python=").append(StandardPythonInterpreter.getPythonVersion(envDesc.pythonInterpreter)).append("\n");
            this.generateBeforePackagesContainerHooks(build);
            this.generateCustomBeforePackagesContainerHooks(build);
            build.append("# Conda packages\n");
            if (this.specData.condaEnvSpec != null) {
                packages.append(this.specData.condaEnvSpec).append('\n');
            }
            packages.append(CodeEnvPackageSystems.CONDA_PYTHON.getMandatoryPackageList(envDesc)).append('\n');
            DKUFileUtils.writeFileUTF8((File)new File(buildDir, this.getCondaPackagesFile()), (String)packages.toString(), (boolean)true);
            build.append("COPY ").append(this.getCondaPackagesFile()).append(" ").append(this.envDir).append("/\n");
            build.append("RUN [\"");
            List<String> condaInstallCommand = CodeEnvPackageSystems.CONDA_PYTHON.getCondaInstallCommand("/opt/dataiku/" + this.envDir, null, this.envSettings.condaInstallExtraOptions, this.getCondaPackagesFile());
            condaInstallCommand.set(0, "/opt/conda/bin/conda");
            Joiner.on((String)"\", \"").appendTo(build, condaInstallCommand);
            build.append("\"]\n");
            build.append("RUN /opt/conda/bin/conda clean --all --yes\n");
            this.generateAfterCondaPackagesContainerHooks(build);
            this.generateCustomAfterCondaPackagesContainerHooks(build);
            packages = new StringBuilder();
        } else {
            build.append("# Virtualenv initialization\n");
            build.append("RUN [\"");
            VirtualEnvParams virtualEnvParams = this.getVirtualEnvParams();
            Joiner.on((String)"\", \"").appendTo(build, CodeEnvPackageSystems.PIP.getVirtualenvCreationCommand(this.envDir, envDesc, this.envSettings.virtualenvCreateExtraOptions, virtualEnvParams.pythonExec, virtualEnvParams.createVirtualEnvScript, true));
            build.append("\"]\n");
            if (CodeEnvPackageSystems.shouldUseUVInsteadOfPip()) {
                build.append("RUN /opt/dataiku/" + this.envDir + "/bin/python -m pip install --no-cache-dir uv\n");
            }
            this.generateBeforePackagesContainerHooks(build);
            this.generateCustomBeforePackagesContainerHooks(build);
        }
        build.append("# Pip packages\n");
        packages.append(Objects.toString(this.specData.packageList, "")).append('\n');
        packages.append(CodeEnvPackageSystems.PIP.getMandatoryPackageList(envDesc)).append('\n');
        DKUFileUtils.writeFileUTF8((File)new File(buildDir, this.getPipPackagesFile()), (String)packages.toString(), (boolean)true);
        build.append("COPY ").append(this.getPipPackagesFile()).append(" ").append(this.envDir).append("/\n");
        build.append("RUN [\"");
        List<String> pipInstallCommand = CodeEnvPackageSystems.PIP.getPipInstallCommand(this.envDir, this.envSettings.pipInstallExtraOptions, false, this.shouldDisablePipCache(), this.getPipPackagesFile());
        pipInstallCommand.set(0, "/opt/dataiku/" + this.envDir + "/bin/python");
        Joiner.on((String)"\", \"").appendTo(build, pipInstallCommand);
        build.append("\"]\n");
        HashMap<String, String> cudaEnvVars = new HashMap<String, String>();
        PythonCodeEnvPackagesUtils.updateEnvWithPipInstalledCUDA(cudaEnvVars, envDesc.pythonInterpreter, this.specData.packageList, "/opt/dataiku/" + this.envDir);
        cudaEnvVars.forEach((key, value) -> build.append("ENV " + key + "=\"" + value + "\"\n"));
        this.applyPysparkAddition(build, buildDir);
        this.copyCodeEnvRefJsonFile(build, buildDir);
        if (envDesc.containerCacheBustingLocation == CodeEnvModel.ContainerCacheBustingLocation.AFTER_PACKAGES) {
            build.append("ENV DKU_IMAGE_BUILD_TIMESTAMP=" + System.currentTimeMillis() + "\n\n");
        }
        this.generateAfterPackagesContainerHooks(build);
        this.generateCustomAfterPackagesContainerHooks(build);
        if (envDesc.containerCacheBustingLocation == CodeEnvModel.ContainerCacheBustingLocation.AFTER_AFTER_PACKAGES_DOCKERFILE) {
            build.append("ENV DKU_IMAGE_BUILD_TIMESTAMP=" + System.currentTimeMillis() + "\n\n");
        }
        build.append("# Code environment resources\n");
        build.append("RUN mkdir -p /opt/dataiku/" + this.getResourcesDir() + "\n");
        File resourcesEnvJsonFile = DKUFileUtils.getWithin((File)buildDir, (String[])new String[]{this.getResourcesEnvJsonFile()});
        if (envDesc.dockerImageResources == CodeEnvModel.PythonEnvDesc.DockerImageResourcesOptions.INIT) {
            if (!this.specData.resourcesInitScript.isEmpty()) {
                if (PythonCodeEnvUtils.isAllowedToRunResourcesInitScript()) {
                    DKUFileUtils.writeFileUTF8((File)DKUFileUtils.getWithin((File)buildDir, (String[])new String[]{this.getResourcesInitScriptFile()}), (String)this.specData.resourcesInitScript, (boolean)true);
                    build.append("COPY ").append(this.getResourcesInitScriptFile()).append(" ").append(this.envDir).append("/\n");
                    if (this.shouldRunInitScriptWhenBuildingImage(envDesc)) {
                        build.append("RUN ");
                        ArrayList<CallSite> resourcesInitCommand = new ArrayList<CallSite>();
                        resourcesInitCommand.add((CallSite)((Object)("DKU_CODE_ENV_RESOURCES_PATH=/opt/dataiku/" + this.getResourcesDir())));
                        resourcesInitCommand.add((CallSite)((Object)("DKU_CODE_ENV_RESOURCES_ENV_VARS_PATH=/opt/dataiku/" + this.getResourcesEnvJsonFile())));
                        resourcesInitCommand.add((CallSite)((Object)("DKU_CODE_ENV_RESOURCES_MODELS_META_PATH=/opt/dataiku/" + this.getResourcesModelMetaJsonFile())));
                        resourcesInitCommand.add((CallSite)((Object)("PYTHONPATH=" + this.getPythonBasePackageDir())));
                        resourcesInitCommand.add((CallSite)((Object)("/opt/dataiku/" + this.envDir + "/bin/python")));
                        resourcesInitCommand.add((CallSite)((Object)("/opt/dataiku/" + this.getResourcesInitScriptFile())));
                        Joiner.on((String)" ").appendTo(build, resourcesInitCommand);
                        build.append("\n");
                    } else {
                        logger.debug((Object)"Not running resource initialisation script when building the docker image.");
                    }
                } else {
                    build.append("# Code environment resources have been disabled, skipping init script\n");
                    logger.warn((Object)"Code environment resources have been disabled but init script is not empty");
                }
            } else {
                logger.info((Object)"Resources initialization script is empty");
            }
        } else if (envDesc.dockerImageResources == CodeEnvModel.PythonEnvDesc.DockerImageResourcesOptions.COPY) {
            File resourcesDirectory = DKUFileUtils.getWithin((File)buildDir, (String[])new String[]{this.getResourcesDir()});
            if (resourcesDirectory.exists()) {
                build.append("COPY ").append(this.getResourcesDir()).append(" /opt/dataiku/" + this.getResourcesDir()).append("\n");
            }
            this.copyResourcesEnvJsonFile(build, buildDir);
        } else if (envDesc.dockerImageResources == CodeEnvModel.PythonEnvDesc.DockerImageResourcesOptions.NONE) {
            this.copyResourcesEnvJsonFile(build, buildDir);
        }
        build.append("RUN chown -R dataiku:dataiku /opt/dataiku/" + this.getResourcesDir() + "\n");
        build.append("ENV DKU_CODE_ENV_RESOURCES_PATH=/opt/dataiku/" + this.getResourcesDir() + "\n");
        if (resourcesEnvJsonFile.exists()) {
            CodeEnvModel.CodeEnvResourcesEnvVariables resourcesEnvVariables = (CodeEnvModel.CodeEnvResourcesEnvVariables)JSON.parseFile((File)resourcesEnvJsonFile, CodeEnvModel.CodeEnvResourcesEnvVariables.class);
            resourcesEnvVariables.resolveUnsafe("/opt/dataiku/" + this.getResourcesDir()).forEach((envVariableName, envVariableValue) -> build.append("ENV ").append((String)envVariableName).append("=").append((String)envVariableValue).append("\n"));
        }
        this.generateAtEndContainerHooks(build);
        this.generateCustomAtEndContainerHooks(build);
        if (envDesc.containerCacheBustingLocation == CodeEnvModel.ContainerCacheBustingLocation.END) {
            build.append("ENV DKU_IMAGE_BUILD_TIMESTAMP=" + System.currentTimeMillis() + "\n\n");
        }
        return build.toString();
    }

    protected boolean shouldDisablePipCache() {
        return false;
    }

    protected boolean shouldRunInitScriptWhenBuildingImage(CodeEnvModel.PythonEnvDesc envDesc) {
        return true;
    }

    public String prepareRDockerFileFragment(File buildDir) throws IOException {
        CodeEnvModel.REnvDesc envDesc = (CodeEnvModel.REnvDesc)this.envDesc;
        StringBuilder build = new StringBuilder();
        StringBuilder packages = new StringBuilder();
        if (envDesc.containerCacheBustingLocation == CodeEnvModel.ContainerCacheBustingLocation.BEGINNING) {
            build.append("ENV DKU_IMAGE_BUILD_TIMESTAMP=" + System.currentTimeMillis() + "\n\n");
        }
        this.applyCustomAtStartContainerHooks(build);
        if (envDesc.containerCacheBustingLocation == CodeEnvModel.ContainerCacheBustingLocation.AFTER_START_DOCKERFILE) {
            build.append("ENV DKU_IMAGE_BUILD_TIMESTAMP=" + System.currentTimeMillis() + "\n\n");
        }
        if (envDesc.conda) {
            build.append("# Conda install\n");
            String condaInstall = DKUFileUtils.readFileToStringUTF8((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "env-image", "Miniconda.Dockerfile"}));
            build.append('\n').append(condaInstall).append('\n');
            build.append("RUN /opt/conda/bin/conda create --prefix ").append(WORKDIR).append("/").append(this.envDir).append(" -y --channel r r-base").append("\n");
            this.generateCustomBeforePackagesContainerHooks(build);
            build.append("# Conda packages\n");
            if (this.specData.condaEnvSpec != null) {
                packages.append(this.specData.condaEnvSpec).append('\n');
            }
            packages.append(CodeEnvPackageSystems.CONDA_R.getMandatoryPackageList(envDesc)).append('\n');
            DKUFileUtils.writeFileUTF8((File)new File(buildDir, this.getCondaPackagesFile()), (String)packages.toString(), (boolean)true);
            build.append("COPY ").append(this.getCondaPackagesFile()).append(" ").append(this.envDir).append("/\n");
            build.append("RUN [\"");
            List<String> condaInstallCommand = CodeEnvPackageSystems.CONDA_R.getCondaInstallCommand("/opt/dataiku/" + this.envDir, "r", this.envSettings.condaInstallExtraOptions, this.getCondaPackagesFile());
            condaInstallCommand.set(0, "/opt/conda/bin/conda");
            Joiner.on((String)"\", \"").appendTo(build, condaInstallCommand);
            build.append("\"]\n");
            build.append("RUN /opt/conda/bin/conda clean --all --yes\n");
            build.append("ENV R_LIBS_USER=").append(WORKDIR).append("/").append(this.envDir).append("/lib/R/library").append(":$R_LIBS_USER").append("\n");
            this.generateCustomAfterCondaPackagesContainerHooks(build);
            packages = new StringBuilder();
        } else {
            build.append("# R env install\n");
            build.append("RUN mkdir -p ").append(WORKDIR).append("/").append(this.envDir).append("/R.lib ").append(WORKDIR).append("/").append(this.envDir).append("/bin ").append(WORKDIR).append("/").append(this.envDir).append("/lib/R/library").append('\n');
            FileUtils.copyFile((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "env-image", "R-code-env-wrapper.sh"}), (File)new File(buildDir, "R-code-env-wrapper.sh"));
            FileUtils.copyFile((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", "env-image", "Rscript-code-env-wrapper.sh"}), (File)new File(buildDir, "Rscript-code-env-wrapper.sh"));
            build.append("COPY ").append("R-code-env-wrapper.sh ").append(WORKDIR).append("/").append(this.envDir).append("/bin/\n");
            build.append("COPY ").append("Rscript-code-env-wrapper.sh ").append(WORKDIR).append("/").append(this.envDir).append("/bin/\n");
            build.append("RUN [\"/bin/sh\", \"-c\", \"cd ").append(WORKDIR).append("/").append(this.envDir).append("/bin/").append(" && ln -s R-code-env-wrapper.sh R && ln -s Rscript-code-env-wrapper.sh Rscript").append(" && chmod a+x *\"]\n");
            this.generateCustomBeforePackagesContainerHooks(build);
        }
        build.append("# R packages\n");
        packages.append(Objects.toString(this.specData.packageList, "")).append('\n');
        packages.append(CodeEnvPackageSystems.R.getMandatoryPackageList(envDesc)).append('\n');
        DKUFileUtils.writeFileUTF8((File)new File(buildDir, this.getRPackagesFile()), (String)packages.toString(), (boolean)true);
        build.append("COPY ").append(this.getRPackagesFile()).append(" ").append(this.envDir).append("/\n");
        build.append(String.format("RUN [\"%s/install-packages-if-needed.sh\", \"%s\", \"%s\", \"%s\", \"%s\"]\n", this.getRScriptRootDir(), this.envDir, envDesc.conda, this.getRPackagesFile(), this.envSettings.cranMirrorURL));
        this.copyCodeEnvRefJsonFile(build, buildDir);
        if (envDesc.containerCacheBustingLocation == CodeEnvModel.ContainerCacheBustingLocation.AFTER_PACKAGES) {
            build.append("ENV DKU_IMAGE_BUILD_TIMESTAMP=" + System.currentTimeMillis() + "\n\n");
        }
        this.generateCustomAfterPackagesContainerHooks(build);
        if (envDesc.containerCacheBustingLocation == CodeEnvModel.ContainerCacheBustingLocation.AFTER_AFTER_PACKAGES_DOCKERFILE) {
            build.append("ENV DKU_IMAGE_BUILD_TIMESTAMP=" + System.currentTimeMillis() + "\n\n");
        }
        this.generateCustomAtEndContainerHooks(build);
        if (envDesc.containerCacheBustingLocation == CodeEnvModel.ContainerCacheBustingLocation.END) {
            build.append("ENV DKU_IMAGE_BUILD_TIMESTAMP=" + System.currentTimeMillis() + "\n\n");
        }
        return build.toString();
    }

    public String prepareDockerFileFragment(File buildDir) throws IOException {
        if (this.envLang.equals((Object)CodeEnvModel.EnvLang.PYTHON)) {
            return this.preparePythonDockerFileFragment(buildDir);
        }
        if (this.envLang.equals((Object)CodeEnvModel.EnvLang.R)) {
            return this.prepareRDockerFileFragment(buildDir);
        }
        throw new Error("Unreachable");
    }

    protected void generateBeforePackagesContainerHooks(StringBuilder build) {
    }

    protected void generateAfterCondaPackagesContainerHooks(StringBuilder build) {
    }

    protected void generateAfterPackagesContainerHooks(StringBuilder build) {
    }

    protected String getCodeEnvPath() {
        return "/opt/dataiku/" + this.envDir;
    }

    protected void generateCodeEnvPathDecl(StringBuilder build) {
        build.append("ENV CODE_ENV_PATH=\"" + this.getCodeEnvPath() + "\"\n");
    }

    protected void generateAtEndContainerHooks(StringBuilder build) {
        CodeEnvModel.PythonEnvDesc pyEnvDesc = (CodeEnvModel.PythonEnvDesc)this.envDesc;
        String codeEnvPath = this.getCodeEnvPath();
        for (CodeEnvModel.PredefinedContainerHook hook : pyEnvDesc.predefinedContainerHooks) {
            if (hook.type == null) continue;
            switch (hook.type) {
                case SYSTEM_LEVEL_CUDA_112_CUDNN_811: {
                    this.generateCUDARuntimeBlurb(build);
                    break;
                }
                case SYSTEM_LEVEL_CUDA_122_CUDNN_897: {
                    this.torchPathWorkaround(build, codeEnvPath);
                    this.generateCUDARuntimeBlurb(build);
                    break;
                }
                case CUDA_SUPPORT_FOR_TORCH2_WITH_PYPI_NVIDIA_PACKAGES: {
                    this.torchPathWorkaround(build, codeEnvPath);
                    this.generateCUDARuntimeBlurb(build);
                    break;
                }
                case BASIC_GPU_ENABLING: {
                    this.generateCUDARuntimeBlurb(build);
                }
            }
        }
    }

    protected void torchPathWorkaround(StringBuilder build, String codeEnvPath) {
        build.append("# Workaround the torch RPATH packaging bug\n");
        build.append("RUN if test -d " + codeEnvPath + "/lib/python3.9/site-packages/cusparselt; then ln -sf " + codeEnvPath + "/lib/python3.9/site-packages/cusparselt " + codeEnvPath + "/lib64/python3.9/site-packages/cusparselt;fi\n");
        build.append("RUN if test -d " + codeEnvPath + "/lib/python3.9/site-packages/nvidia; then ln -sf " + codeEnvPath + "/lib/python3.9/site-packages/nvidia " + codeEnvPath + "/lib64/python3.9/site-packages/nvidia;fi\n");
        build.append("RUN if test -d " + codeEnvPath + "/lib/python3.8/site-packages/nvidia; then ln -sf " + codeEnvPath + "/lib/python3.8/site-packages/nvidia " + codeEnvPath + "/lib64/python3.8/site-packages/nvidia;fi\n");
    }

    protected void generateCUDARuntimeBlurb(StringBuilder build) {
        build.append("# On GKE, TF needs explicit directions on where to find cuda runtime\n");
        build.append("ENV PATH=/usr/local/cuda/bin:${PATH} \\\n");
        build.append("    LD_LIBRARY_PATH=${LD_LIBRARY_PATH:+$LD_LIBRARY_PATH:}/usr/local/cuda/lib64\n");
        build.append("\n");
        build.append("# GKE containers expose the CUDA driver at this location\n");
        build.append("# https://cloud.google.com/kubernetes-engine/docs/how-to/gpus#cuda\n");
        build.append("ENV PATH=/usr/local/nvidia/bin:$PATH \\\n");
        build.append("    LD_LIBRARY_PATH=${LD_LIBRARY_PATH:+$LD_LIBRARY_PATH:}/usr/local/nvidia/lib64\n");
        build.append("\n");
        build.append("# EKS requires this in order to expose the CUDA driver in the container\n");
        build.append("# https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-gpu.html#gpu-considerations\n");
        build.append("ENV NVIDIA_DRIVER_CAPABILITIES=utility,compute\n");
        build.append("# On AKS LD_LIBRARY_PATH does not contain the path to libcuda.so which is necessary for triton (quantization) to work.\n");
        build.append("ENV LD_LIBRARY_PATH=${LD_LIBRARY_PATH:+$LD_LIBRARY_PATH:}/usr/lib64\n");
    }

    protected void applyAtStartContainerHooks(StringBuilder build, File buildDir) throws IOException {
        CodeEnvModel.PythonEnvDesc pyEnvDesc = (CodeEnvModel.PythonEnvDesc)this.envDesc;
        for (CodeEnvModel.PredefinedContainerHook hook : pyEnvDesc.predefinedContainerHooks) {
            if (hook.type == null) continue;
            switch (hook.type) {
                case SYSTEM_LEVEL_CUDA_112_CUDNN_811: {
                    build.append("RUN dnf install -y dnf-plugins-core && dnf config-manager --add-repo https://developer.download.nvidia.com/compute/cuda/repos/rhel8/x86_64/cuda-rhel8.repo \\\n");
                    build.append("&& yum install -y cuda-libraries-11-2 cuda-compat-11-2 libnccl cuda-nvtx-11-2 libcudnn8-8.1.1.33-1.cuda11.2 cuda-nvcc-11-2.x86_64 \\\n");
                    build.append("&& ln -sf cuda-11.2 /usr/local/cuda \\\n");
                    build.append("&& yum clean all\n\n");
                    break;
                }
                case SYSTEM_LEVEL_CUDA_122_CUDNN_897: {
                    build.append("RUN dnf install -y dnf-plugins-core && dnf config-manager --add-repo https://developer.download.nvidia.com/compute/cuda/repos/rhel8/x86_64/cuda-rhel8.repo \\\n");
                    build.append("&& sed /libcudnn8-.*cuda11/d -i /etc/dnf/plugins/versionlock.list || true \\\n");
                    build.append("&& yum install -y cuda-libraries-12-2 cuda-compat-12-2 libnccl cuda-nvtx-12-2 libcudnn8-8.9.7.29-1.cuda12.2 cuda-nvcc-12-2.x86_64 \\\n");
                    build.append("&& ln -sf cuda-12.2 /usr/local/cuda \\\n");
                    build.append("&& yum clean all\n\n");
                    break;
                }
                case PYTHON36_SUPPORT: {
                    this.generatePythonSupportBlurb(build, buildDir, "python3.6");
                    break;
                }
                case PYTHON37_SUPPORT: {
                    this.generatePythonSupportBlurb(build, buildDir, "python3.7");
                    break;
                }
                case PYTHON38_SUPPORT: {
                    this.generatePythonSupportBlurb(build, buildDir, "python3.8");
                    break;
                }
                case AGENT_TOOL_MCP_SERVERS_SUPPORT: {
                    build.append("RUN dnf module install -y nodejs:22 \\\n");
                    build.append("&& yum clean all \\\n");
                    build.append("&& pip install --no-cache-dir uv==0.8.5\n\n");
                }
                case TESSERACT_OCR_SUPPORT: {
                    build.append("RUN dnf install -y tesseract \\\n");
                    build.append("&& mkdir -p /usr/share/tesseract/tessdata \\\n");
                    build.append("&& curl -L -o /usr/share/tesseract/tessdata/osd.traineddata https://github.com/tesseract-ocr/tessdata/raw/4.1.0/osd.traineddata \\\n");
                    build.append("&& chmod 0644 /usr/share/tesseract/tessdata/osd.traineddata \n\n");
                }
            }
        }
    }

    protected void applyCustomAtStartContainerHooks(StringBuilder build) {
        if (StringUtils.isNotBlank((String)this.envDesc.dockerfileAtStart)) {
            build.append("# Env-specific prepend Dockerfile fragment\n");
            build.append(this.envDesc.dockerfileAtStart);
            build.append("\n");
            build.append("# End of env-specific prepend Dockerfile fragment\n");
            build.append("\n\n");
        }
    }

    protected void generateCustomBeforePackagesContainerHooks(StringBuilder build) {
        if (StringUtils.isNotBlank((String)this.envDesc.dockerfileBeforePackages)) {
            build.append("# Env-specific before-packages Dockerfile fragment\n");
            this.generateCodeEnvPathDecl(build);
            build.append(this.envDesc.dockerfileBeforePackages);
            build.append("\n");
            build.append("# End of env-specific before-packages Dockerfile fragment\n");
            build.append("\n\n");
        }
    }

    protected void generateCustomAfterCondaPackagesContainerHooks(StringBuilder build) {
        if (StringUtils.isNotBlank((String)this.envDesc.dockerfileAfterCondaPackages)) {
            build.append("# Env-specific after-conda-packages Dockerfile fragment\n");
            this.generateCodeEnvPathDecl(build);
            build.append(this.envDesc.dockerfileAfterCondaPackages);
            build.append("\n");
            build.append("# End of env-specific after-conda-packages Dockerfile fragment\n");
            build.append("\n\n");
        }
    }

    protected void generateCustomAfterPackagesContainerHooks(StringBuilder build) {
        if (StringUtils.isNotBlank((String)this.envDesc.dockerfileAfterPackages)) {
            build.append("# Env-specific after-packages Dockerfile fragment\n");
            this.generateCodeEnvPathDecl(build);
            build.append(this.envDesc.dockerfileAfterPackages);
            build.append("\n");
            build.append("# End of env-specific after-packages Dockerfile fragment\n");
            build.append("\n\n");
        }
    }

    protected void generateCustomAtEndContainerHooks(StringBuilder build) {
        if (StringUtils.isNotBlank((String)this.envDesc.dockerfileAtEnd)) {
            build.append("# Env-specific at-end Dockerfile fragment\n");
            this.generateCodeEnvPathDecl(build);
            build.append(this.envDesc.dockerfileAtEnd);
            build.append("\n");
            build.append("# End of env-specific at-end Dockerfile fragment\n");
            build.append("\n\n");
        }
    }

    private void generatePythonSupportBlurb(StringBuilder builder, File buildDir, String pythonCommand) throws IOException {
        String pythonInstallVersion = pythonCommand.replaceAll("\\.", "");
        String pythonInstallScriptName = "build-" + pythonInstallVersion + ".sh";
        FileUtils.copyFile((File)ApplicationConfigurator.getResourceFile((String[])new String[]{"container-exec", pythonInstallScriptName}), (File)new File(buildDir, pythonInstallScriptName));
        builder.append("RUN mkdir -p ").append(WORKDIR).append("/build/\n");
        builder.append("COPY ").append(pythonInstallScriptName);
        if (pythonInstallVersion.equals("python36")) {
            FileUtils.copyFile((File)ApplicationConfigurator.getInstallFile((String[])new String[]{"scripts", "virtualenv-20.21.pyz"}), (File)new File(buildDir, "virtualenv-20.21.pyz"));
            builder.append(" virtualenv-20.21.pyz");
        } else if (pythonInstallVersion.equals("python37")) {
            FileUtils.copyFile((File)ApplicationConfigurator.getInstallFile((String[])new String[]{"scripts", "virtualenv-20.26.pyz"}), (File)new File(buildDir, "virtualenv-20.26.pyz"));
            builder.append(" virtualenv-20.26.pyz");
        }
        builder.append(" ").append(WORKDIR).append("/build/\n");
        builder.append("RUN if ! command -v ").append(pythonCommand).append(" >/dev/null 2>&1; then \\\n");
        if (pythonInstallVersion.equals("python36") || pythonInstallVersion.equals("python38")) {
            builder.append("        . /etc/os-release && case \"$VERSION_ID\" in \\\n");
            builder.append("            8*) dnf -y install ").append(pythonInstallVersion).append("-devel && dnf clean all;; \\\n");
            builder.append("            9*) ").append(this.getCustomPythonInstallCommand(pythonInstallScriptName)).append(";; \\\n");
            builder.append("            *) echo 2>&1 'OS version not supported'; exit 1;; \\\n");
            builder.append("        esac; \\\n");
        } else if (pythonInstallVersion.equals("python37")) {
            builder.append("        ").append(this.getCustomPythonInstallCommand(pythonInstallScriptName)).append("; \\\n");
        }
        builder.append("    fi\n");
    }

    private String getCustomPythonInstallCommand(String pythonInstallScriptName) {
        return "/opt/dataiku/build/" + pythonInstallScriptName + " >/tmp/build-python.log && rm -f /tmp/build-python.log";
    }

    protected class VirtualEnvParams {
        public String createVirtualEnvScript;
        public String pythonExec;

        public VirtualEnvParams(String createVirtualEnvScript, String pythonExec) {
            this.createVirtualEnvScript = createVirtualEnvScript;
            this.pythonExec = pythonExec;
        }
    }
}

