/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.JettyUtils;
import com.dataiku.dip.server.WebPathConfiguration;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletHolder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Connector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.SecureRequestCustomizer;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ServerConnector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.SslConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ssl.SslContextFactory;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.util.SystemUserAgent;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import java.io.File;
import java.util.function.Supplier;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class JobKernelUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.job.kernel.utils");

    public static Server createServerWithServlet(int port, Supplier<HttpServlet> ksSupplier, String servletPath) {
        ServerConnector connector;
        Server server = new Server();
        if (EncryptedRPC.enabled()) {
            logger.info((Object)"Setup SSL for servlet");
            httpConfig = JettyUtils.createHttpConfiguration();
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(DKUApp.getParams().getBoolParam("sni.enabled", true)));
            HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
            SslContextFactory.Server sslContextFactory = EncryptedRPC.getSSLContextFactoryServer();
            SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, http11.getProtocol());
            connector = new ServerConnector(server, new ConnectionFactory[]{tls, http11});
        } else {
            httpConfig = JettyUtils.createHttpConfiguration();
            HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
            connector = new ServerConnector(server, new ConnectionFactory[]{http});
        }
        if (port > 0) {
            connector.setPort(port);
        }
        server.setConnectors(new Connector[]{connector});
        connector.setIdleTimeout(-1L);
        ServletContextHandler sch = ServletUtils.createServletContext((int)100000000, (String)"/");
        JettyUtils.addHandlers((Server)server, (ServletContextHandler)sch);
        HttpServlet ks = ksSupplier.get();
        ServletHolder servletHolder = new ServletHolder((Servlet)ks);
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        DispatcherServlet dispatcherServlet = new DispatcherServlet((WebApplicationContext)context);
        context.register(new Class[]{WebPathConfiguration.class});
        sch.addServlet((HttpServlet)dispatcherServlet, "/*");
        ServletUtils.addMultiPartElementConfig((ServletHolder)servletHolder, (File)new File(ApplicationConfigurator.getBaseFolderF(), "tmp/upload-multipart"), (int)1000000);
        sch.addServlet(servletHolder, servletPath);
        return server;
    }

    public static void preloadStuffWithExpensiveInitsAfterServerIsReady() {
        try {
            SystemUserAgent.getOrCreate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logger.debug((Object)"Async preload done");
    }
}

