/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.cde;

import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.hproxy.model.PingResponse;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CDEHeartbeatThread
extends Thread {
    private final int maxFailures;
    private final int delayMS;
    private final TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();
    private static final Logger logger = Logger.getLogger((String)"dku.cde.heartbeat");

    public CDEHeartbeatThread(int maxFailures, int delayMS) {
        this.maxFailures = maxFailures;
        this.delayMS = delayMS;
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        finally {
            this.doClean();
        }
    }

    private void doRun() {
        int failures = 0;
        while (true) {
            try {
                Thread.sleep(this.delayMS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn((Object)"CDE HeartBeat thread was interrupted");
                return;
            }
            try {
                PingResponse resp = (PingResponse)this.apiClient.get("/tintercom/ping", PingResponse.class);
                if (resp.ok) {
                    failures = 0;
                } else {
                    logger.warn((Object)"Unsuccessfully JEK Ping");
                    ++failures;
                }
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to ping JEK", (Throwable)e);
                ++failures;
            }
            if (failures < this.maxFailures) continue;
            logger.error((Object)("JEK Ping was not received for the last " + this.maxFailures + " iterations of " + this.delayMS + "ms, exiting!"));
            Runtime.getRuntime().halt(1);
        }
    }

    private void doClean() {
        this.apiClient.close();
    }
}

