/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class QueryGenerationUtils {
    private static final ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    private static Logger logger = Logger.getLogger((String)"dku.recipes.visual");

    public static SelectQueryBuilderAndSchema prepareInput(SQLUtils.SQLTable table, SQLDialect dialect, Dataset dataset, FilterDesc filter, List<ComputedColumn> computedColumns, PartitioningScheme partitionScheme, List<Partition> partitions) {
        return QueryGenerationUtils.prepareInput(table, null, null, dialect, dataset, filter, computedColumns, partitionScheme, partitions);
    }

    public static SelectQueryBuilderAndSchema prepareInput(SelectQueryBuilder query, String queryAlias, SQLDialect dialect, Dataset dataset, FilterDesc filter, List<ComputedColumn> computedColumns, PartitioningScheme partitionScheme, List<Partition> partitions) {
        return QueryGenerationUtils.prepareInput(null, query, queryAlias, dialect, dataset, filter, computedColumns, partitionScheme, partitions);
    }

    private static SelectQueryBuilderAndSchema prepareInput(SQLUtils.SQLTable table, SelectQueryBuilder query, String queryAlias, SQLDialect dialect, Dataset dataset, FilterDesc filter, List<ComputedColumn> computedColumns, PartitioningScheme partitionScheme, List<Partition> partitions) {
        if (computedColumns == null) {
            computedColumns = new ArrayList<ComputedColumn>();
        }
        if (partitions == null) {
            partitions = new ArrayList<Partition>();
        }
        SelectQueryBuilderAndSchema ret = new SelectQueryBuilderAndSchema();
        ret.selectQueryBuilder = new SelectQueryBuilder();
        ret.dataset = (Dataset)JSON.deepCopy((Object)dataset);
        ret.schema = ret.dataset.getSchema();
        if (query != null) {
            ret.selectQueryBuilder.from(query, queryAlias);
        } else {
            ret.selectQueryBuilder.from(table, null);
        }
        if (!dataset.isManaged()) {
            DatasetHandler.DatasetParams datasetParams = dataset.getParams();
            boolean hasAdjustment = false;
            ArrayList<ExpressionBuilder> colToSelect = new ArrayList<ExpressionBuilder>();
            ArrayList<SchemaColumn> scToSelect = new ArrayList<SchemaColumn>();
            for (SchemaColumn sc : ret.schema.getColumns()) {
                ExpressionBuilder rawCol = ef.col(sc.getName());
                ExpressionBuilder col = ExpressionUtils.getAdjustedColumn(rawCol, sc, datasetParams, false, dialect);
                hasAdjustment |= col != rawCol;
                colToSelect.add(col);
                scToSelect.add(sc);
            }
            if (hasAdjustment) {
                ret.schema = new Schema();
                ret.dataset.setSchema(ret.schema);
                for (int i = 0; i < colToSelect.size(); ++i) {
                    ExpressionBuilder col = (ExpressionBuilder)colToSelect.get(i);
                    SchemaColumn sc = (SchemaColumn)scToSelect.get(i);
                    sc = new SchemaColumn(sc);
                    sc.originalSQLType = null;
                    sc.originalType = null;
                    sc.timestampNoTzAsDate = false;
                    ret.schema.addColumn(sc);
                    ret.selectQueryBuilder.select(col, sc.getName());
                }
                SelectQueryBuilder wrapped = new SelectQueryBuilder();
                wrapped.from(ret.selectQueryBuilder, "dku_adjusted");
                ret.selectQueryBuilder = wrapped;
            }
        }
        QueryGenerationUtils.preFilter(ret.selectQueryBuilder, filter, dialect, ret.dataset, false);
        if (partitionScheme != null && (query != null || table.isTrueTable())) {
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(partitionScheme, ret.schema, ret.dataset.getParams(), partitions, ret.dataset.isManaged(), dialect);
            ret.selectQueryBuilder.where(partitionFilterExpression);
        }
        if (!computedColumns.isEmpty()) {
            SelectQueryBuilder wrapped = new SelectQueryBuilder();
            wrapped.from(ret.selectQueryBuilder, "dku_with_computed");
            QueryGenerationUtils.selectColumnsAndComputedColumns(ret.selectQueryBuilder, computedColumns, dialect, ret.schema, dialect.hasCaseInsensitiveColumns());
            ret.selectQueryBuilder = wrapped;
            for (ComputedColumn computedColumn : computedColumns) {
                ComputedColumnUtils.addToSchema(ret.schema, computedColumn);
            }
        }
        return ret;
    }

    public static SelectQueryBuilder computedColumns(SQLUtils.SQLTable table, List<ComputedColumn> computedCols, SQLDialect dialect, Schema schema) {
        SelectQueryBuilder outerQuery = new SelectQueryBuilder();
        outerQuery.from(table, null);
        QueryGenerationUtils.selectColumnsAndComputedColumns(outerQuery, computedCols != null ? computedCols : new ArrayList<ComputedColumn>(), dialect, schema, null);
        return outerQuery;
    }

    public static SelectQueryBuilder computedColumns(SelectQueryBuilder query, List<ComputedColumn> computedCols, SQLDialect dialect, Schema schema) {
        if (computedCols != null && !computedCols.isEmpty()) {
            SelectQueryBuilder outerQuery = new SelectQueryBuilder();
            outerQuery.from(query, "withoutcomputedcols_query");
            QueryGenerationUtils.selectColumnsAndComputedColumns(outerQuery, computedCols, dialect, schema, null);
            return outerQuery;
        }
        return query;
    }

    public static void selectColumnsAndComputedColumns(SelectQueryBuilder query, List<ComputedColumn> computedCols, SQLDialect dialect, Schema schema, Boolean caseInsensitiveCheck) {
        if (schema == null) {
            throw new IllegalArgumentException("Input schema is empty");
        }
        if (caseInsensitiveCheck != null) {
            HashSet<String> usedNames = new HashSet<String>();
            for (ComputedColumn cc : computedCols) {
                if (QueryGenerationUtils.containsCaseInsensitive(usedNames, cc.name, caseInsensitiveCheck)) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INVALID_COMPUTED_COLUMNS, "Conflict in computed columns. The computed column named \"" + cc.name + "\" already exists.");
                }
                usedNames.add(cc.name);
            }
            for (SchemaColumn c2 : schema.getColumns()) {
                if (QueryGenerationUtils.containsCaseInsensitive(usedNames, c2.getName(), caseInsensitiveCheck)) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INVALID_COMPUTED_COLUMNS, "Conflict between columns and computed column. The computed column named \"" + c2.getName() + "\" already exists.");
                }
                usedNames.add(c2.getName());
            }
        }
        for (SchemaColumn c3 : schema.getColumns()) {
            query.select(ef.col(c3.getName()), c3.getName());
        }
        for (ComputedColumn cc : computedCols) {
            query.select(QueryGenerationUtils.getComputedColumnExpr(cc, dialect, schema), cc.name);
        }
    }

    private static boolean containsCaseInsensitive(Set<String> list, String string, boolean caseInsensitive) {
        if (list == null || list.isEmpty() || string == null) {
            return false;
        }
        if (!caseInsensitive) {
            return list.contains(string);
        }
        for (String element : list) {
            if (!string.equalsIgnoreCase(element)) continue;
            return true;
        }
        return false;
    }

    public static ExpressionBuilder getComputedColumnExpr(ComputedColumn computedColumn, SQLDialect dialect, Schema schema) {
        if (computedColumn.mode == ComputedColumn.Mode.SQL) {
            return ef.expr(computedColumn.expr);
        }
        if (computedColumn.mode == ComputedColumn.Mode.GREL) {
            Expression expression = new Expression(computedColumn.expr, schema);
            expression.setVariablesContext(computedColumn.exprVariablesContext);
            GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping(dialect), schema);
            try {
                GrelTranslator.TranslationResult<ExpressionBuilder> res = translator.translateToQuery(expression, true);
                return (ExpressionBuilder)res.result;
            }
            catch (GrelTranslator.NonTranslatableOperatorException e) {
                throw new IllegalArgumentException("Operator cannot be translated to SQL", e);
            }
        }
        throw new IllegalArgumentException("Computed column mode (" + String.valueOf((Object)computedColumn.mode) + ") is not valid.");
    }

    public static void preFilter(SelectQueryBuilder query, FilterDesc filter, SQLDialect dialect, Dataset inputDataset, boolean ignoreFilterTranslationError) {
        if (filter != null) {
            if (filter.enabled) {
                QueryGenerationUtils.addWhereClause(query, filter, dialect, inputDataset, ignoreFilterTranslationError);
            }
            if (filter.distinct) {
                query.selectDistinct();
            }
        }
    }

    public static SelectQueryBuilder postFilter(SelectQueryBuilder query, FilterDesc filter, SQLDialect dialect, boolean ignoreFilterTranslationError) {
        SelectQueryBuilder originalQuery = query;
        if (filter != null) {
            SelectQueryBuilder outerQuery;
            if (filter.enabled) {
                outerQuery = new SelectQueryBuilder();
                outerQuery.from(query, "unfiltered_query");
                QueryGenerationUtils.addWhereClause(outerQuery, filter, dialect, null, ignoreFilterTranslationError);
                query = outerQuery;
            }
            if (filter.distinct) {
                if (dialect instanceof ImpalaSQLDialect && query == originalQuery) {
                    outerQuery = new SelectQueryBuilder();
                    outerQuery.from(query, "unfiltered_query");
                    query = outerQuery;
                }
                query.selectDistinct();
            }
        }
        return query;
    }

    private static void addWhereClause(SelectQueryBuilder query, FilterDesc filter, SQLDialect dialect, Dataset inputDataset, boolean ignoreFilterTranslationError) {
        try {
            ExpressionBuilder eb = FilterDescUtils.getSQLExpressionBuilder(filter, dialect, inputDataset, true);
            eb.toSQL(dialect);
            query.where(eb);
        }
        catch (Exception e) {
            if (ignoreFilterTranslationError) {
                logger.info((Object)"Filter expression cannot be translated to SQL (stream filtering required).", (Throwable)e);
            }
            throw new IllegalArgumentException("Filter expression cannot be translated to SQL.", e);
        }
    }

    public static SelectQueryBuilder applyOverrides(SelectQueryBuilder query, Map<String, String> overrides, SQLDialect dialect, boolean forceOutputColumnNameOverride) {
        if (overrides != null && overrides.size() > 0 && (forceOutputColumnNameOverride || dialect.mustForceOutputColumnNameOverrides())) {
            List<String> names = query.getSelectedItemsAliases();
            ArrayList overriden = Lists.newArrayList();
            for (String name : names) {
                if (overrides.containsKey(name)) {
                    overriden.add(overrides.get(name));
                    continue;
                }
                overriden.add(name);
            }
            SelectQueryBuilder outerQuery = new SelectQueryBuilder();
            outerQuery.from(query, "pristine_query");
            for (int i = 0; i < names.size(); ++i) {
                outerQuery.select(names.get(i), (String)overriden.get(i));
            }
            return outerQuery;
        }
        return query;
    }

    public static SelectQueryBuilder applyInsertIntoCasts(SelectQueryBuilder query, SQLDialect dialect, Dataset outputDataset) {
        if (dialect == null) {
            logger.warn((Object)"No dialect set for SQL query handling, not casting on output");
            return query;
        }
        SQLDialect.InsertIntoCaster insertIntoCaster = dialect.getInsertIntoCaster(outputDataset);
        List<String> names = query.getSelectedNames();
        Schema outputSchema = outputDataset == null ? new Schema() : outputDataset.getSchema();
        HashMap<String, ExpressionBuilder> casts = new HashMap<String, ExpressionBuilder>();
        Map<String, SchemaColumn> outputSchemaColumnIndex = SchemaUtils.indexColumns(outputSchema);
        for (String name : names) {
            SchemaColumn outputColumn;
            ExpressionBuilder col = ef.col(name);
            ExpressionBuilder casted = insertIntoCaster.castIfNeeded(col, outputColumn = outputSchemaColumnIndex.get(name));
            if (casted == col) continue;
            casts.put(name, casted);
        }
        if (casts.isEmpty()) {
            return query;
        }
        logger.info((Object)("Need to apply " + casts.size() + " cast()s"));
        SelectQueryBuilder outerQuery = new SelectQueryBuilder();
        outerQuery.from(query, "pristine_query");
        for (String name : names) {
            outerQuery.select(casts.getOrDefault(name, ef.col(name)), name);
        }
        return outerQuery;
    }

    public static class SelectQueryBuilderAndSchema {
        public SelectQueryBuilder selectQueryBuilder;
        public Dataset dataset;
        public Schema schema;
    }
}

