/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.FuzzyJoinRecords;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.IOHandler;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.Record;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.Writer;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.selector.CandidateSelectorPipeline;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Verifier;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.ListUtils;

public class FuzzyJoinBuiltinRecipeExecutor
extends AbstractInitializedRunner
implements RecipeRunnerWithPayload {
    public static final int BATCH_SIZE = 1000;
    private final FuzzyJoinRecipeHelper helper = new FuzzyJoinRecipeHelper();
    private FuzzyJoinRecipePayloadParams payload;
    private List<AbstractInitializedRunner.Input> virtualInputs = new ArrayList<AbstractInitializedRunner.Input>();
    private final boolean debugMode;
    private IOHandler ioHandler;
    private FuzzyJoinRecords queries;
    private CandidateSelectorPipeline selectorPipeline;
    protected boolean abortNotified;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipe.fuzzyjoin.builtin");

    public FuzzyJoinBuiltinRecipeExecutor(JobActivity activity, boolean debugMode) throws Exception {
        super(activity);
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = subgraph.getRecipe();
        this.debugMode = debugMode;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void setPayload(String serializedPayload) {
        logger.info((Object)("SET PAYLOAD: " + serializedPayload));
        this.payload = this.helper.loadParams(serializedPayload, this.recipe.getModel());
    }

    @Override
    public void init() throws Exception {
        this.inputs = Maps.newHashMap();
        this.initInputs();
        this.outputs = Maps.newHashMap();
        this.initOutputs();
    }

    @Override
    protected AbstractInitializedRunner.Input initializeInput(Dataset inputDS, Schema schema, StreamableDatasetSelection ds, String role) {
        AbstractInitializedRunner.Input input = super.initializeInput(inputDS, schema, ds, role);
        if (role.equals("main")) {
            this.virtualInputs.add(input);
            if (((JoinInputDescBase)this.payload.virtualInputs.get((int)0)).index == ((JoinInputDescBase)this.payload.virtualInputs.get((int)1)).index) {
                this.virtualInputs.add(super.initializeInput(inputDS, schema, ds, role));
            }
        }
        return input;
    }

    @Override
    public void run() throws Exception {
        this.helper.initInputDatasets(this.activity, this.payload);
        this.payload.validate();
        this.helper.initAliases(this.payload);
        logger.info((Object)"Init Fuzzy Join engine");
        this.ioHandler = new IOHandler(this.activity, this.virtualInputs, (List)this.outputs.get("main"), this.payload);
        this.queries = this.ioHandler.getQueryRecords();
        this.selectorPipeline = new CandidateSelectorPipeline(this.ioHandler.getJoinDesc(), this.ioHandler.getCandidateRecords(), this.debugMode);
        int numberOfQueries = this.ioHandler.countQueries();
        int countProcessedQueries = 0;
        long lastTime = System.currentTimeMillis();
        ExecutorService executorService = Executors.newCachedThreadPool();
        int logEveryNQueries = DKUApp.getParams().getIntParam("dku.recipes.fuzzyjoin.logProgressEveryRows", Integer.valueOf(1000));
        long totalCandidates = 0L;
        long totalVerificationTasks = 0L;
        try (Writer writer = this.ioHandler.getWriter();){
            logger.infoV("Executing Fuzzy Join engine for %d rows", new Object[]{numberOfQueries});
            HashMap<Integer, Collection<Integer>> matchedRowsByTable = new HashMap<Integer, Collection<Integer>>();
            try (FuzzyJoinRecords.RecordsIterator queryIterator = this.queries.iterator();){
                while (queryIterator.hasNext()) {
                    Record query = queryIterator.next();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Selecting candidates for record " + countProcessedQueries));
                    }
                    List<Record> candidates = this.selectorPipeline.selectCandidates(query);
                    totalCandidates += (long)candidates.size();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Got " + candidates.size() + " candidates"));
                    }
                    List<VerifierTask> verifierTasks = this.buildTasks(query, candidates, writer);
                    totalVerificationTasks += (long)verifierTasks.size();
                    List<Future<Map<Integer, List<Integer>>>> futures = executorService.invokeAll(verifierTasks);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Submitted " + verifierTasks.size() + " verification tasks"));
                    }
                    writer.populateMatchedRows(matchedRowsByTable, futures);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Match verification processed");
                    }
                    lastTime = this.logProgress(logEveryNQueries, numberOfQueries, ++countProcessedQueries, totalCandidates, totalVerificationTasks, lastTime);
                }
            }
            writer.setRowsAsMatch(matchedRowsByTable);
        }
        executorService.shutdown();
        executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
    }

    private long logProgress(int logEveryNQueries, int numberOfQueries, int countProcessedQueries, long totalCandidates, long totalVerificationTasks, long prevTime) {
        if (countProcessedQueries % logEveryNQueries == 0 || countProcessedQueries == numberOfQueries) {
            float progress = (float)countProcessedQueries * 100.0f / (float)numberOfQueries;
            long now = System.currentTimeMillis();
            int queriesSinceLastTime = countProcessedQueries % logEveryNQueries > 0 ? countProcessedQueries % logEveryNQueries : logEveryNQueries;
            float elaspedTimePerQuery = (float)(now - prevTime) / (float)queriesSinceLastTime;
            logger.debugV("Fuzzy processing: processed=%d total=%d completion=%.2f%% time_per_query=%.3fms total_candidates=%d avg_candidates_per_query=%.1f total_verification_tasks=%d", new Object[]{countProcessedQueries, numberOfQueries, Float.valueOf(progress), Float.valueOf(elaspedTimePerQuery), totalCandidates, Float.valueOf((float)totalCandidates / (float)countProcessedQueries), totalVerificationTasks});
            return now;
        }
        return prevTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        FuzzyJoinBuiltinRecipeExecutor fuzzyJoinBuiltinRecipeExecutor = this;
        synchronized (fuzzyJoinBuiltinRecipeExecutor) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
        }
        this.notifyBeforeAborting();
    }

    private List<VerifierTask> buildTasks(Record query, List<Record> candidates, Writer writer) {
        ArrayList<VerifierTask> tasks = new ArrayList<VerifierTask>();
        for (List batch : ListUtils.partition(candidates, (int)1000)) {
            tasks.add(new VerifierTask(query, batch, new Verifier(this.ioHandler.getJoinDesc()), writer));
        }
        return tasks;
    }

    private static void emitResult(Map<Integer, List<Integer>> matchedRowsByTable, Verifier.VerifierResult verifierResult) {
        if (verifierResult.isMatch) {
            if (!matchedRowsByTable.containsKey(verifierResult.candidate.getTable())) {
                matchedRowsByTable.put(verifierResult.candidate.getTable(), new ArrayList());
            }
            matchedRowsByTable.get(verifierResult.candidate.getTable()).add(verifierResult.candidate.getIndex());
            if (!matchedRowsByTable.containsKey(verifierResult.query.getTable())) {
                matchedRowsByTable.put(verifierResult.query.getTable(), new ArrayList());
            }
            matchedRowsByTable.get(verifierResult.query.getTable()).add(verifierResult.query.getIndex());
        }
    }

    static class VerifierTask
    implements Callable<Map<Integer, List<Integer>>> {
        private final Record query;
        private final List<Record> candidates;
        private final Verifier verifier;
        private final Writer writer;

        public VerifierTask(Record query, List<Record> candidates, Verifier verifier, Writer writer) {
            this.query = query;
            this.candidates = candidates;
            this.verifier = verifier;
            this.writer = writer;
        }

        @Override
        public Map<Integer, List<Integer>> call() throws Exception {
            ArrayList<Verifier.VerifierResult> results = new ArrayList<Verifier.VerifierResult>();
            for (Record candidate : this.candidates) {
                results.add(this.verifier.computeMatch(this.query, candidate));
            }
            HashMap<Integer, List<Integer>> matchedRowsByTable = new HashMap<Integer, List<Integer>>();
            for (Verifier.VerifierResult verifierResult : results) {
                this.writer.emit(verifierResult);
                FuzzyJoinBuiltinRecipeExecutor.emitResult(matchedRowsByTable, verifierResult);
            }
            return matchedRowsByTable;
        }
    }
}

