/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.grouping;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.GroupingRecipeService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class GroupingRecipeCreator
extends SISORecipeCreator {
    private GroupingRecipeService service = new GroupingRecipeService();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.group.creator");

    public GroupingRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
        SpringUtils.getInstance().autowire((Object)this.service);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        Dataset inputDataset = this.getInputDataset(recipe);
        GroupingRecipePayloadParams params = this.service.loadParams(payload, recipe);
        Schema outputSchema = this.service.getOutputSchemaAfterOverride(inputDataset, params, false, null);
        outputDataset.setSchema(outputSchema);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        GroupingRecipeCreationSettings settings = (GroupingRecipeCreationSettings)JSON.parse((JsonElement)data, GroupingRecipeCreationSettings.class);
        GroupingRecipePayloadParams params = new GroupingRecipePayloadParams();
        params.getRawGroupingKeys().add(new GroupingRecipePayloadParams.GroupingKey(settings.groupKey));
        params.enlargeYourBits = true;
        params.engineParams.lowerCaseSchemaIfEngineRequiresIt = true;
        RecipeCreationUtils.setupAllEnginesCreationParams(this.authCtx, recipe.projectKey, params.engineParams);
        RecipeCreationUtils.switchToHiveserverForHiveDataset(inputDataset, params.engineParams);
        for (SchemaColumn col : inputDataset.getSchema().getColumns()) {
            if (col.getName().equals(settings.groupKey)) continue;
            GroupingRecipePayloadParams.GroupingValue cc = new GroupingRecipePayloadParams.GroupingValue();
            cc.column = col.getName();
            params.values.add(cc);
        }
        params.globalCount = true;
        return JSON.json((Object)params);
    }

    public static class GroupingRecipeCreationSettings
    extends SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings {
        public String groupKey;
    }
}

