/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.joinlike;

import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum JoinOutputRole {
    MAIN("main"),
    UNMATCHED_ROWS_LEFT("unmatchedLeft"),
    UNMATCHED_ROWS_RIGHT("unmatchedRight");

    public final String name;

    private JoinOutputRole(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static JoinOutputRole fromString(String str) {
        for (JoinOutputRole role : JoinOutputRole.values()) {
            if (!role.name.equals(str)) continue;
            return role;
        }
        throw new IllegalArgumentException("Recipe has output roles '" + Arrays.stream(JoinOutputRole.values()).map(r -> r.name).collect(Collectors.joining("', '")) + "', got: '" + str + "'");
    }

    public boolean isCompatibleWithJoinType(JoinType type) {
        switch (this) {
            case MAIN: {
                return true;
            }
            case UNMATCHED_ROWS_LEFT: {
                return type == JoinType.INNER || type == JoinType.RIGHT;
            }
            case UNMATCHED_ROWS_RIGHT: {
                return type == JoinType.INNER || type == JoinType.LEFT;
            }
        }
        throw new IllegalStateException("Unknown join output role");
    }
}

