/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.joinlike;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.common.VirtualInputBasedRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.common.creation.VirtualInputsRecipeCreationSettings;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.InputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.MatchingConditionBase;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VirtualInputBasedRecipeCreationService {
    @Autowired
    private DatasetAccessService datasetAccessService;

    public <I extends JoinInputDescBase, M extends MatchingConditionBase, J extends JoinDescBase<M>> void initializeJoinLikePayload(JoinLikeRecipePayloadParams<I, M, J> params, VirtualInputsRecipeCreationSettings settings, AuthCtx authCtx, SerializedRecipe sr, Dataset outputDataset) throws IOException {
        params.initializeJoinDesc();
        List<ColumnDesc> selectedColumns = this.initializeVirtualInputPayload(params, settings, authCtx, sr, outputDataset);
        for (JoinInputDescBase virtualInput : params.virtualInputs) {
            virtualInput.outputColumnsSelectionMode = JoinInputDescBase.OutputColumnsSelectionMode.AUTO_NON_CONFLICTING;
            virtualInput.computedColumns = new ArrayList<ComputedColumn>();
        }
        for (JoinInputDescBase virtualInput : params.getVirtualInputs()) {
            virtualInput.preFilter = new FilterDesc();
        }
        params.setSelectedColumns(selectedColumns);
    }

    public <I extends InputDescBase> Dataset[] initializeVirtualInputs(VirtualInputBasedRecipePayloadParams<I> params, VirtualInputsRecipeCreationSettings settings, AuthCtx authCtx, SerializedRecipe sr) throws IOException {
        RecipeCreationUtils.setupAllEnginesCreationParams(authCtx, sr.projectKey, params.engineParams);
        params.engineParams.lowerCaseSchemaIfEngineRequiresIt = true;
        sr.getInputsUnsafe().clear();
        ArrayList<String> existingInputs = new ArrayList<String>();
        Dataset[] inputDatasets = new Dataset[settings.virtualInputs.size()];
        for (int virtualInputIndex = 0; virtualInputIndex < settings.virtualInputs.size(); ++virtualInputIndex) {
            String inputRef = settings.virtualInputs.get(virtualInputIndex);
            DatasetLocUtils.DatasetLoc inputLoc = DatasetLocUtils.resolveSmart(sr.projectKey, inputRef);
            inputDatasets[virtualInputIndex] = this.datasetAccessService.getMandatory(inputLoc);
            RecipeCreationUtils.switchToHiveserverForHiveDataset(inputDatasets[virtualInputIndex], params.engineParams);
            int index = existingInputs.indexOf(inputRef);
            if (index < 0) {
                sr.addInput("main", inputRef);
                index = existingInputs.size();
                existingInputs.add(inputRef);
            }
            I inputDesc = params.newInputDesc();
            ((InputDescBase)inputDesc).index = index;
            ((InputDescBase)inputDesc).originLabel = inputRef;
            params.addVirtualInput(inputDesc);
        }
        return inputDatasets;
    }

    public <I extends InputDescBase> List<ColumnDesc> initializeSelectedColumns(Dataset[] inputDatasets, Dataset outputDataset) {
        ArrayList<ColumnDesc> selectedColumns = new ArrayList<ColumnDesc>();
        HashSet<String> usedColumnNames = new HashSet<String>();
        HashSet excludedFromInput = Sets.newHashSet();
        if (outputDataset.getPartitioningSchema() != null && outputDataset.getPartitioningSchema().isPartitioned() && DatasetInspector.arePartitioningColumnsForbiddenInSchema(outputDataset)) {
            excludedFromInput.addAll(outputDataset.getPartitioningSchema().getDimensionNames());
        }
        for (int virtualInputIndex = 0; virtualInputIndex < inputDatasets.length; ++virtualInputIndex) {
            for (SchemaColumn sc : inputDatasets[virtualInputIndex].getSchema().columns) {
                String name = sc.getName();
                if (usedColumnNames.contains(name) || excludedFromInput.contains(name)) continue;
                ColumnDesc cd = new ColumnDesc();
                cd.name = name;
                cd.table = virtualInputIndex;
                selectedColumns.add(cd);
                usedColumnNames.add(name);
            }
        }
        return selectedColumns;
    }

    public <I extends InputDescBase> List<ColumnDesc> initializeVirtualInputPayload(VirtualInputBasedRecipePayloadParams<I> params, VirtualInputsRecipeCreationSettings settings, AuthCtx authCtx, SerializedRecipe sr, Dataset outputDataset) throws IOException {
        Dataset[] inputDatasets = this.initializeVirtualInputs(params, settings, authCtx, sr);
        return this.initializeSelectedColumns(inputDatasets, outputDataset);
    }
}

