/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.r;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.r.RRecipeMeta;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.recipes.code.r.AbstractRRecipeRunner;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import java.io.File;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class RRecipeRunner
extends AbstractRRecipeRunner
implements RecipeRunnerWithPayload {
    @Autowired
    private JobAuthCtxService authCtxService;
    private String code;
    private static Logger logger = Logger.getLogger((String)"dku.flow.R");

    public RRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public void setPayload(String payload) {
        this.code = payload;
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() throws Exception {
        block12: {
            params = this.recipe.getModel().getParamsAs(RRecipeMeta.RRecipeParams.class);
            envName = new CodeEnvSelector().selectForRRecipe(this.recipe.getProjectKey(), params.envSelection);
            codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.R, envName);
            containerConfig = new ContainerExecConfigSelector().select_autoTXN(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), params.containerSelection);
            additionalLogsFolder = FlowJobUtils.getJobMadeDir("R-recipe", "logs");
            mainLogFile = FlowJobUtils.getJobTouchedFile("R-recipe", "R-output.log");
            JobContext.getCurrentActivityObj().getStatus().addStatutOutput("R output", mainLogFile, "text/plain");
            recipeTmpDir = FlowJobUtils.getTmpFolder("r-recipe", "rout");
            try {
                rScriptData = this.code;
                if (rScriptData == null) {
                    throw new Error("Could not find R script for " + this.recipe.getName());
                }
                this.activity.setStatusMessage("Executing R script");
                RRecipeRunner.logger.info((Object)"Starting execution of user's R code");
                if (containerConfig == null) {
                    this.executeScript(this.recipe.getProjectKey(), envName, mainLogFile, (File)recipeTmpDir, rScriptData);
                    break block12;
                }
                switch (2.$SwitchMap$com$dataiku$dip$containers$exec$ContainerExecRuntimeConfig$Container[containerConfig.type.ordinal()]) {
                    case 1: {
                        this.executeDockerCodeRecipe(codeEnvRef, containerConfig, (File)recipeTmpDir, mainLogFile, recipeTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_R, this.code, Collections.emptyMap(), null);
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        this.executeKubernetesCodeRecipe(codeEnvRef, containerConfig, (File)recipeTmpDir, mainLogFile, additionalLogsFolder, recipeTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_R, this.code, Collections.emptyMap(), null, new KubernetesExecUtils.KubernetesFailureCodeProvider(){

                            @Override
                            public InfoMessage.MessageCode codeForOOMKilled() {
                                return RecipeCodes.ERR_RECIPE_CODE_K8S_OOM;
                            }
                        });
                        ** break;
lbl26:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown execution container: " + String.valueOf((Object)containerConfig.type));
                    }
                }
            }
            finally {
                if (recipeTmpDir != null) {
                    recipeTmpDir.close();
                }
            }
        }
        RRecipeRunner.logger.info((Object)"Execution of user's R code complete");
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }
}

