/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.stream;

import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.WithFactories;
import com.dataiku.dip.dataflow.exec.WithPushOutputs;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.utils.Assertions;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.List;

public class RowStreamSplitRunnable
implements FlowRunnable,
WithPushOutputs,
WithFactories {
    private RowOrientedDatasetHandler dh;
    private InputFilter filter;
    private ProcessorOutput out;
    private ColumnFactory cf;
    private RowFactory rf;
    private WarningsContext warningsContext;
    public InputSplitProgressListener listener = new InputSplitProgressListener();

    public RowStreamSplitRunnable(RowOrientedDatasetHandler dh, InputFilter filter, WarningsContext warningsContext) {
        this.dh = dh;
        this.filter = filter;
        this.warningsContext = warningsContext;
    }

    @Override
    public void setOutput(String name, ProcessorOutput out) {
        this.out = out;
    }

    @Override
    public void setFactories(ColumnFactory cf, RowFactory rf) {
        assert (this.out != null);
        this.cf = cf;
        this.rf = rf;
        if (this.out instanceof ProcessorOutputToSIP) {
            SingleInputRowProcessor sirp = ((ProcessorOutputToSIP)this.out).getTarget();
            Assertions.assertInstanceof((Object)sirp, WithFactories.class);
            ((WithFactories)sirp).setFactories(cf, rf);
        } else {
            Assertions.assertInstanceof((Object)this.out, WithFactories.class);
            ((WithFactories)this.out).setFactories(cf, rf);
        }
    }

    @Override
    public void run() throws Exception {
        if (this.filter == null) {
            this.filter = InputFilter.all();
        }
        List risList = this.dh.getFilterSplits(this.filter).getSplits();
        for (InputSplit split : risList) {
            ((RowsInputSplit)split).push(this.out, this.cf, this.rf, null, this.listener, this.warningsContext);
        }
        this.out.lastRowEmitted();
    }
}

