/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.FSSubgraphHelper;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CloudFileListingSupport {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.cloudsupport");

    private CloudFileListingSupport() {
    }

    private static boolean needToEnumerateFiles(PartitioningScheme inputPartitionSchema, FilesSelectionRules selectionRules) {
        if (inputPartitionSchema.isPartitioned()) {
            logger.info((Object)"Input dataset is partitioned, adding all paths in partition");
            return true;
        }
        if (selectionRules != null && selectionRules.mode != FilesSelectionRules.Mode.ALL) {
            logger.info((Object)"Input dataset has file selection rules specified (i.e. not ALL), adding all included paths");
            return true;
        }
        return false;
    }

    public static String createSpecifiedFilesList(List<String> filePaths) {
        return filePaths.stream().map(path -> "'" + path + "'").collect(Collectors.joining(", "));
    }

    public static InputFSPaths createInputFSPaths(BlobLikeDatasetHandler<?> blobHandler, String rootPath, Dataset inputDS, List<Partition> inputPartitions, AuthCtx authCtx, int maxFiles) throws Exception {
        InputFSPaths inputFSPaths = new InputFSPaths();
        logger.info((Object)("Original blob root path is: " + rootPath));
        if (blobHandler.isSingleFile()) {
            logger.info((Object)("Input dataset is a single path file, using original root path: " + rootPath));
            inputFSPaths.rootPath = rootPath;
        } else {
            String cleansedRootPath = PathUtils.slashes((String)rootPath, null, (Boolean)true, (boolean)false, null);
            logger.info((Object)("Cleansed blob root path is: " + cleansedRootPath));
            inputFSPaths.rootPath = cleansedRootPath;
            ArrayList<String> allFilePaths = new ArrayList<String>();
            if (CloudFileListingSupport.needToEnumerateFiles(inputDS.getPartitioningSchema(), blobHandler.getEnumerationSettings().selectionRules)) {
                FilePartitioner.ResolvedFilesFilterResult filesFilterResult = FSSubgraphHelper.getInputFiles(authCtx, inputPartitions, inputDS);
                for (FSPath fsPath : filesFilterResult.getAllPaths()) {
                    String strippedFilePath = PathUtils.stripLeadingSlash((String)fsPath.path());
                    allFilePaths.add(strippedFilePath);
                }
                allFilePaths.stream().limit(10L).forEach(path -> logger.info((Object)("Included " + path + " file to copy")));
                if (allFilePaths.size() > 10) {
                    logger.info((Object)"Only printing first 10 files to copy");
                }
                logger.info((Object)("Specified " + allFilePaths.size() + " file(s) to copy"));
                inputFSPaths.chunkedFilePaths = Lists.partition(allFilePaths, (int)maxFiles);
                inputFSPaths.useChunkedFilePaths = true;
                logger.info((Object)("Split files list in " + inputFSPaths.chunkedFilePaths.size() + " chunks(s) to copy"));
            }
        }
        return inputFSPaths;
    }

    public static class InputFSPaths {
        String rootPath;
        boolean useChunkedFilePaths = false;
        List<List<String>> chunkedFilePaths = new ArrayList<List<String>>();
    }
}

