/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.exec.sync.AbtractToVerticaExecutor;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeParams;
import com.dataiku.dip.dataflow.exec.sync.VerticaPartitionConfig;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datalayer.utils.OutputStreamFormattingProcessorOutput;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.VerticaCopyCSVFormatter;
import com.dataiku.dip.sql.VerticaCopyHelper;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class SingleThreadAnyToVertica
extends AbtractToVerticaExecutor {
    volatile boolean readFailed;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipe.sync");

    public SingleThreadAnyToVertica(SyncRecipeParams params) {
        super(params);
    }

    @Override
    public void run() throws Exception {
        try (AbstractSQLTableDatasetHandler vti = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.outputDS);){
            this.connData = vti.getConnectionData();
            this.readFailed = false;
            VerticaPartitionConfig partitionConfig = new VerticaPartitionConfig(this.outputDS, this.outputPartition);
            SQLConnectionProvider.SQLConnectionWrapper conn = vti.newConnection();
            try {
                InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                this.connData.getDialect().dropIfNeededAndCreateTableOrPartition(this.authCtx, vti.getConnectionData(), conn, this.outputDS, partitionConfig.outKey, this.writeMode, messages);
                if (!messages.isEmpty()) {
                    this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
                }
                SQLUtils.executePreWriteStatements(vti.getConnectionData(), conn, this.outputDS);
                try (PipedInputStream pis = new PipedInputStream();
                     PipedOutputStream pos = new PipedOutputStream(pis);){
                    VerticaCopyHelper helper = new VerticaCopyHelper();
                    String copyStatement = this.createCopyStatement(vti);
                    logger.info((Object)("Using copy statement " + copyStatement));
                    helper.createCopyStream(conn, copyStatement);
                    logger.info((Object)"Starting input dataset read thread");
                    ReadInputDatasetThread readThread = new ReadInputDatasetThread(partitionConfig, pos);
                    readThread.start();
                    logger.info((Object)"Starting to send to Vertica ...");
                    helper.addStream(pis);
                    helper.execute();
                    logger.info((Object)"Vertica streaming is done, waiting for read thread");
                    readThread.join();
                    logger.info((Object)("Terminating Vertica connection, loaded: " + helper.getRowCount()));
                    helper.finish();
                    this.warnRejects();
                    SQLUtils.executePostWriteStatements(vti.getConnectionData(), conn, this.outputDS);
                    conn.commit();
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Copy to Vertica failed", (Throwable)e);
                SQLUtils.unsafeRollbackAndClose(conn);
                throw e;
            }
        }
    }

    private class ReadInputDatasetThread
    extends Thread {
        private final VerticaPartitionConfig partitionConfig;
        private final PipedOutputStream outputStream;

        public ReadInputDatasetThread(VerticaPartitionConfig partitionConfig, PipedOutputStream outputStream) {
            this.partitionConfig = partitionConfig;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            try {
                StreamColumnFactory cf = new StreamColumnFactory();
                VerticaCopyCSVFormatter formatter = new VerticaCopyCSVFormatter(SingleThreadAnyToVertica.this.outputDS.getSchema(), this.partitionConfig.keyColumn, this.partitionConfig.partitionValue);
                OutputStreamFormattingProcessorOutput out = new OutputStreamFormattingProcessorOutput(this.outputStream, (OutputFormatter)formatter, (ColumnFactory)cf);
                StreamableDatasetSelection sel = StreamableDatasetSelection.full();
                sel.withSelectedPartitions(SingleThreadAnyToVertica.this.inputPartitions);
                UniversalSingleThreadPusher.push(SingleThreadAnyToVertica.this.authCtx, SingleThreadAnyToVertica.this.inputDS, sel, out, (ColumnFactory)cf, (RowFactory)new StreamRowFactory());
                out.lastRowEmitted();
            }
            catch (Exception e) {
                logger.error((Object)"Input dataset read thread failed,", (Throwable)e);
                SingleThreadAnyToVertica.this.readFailed = true;
            }
        }
    }
}

