/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.sync.AzureBlobToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.AzureBlobToSynapse;
import com.dataiku.dip.dataflow.exec.sync.AzureToTrino;
import com.dataiku.dip.dataflow.exec.sync.BigQueryToGCS;
import com.dataiku.dip.dataflow.exec.sync.DatabricksToAzureBlob;
import com.dataiku.dip.dataflow.exec.sync.DatabricksToS3;
import com.dataiku.dip.dataflow.exec.sync.DatabricksVolumeToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.GCSToBigQuery;
import com.dataiku.dip.dataflow.exec.sync.GcsToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.GcsToTrino;
import com.dataiku.dip.dataflow.exec.sync.RedshiftToS3;
import com.dataiku.dip.dataflow.exec.sync.S3ToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.S3ToRedshift;
import com.dataiku.dip.dataflow.exec.sync.S3ToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.S3ToTrino;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToGcs;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToS3;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToWASB;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeParams;
import com.dataiku.dip.dataflow.exec.sync.TeradataHadoop;
import com.dataiku.dip.dataflow.exec.sync.TrinoToAzure;
import com.dataiku.dip.dataflow.exec.sync.TrinoToGcs;
import com.dataiku.dip.dataflow.exec.sync.TrinoToS3;
import com.dataiku.dip.dataflow.exec.sync.WASBToSnowflake;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.SamplingRecipeService;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private SamplingRecipeService samplingRecipeService;

    public SyncRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public SyncRecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        StatusInitializer init = new StatusInitializer();
        return this.getBaseStatus_NT(init, authCtx);
    }

    @Override
    public SyncRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), authCtx);
    }

    @Override
    public SyncRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        StatusInitializer init = new StatusInitializer();
        SyncRecipeStatus status = this.getBaseStatus_NT(init, authCtx);
        try (Transaction t = this.transactionService.beginRead();){
            status.sql = this.samplingRecipeService.generateSQL(init.activity, init.dialect, status.engineParams);
        }
        return status;
    }

    private SyncRecipeStatus getBaseStatus_NT(StatusInitializer init, AuthCtx authCtx) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            SyncRecipeStatus syncRecipeStatus = this.fastStatusIgnorePartitions(init, authCtx);
            return syncRecipeStatus;
        }
    }

    private SyncRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, AuthCtx authCtx) throws Exception {
        SyncRecipeStatus status = new SyncRecipeStatus();
        init.activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
        SyncRecipeParams params = (SyncRecipeParams)this.recipe.params;
        status.engineParams = params.engineParams;
        status.engines = this.getEnginesStatus(authCtx, params);
        this.performBasicCDEChecks(status, authCtx);
        status.selectedEngine = this.selectEngine(authCtx, init.activity, params.engineType, status.engines);
        this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Should not appear");
        if (status.selectedEngine instanceof VisualSQLRecipesBaseService.SQLBasedEngineStatus) {
            init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
        }
        this.performBasicStructureChecks(status, authCtx);
        this.recipesValidationService.checkTargetsAreWritable(init.activity);
        return status;
    }

    public RecipeEngineStatus selectEngine(AuthCtx authCtx, JobActivity activity, String userSelected, SyncRecipeParams params) throws Exception {
        List<RecipeEngineStatus> statusList = this.getEnginesStatus(authCtx, params);
        return this.selectEngine(authCtx, activity, userSelected, statusList);
    }

    public List<RecipeEngineStatus> getEnginesStatus(AuthCtx authCtx, SyncRecipeParams params) throws Exception {
        ArrayList<RecipeEngineStatus> ret = new ArrayList<RecipeEngineStatus>();
        JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
        Dataset inputDataset = activity.getSubgraph().getSourceDatasets().get(0).getMandatory(this.datasetsDAO);
        FlowComputable output = activity.getSubgraph().getTargets().get(0);
        if (output.getType() == FlowComputable.FCType.DATASET) {
            Dataset outputDataset = activity.getSubgraph().getTargetsDatasets().get(0).getMandatory(this.datasetsDAO);
            VisualSQLRecipesBaseService.AppConfig appConfig = this.visualRecipesService.getAppConfig(authCtx, this.recipe.projectKey);
            VisualSQLRecipesBaseService.SQLBasedEngineStatus stream = this.visualRecipesService.makeDSSBasedEngineStatus();
            VisualSQLRecipesBaseService.SQLBasedEngineStatus hive = this.visualRecipesService.makeHiveEngineStatus(authCtx, activity, appConfig);
            VisualSQLRecipesBaseService.SQLBasedEngineStatus impala = this.visualRecipesService.makeImpalaEngineStatus(authCtx, activity, appConfig);
            VisualSQLRecipesBaseService.SQLBasedEngineStatus spark = this.visualRecipesService.makeSparkSQLEngineStatus(authCtx, this.recipe.projectKey);
            VisualSQLRecipesBaseService.SQLBasedEngineStatus sql = this.visualRecipesService.makeSQLEngineStatus(authCtx, activity);
            ServiceUtils.EngineUsability engineResult = ServiceUtils.canFullSQL(authCtx, activity, this.datasetsDAO);
            if (sql.isSelectable && !engineResult.canUse()) {
                sql.markAsNonSelectable(engineResult.getReason(), RecipeEngineStatus.WarningLevel.ERROR);
            }
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", hive, impala, spark, sql);
            }
            SerializedRecipe.RecipeOutput ro = this.recipe.getSingleOutput("main");
            if (ro.appendMode) {
                RecipeEngineStatus.setErrorStatus("Not compatible with append mode", hive, impala);
                if (!DeltaFormat.META.getType().equals(outputDataset.getFormatType())) {
                    RecipeEngineStatus.setErrorStatus("Not compatible with append mode", spark);
                }
            }
            ret.add(stream);
            ret.add(hive);
            ret.add(impala);
            ret.add(spark);
            ret.add(sql);
            RecipeEngineStatus s3ToRedshift = new RecipeEngineStatus("S3_TO_REDSHIFT", "S3 to Redshift", null, null, "S3 to Redshift");
            s3ToRedshift.description = "Direct S3 to Redshift";
            S3ToRedshift.setCompatible(inputDataset, outputDataset, s3ToRedshift);
            if (ro.appendMode) {
                s3ToRedshift.setStatus("Not compatible with append mode", RecipeEngineStatus.WarningLevel.ERROR);
            }
            ret.add(s3ToRedshift);
            RecipeEngineStatus redshiftToS3 = new RecipeEngineStatus("REDSHIFT_TO_S3", "Redshift to S3", null, null, "Redshift to S3");
            redshiftToS3.description = "Direct Redshift to S3";
            RedshiftToS3.setCompatible(inputDataset, outputDataset, redshiftToS3, ro);
            ret.add(redshiftToS3);
            RecipeEngineStatus azureBlobToSynapse = new RecipeEngineStatus("AZURE_TO_SQLSERVER", "Azure Blob Storage to Synapse Warehouse", null, null, "Azure Blob Storage to Synapse Warehouse");
            azureBlobToSynapse.description = "Direct Azure Blob Storage to Synapse Warehouse";
            AzureBlobToSynapse.setCompatible(BuiltinSQLDatasets.SYNAPSE_META, authCtx, inputDataset, outputDataset, azureBlobToSynapse, params.engineParams.synapseParams);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", azureBlobToSynapse);
            }
            ret.add(azureBlobToSynapse);
            RecipeEngineStatus azureBlobToFabric = new RecipeEngineStatus("AZURE_TO_FABRIC", "Azure Blob Storage to Fabric Warehouse", null, null, "Azure Blob Storage to Fabric Warehouse");
            azureBlobToFabric.description = "Direct Azure Blob Storage to Fabric Warehouse";
            AzureBlobToSynapse.setCompatible(BuiltinSQLDatasets.FABRIC_WAREHOUSE_META, authCtx, inputDataset, outputDataset, azureBlobToFabric, params.engineParams.synapseParams);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", azureBlobToFabric);
            }
            ret.add(azureBlobToFabric);
            RecipeEngineStatus gcsToBigQuery = new RecipeEngineStatus("GCS_TO_BIGQUERY", "GCS to BigQuery", null, null, "GCS to BigQuery");
            gcsToBigQuery.description = "Direct Google Cloud Storage to BigQuery";
            GCSToBigQuery.setCompatible(inputDataset, outputDataset, gcsToBigQuery, ro);
            ret.add(gcsToBigQuery);
            RecipeEngineStatus teradataHadoop = new RecipeEngineStatus("TDCH", "TDCH ", null, null, "TDCH");
            TeradataHadoop.setCompatible(inputDataset, outputDataset, teradataHadoop);
            teradataHadoop.description = "Run with Teradata connector for Hadoop";
            ret.add(teradataHadoop);
            RecipeEngineStatus bigQueryToGcs = new RecipeEngineStatus("BIGQUERY_TO_GCS", "BigQuery to GCS", null, null, "BigQuery to GCS");
            bigQueryToGcs.description = "Direct BigQuery to Google Cloud Storage";
            BigQueryToGCS.setCompatible(inputDataset, outputDataset, bigQueryToGcs, ro);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", bigQueryToGcs);
            }
            ret.add(bigQueryToGcs);
            RecipeEngineStatus s3ToSnowflake = new RecipeEngineStatus("S3_TO_SNOWFLAKE", "S3 to Snowflake", null, null, "S3 to Snowflake");
            s3ToSnowflake.description = "Direct S3 to Snowflake";
            S3ToSnowflake.setCompatible(inputDataset, outputDataset, s3ToSnowflake);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", s3ToSnowflake);
            }
            ret.add(s3ToSnowflake);
            RecipeEngineStatus snowflakeToS3 = new RecipeEngineStatus("SNOWFLAKE_TO_S3", "Snowflake to S3", null, null, "Snowflake to S3");
            snowflakeToS3.description = "Direct Snowflake to S3";
            SnowflakeToS3.setCompatible(inputDataset, outputDataset, snowflakeToS3);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", snowflakeToS3);
            }
            ret.add(snowflakeToS3);
            RecipeEngineStatus wasbToSnowflake = new RecipeEngineStatus("WASB_TO_SNOWFLAKE", "WASB to Snowflake", null, null, "WASB to Snowflake");
            wasbToSnowflake.description = "Direct WASB to Snowflake";
            WASBToSnowflake.setCompatible(inputDataset, outputDataset, wasbToSnowflake);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", wasbToSnowflake);
            }
            ret.add(wasbToSnowflake);
            RecipeEngineStatus snowflakeToWASB = new RecipeEngineStatus("SNOWFLAKE_TO_WASB", "Snowflake to WASB", null, null, "Snowflake to WASB");
            snowflakeToWASB.description = "Direct Snowflake to WASB";
            SnowflakeToWASB.setCompatible(inputDataset, outputDataset, snowflakeToWASB);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", snowflakeToWASB);
            }
            ret.add(snowflakeToWASB);
            RecipeEngineStatus gcsToSnowflake = new RecipeEngineStatus("GCS_TO_SNOWFLAKE", "GCS to Snowflake", null, null, "GCS to Snowflake");
            gcsToSnowflake.description = "Direct GCS to Snowflake";
            GcsToSnowflake.setCompatible(authCtx, inputDataset, outputDataset, gcsToSnowflake);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", gcsToSnowflake);
            }
            ret.add(gcsToSnowflake);
            RecipeEngineStatus snowflakeToGcs = new RecipeEngineStatus("SNOWFLAKE_TO_GCS", "Snowflake to GCS", null, null, "Snowflake to GCS");
            snowflakeToGcs.description = "Direct Snowflake to GCS";
            SnowflakeToGcs.setCompatible(authCtx, inputDataset, outputDataset, snowflakeToGcs);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", snowflakeToGcs);
            }
            ret.add(snowflakeToGcs);
            RecipeEngineStatus azureToDatabricks = new RecipeEngineStatus("AZURE_TO_DATABRICKS", "Azure to Databricks", null, null, "Azure to Databricks");
            azureToDatabricks.description = "Direct Azure to Databricks";
            AzureBlobToDatabricks.setCompatible(authCtx, inputDataset, outputDataset, azureToDatabricks);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", azureToDatabricks);
            }
            ret.add(azureToDatabricks);
            RecipeEngineStatus databricksToAzure = new RecipeEngineStatus("DATABRICKS_TO_AZURE", "Databricks to Azure", null, null, "Databricks to Azure");
            databricksToAzure.description = "Direct Azure to Databricks";
            DatabricksToAzureBlob.setCompatible(authCtx, inputDataset, outputDataset, databricksToAzure);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", databricksToAzure);
            }
            ret.add(databricksToAzure);
            RecipeEngineStatus s3ToDatabricks = new RecipeEngineStatus("S3_TO_DATABRICKS", "AWS S3 to Databricks", null, null, "S3 to Databricks");
            s3ToDatabricks.description = "Direct AWS S3 to Databricks";
            S3ToDatabricks.setCompatible(inputDataset, outputDataset, s3ToDatabricks);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", s3ToDatabricks);
            }
            ret.add(s3ToDatabricks);
            RecipeEngineStatus databricksToS3 = new RecipeEngineStatus("DATABRICKS_TO_S3", " Databricks to AWS S3", null, null, "Databricks to S3");
            databricksToS3.description = "Direct Databricks to AWS S3";
            DatabricksToS3.setCompatible(authCtx, inputDataset, outputDataset, databricksToS3);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", databricksToS3);
            }
            ret.add(databricksToS3);
            RecipeEngineStatus dbvolumeToDatabricks = new RecipeEngineStatus("DBVOLUME_TO_DATABRICKS", "Databricks volume to Databricks", null, null, "Databricks volume to Databricks");
            dbvolumeToDatabricks.description = "Direct Databricks volume to Databricks";
            DatabricksVolumeToDatabricks.setCompatible(inputDataset, outputDataset, dbvolumeToDatabricks);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", dbvolumeToDatabricks);
            }
            ret.add(dbvolumeToDatabricks);
            RecipeEngineStatus s3ToTrino = new RecipeEngineStatus("S3_TO_TRINO", "S3 to Trino", null, null, "S3 to Trino");
            s3ToTrino.description = "Direct S3 to Trino";
            S3ToTrino.setCompatible(authCtx, inputDataset, outputDataset, s3ToTrino);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", s3ToTrino);
            }
            ret.add(s3ToTrino);
            RecipeEngineStatus azureToTrino = new RecipeEngineStatus("AZURE_TO_TRINO", "Azure to Trino", null, null, "Azure to Trino");
            azureToTrino.description = "Direct Azure to Trino";
            AzureToTrino.setCompatible(authCtx, inputDataset, outputDataset, azureToTrino);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", azureToTrino);
            }
            ret.add(azureToTrino);
            RecipeEngineStatus gcsToTrino = new RecipeEngineStatus("GCS_TO_TRINO", "GCS to Trino", null, null, "GCS to Trino");
            gcsToTrino.description = "Direct GCS to Trino";
            GcsToTrino.setCompatible(authCtx, inputDataset, outputDataset, gcsToTrino);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", gcsToTrino);
            }
            ret.add(gcsToTrino);
            RecipeEngineStatus trinoToS3 = new RecipeEngineStatus("TRINO_TO_S3", "Trino to S3", null, null, "Trino to S3");
            trinoToS3.description = "Direct Trino to S3";
            TrinoToS3.setCompatible(authCtx, inputDataset, outputDataset, trinoToS3);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", trinoToS3);
            }
            ret.add(trinoToS3);
            RecipeEngineStatus trinoToAzure = new RecipeEngineStatus("TRINO_TO_AZURE", "Trino to Azure", null, null, "Trino to Azure");
            trinoToAzure.description = "Direct Trino to Azure";
            TrinoToAzure.setCompatible(authCtx, inputDataset, outputDataset, trinoToAzure);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", trinoToAzure);
            }
            ret.add(trinoToAzure);
            RecipeEngineStatus trinoToGcs = new RecipeEngineStatus("TRINO_TO_GCS", "Trino to GCS", null, null, "Trino to GCS");
            trinoToGcs.description = "Direct Trino to GCS";
            TrinoToGcs.setCompatible(authCtx, inputDataset, outputDataset, trinoToGcs);
            if (this.recipe.redispatchPartitioning) {
                RecipeEngineStatus.setErrorStatus("Not available with redispatch partitioning", trinoToGcs);
            }
            ret.add(trinoToGcs);
        } else if (output.getType() == FlowComputable.FCType.STREAMING_ENDPOINT) {
            RecipeEngineStatus dss = new RecipeEngineStatus("DSS", "DSS", null, null, "DSS");
            dss.description = "Run on DSS";
            dss.isSelectable = true;
            ret.add(dss);
            ret.add(new RecipeEngineStatus("S3_TO_REDSHIFT", "S3 to Redshift", null, null, "S3 to Redshift"));
            ret.add(new RecipeEngineStatus("HIVE", "Hive", null, null, "Hive"));
            ret.add(new RecipeEngineStatus("SPARK", "Spark", null, null, "Spark"));
        }
        return ret;
    }

    private RecipeEngineStatus selectEngine(AuthCtx authCtx, JobActivity activity, String userSelected, List<RecipeEngineStatus> statusList) throws IOException, DKUSecurityException {
        DatasetInspector.SQLAbleFlavor sqlFlavor;
        RecipeEnginesPreferenceConfig resolvedPrefs = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, null);
        HashMap<String, RecipeEngineStatus> enginesIndex = new HashMap<String, RecipeEngineStatus>();
        for (RecipeEngineStatus recipeEngineStatus : statusList) {
            enginesIndex.put(recipeEngineStatus.type, recipeEngineStatus);
        }
        List<String> forbiddenEngines = resolvedPrefs.getEffectiveForbidden(this.recipe.type);
        for (String forbidden : forbiddenEngines) {
            RecipeEngineStatus engine = (RecipeEngineStatus)enginesIndex.get(forbidden);
            if (engine == null) continue;
            engine.isSelectable = false;
            engine.statusWarnLevel = RecipeEngineStatus.WarningLevel.ERROR;
            engine.statusMessage = "Forbidden by configuration";
        }
        if (userSelected != null) {
            return RecipeEngineStatus.getByType(statusList, userSelected);
        }
        List<String> list2 = resolvedPrefs.getEffectivePreference(this.recipe.type);
        list2 = RecipeStatus.filterToActualEngines(list2, RecipeStatus.toEngineTypes(statusList));
        list2.add("S3_TO_REDSHIFT");
        list2.add("REDSHIFT_TO_S3");
        list2.add("S3_TO_SNOWFLAKE");
        list2.add("SNOWFLAKE_TO_S3");
        list2.add("WASB_TO_SNOWFLAKE");
        list2.add("SNOWFLAKE_TO_WASB");
        list2.add("GCS_TO_SNOWFLAKE");
        list2.add("SNOWFLAKE_TO_GCS");
        list2.add("AZURE_TO_DATABRICKS");
        list2.add("DATABRICKS_TO_AZURE");
        list2.add("S3_TO_DATABRICKS");
        list2.add("DATABRICKS_TO_S3");
        list2.add("DBVOLUME_TO_DATABRICKS");
        list2.add("AZURE_TO_TRINO");
        list2.add("TRINO_TO_AZURE");
        list2.add("S3_TO_TRINO");
        list2.add("TRINO_TO_S3");
        list2.add("GCS_TO_TRINO");
        list2.add("TRINO_TO_GCS");
        list2.add("AZURE_TO_SQLSERVER");
        list2.add("AZURE_TO_FABRIC");
        list2.add("GCS_TO_BIGQUERY");
        list2.add("BIGQUERY_TO_GCS");
        list2.add("SQL");
        list2.add("DSS");
        list2.add("HIVE");
        list2.add("SPARK");
        VisualSQLRecipesBaseService.SQLBasedEngineStatus sql = null;
        for (RecipeEngineStatus engine : statusList) {
            if (!engine.type.equals("SQL")) continue;
            sql = (VisualSQLRecipesBaseService.SQLBasedEngineStatus)engine;
        }
        if (sql != null && sql.isSelectable && (sqlFlavor = ServiceUtils.getSQLAbleFlavor(authCtx, activity, this.datasetsDAO)) != DatasetInspector.SQLAbleFlavor.REAL_SQL && sqlFlavor != DatasetInspector.SQLAbleFlavor.TRINO) {
            HashSet sqlEnginePref = Sets.newHashSet((Object[])new String[]{"SQL"});
            list2.removeAll(sqlEnginePref);
            list2.add("SQL");
        }
        for (String type : list2) {
            RecipeEngineStatus res = RecipeStatus.getEngineByTypeAllowNonExisting(statusList, type);
            if (res == null || !res.isSelectable || res.statusWarnLevel != RecipeEngineStatus.WarningLevel.OK) continue;
            return res;
        }
        return RecipeEngineStatus.getByType(statusList, "DSS");
    }

    private static class StatusInitializer {
        public JobActivity activity;
        public SQLDialect dialect;

        private StatusInitializer() {
        }
    }

    public static class SyncRecipeStatus
    extends VisualSQLRecipeStatus {
        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            return ret;
        }
    }
}

