/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.TrinoSupport;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.AbstractFSLikeDatasetHandler;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.TrinoSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QuerySQLWriter;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class TrinoToCloud<T extends BlobLikeDatasetHandler<?>>
extends SISORecipeExecutor {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.cloudtotrino");

    protected abstract String getPartitionRootPath(T var1, Partition var2) throws DKUSecurityException, CodedException, IOException;

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        TrinoSupport.CopyMode mode = TrinoSupport.getCopyMode(this.outputDS, false);
        try (AbstractSQLTableDatasetHandler dsh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.inputDS);
             BlobLikeDatasetHandler blobDShandler = (BlobLikeDatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.outputDS);){
            SQLConnectionProvider.SQLConnectionData connData = dsh.getConnectionData();
            SQLUtils.SQLTable inputTable = dsh.getResolvedTable();
            TrinoSQLDialect dialect = (TrinoSQLDialect)connData.getDialect();
            boolean isAppendMode = this.writeMode == Output.WriteMode.APPEND;
            SQLConnectionProvider.SQLConnectionWrapper connWrapper = dsh.newConnection();
            try {
                String inputTableName = blobDShandler.getDataset().getName() + "_" + SecretKeyGenerator.generate((int)8);
                SQLUtils.SQLTable temporaryOutputTable = new SQLUtils.SQLTable(inputTable.getCatalog(), inputTable.getSchemaNullIfBlank(), inputTableName);
                try {
                    this.makeTableForOutput(connData, connWrapper, temporaryOutputTable, blobDShandler, this.outputPartition, mode);
                    this.executeCopy(connData, connWrapper, dsh, inputTable, this.inputPartitions, blobDShandler, temporaryOutputTable, this.outputPartition, mode);
                }
                finally {
                    try {
                        dialect.dropTable(this.authCtx, connData, connWrapper, temporaryOutputTable);
                    }
                    catch (Exception e2) {
                        logger.warn((Object)"Failed to clear temporary table", (Throwable)e2);
                    }
                }
                try {
                    connWrapper.commit();
                }
                catch (Exception e) {
                    logger.warn((Object)("Commit doesn't work on this Trino connection : " + e.getMessage()));
                }
                connWrapper.close();
            }
            catch (Exception e) {
                logger.error((Object)"Trino unload failed", (Throwable)e);
                SQLUtils.unsafeRollbackAndClose(connWrapper);
                throw e;
            }
        }
    }

    private void executeCopy(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper connWrapper, AbstractSQLTableDatasetHandler inputDatasetHandler, SQLUtils.SQLTable inputTable, List<Partition> inputPartitions, T outputDatasetHandler, SQLUtils.SQLTable outputTable, Partition outputPartition, TrinoSupport.CopyMode mode) throws SQLException, IOException {
        TrinoSQLDialect dialect = (TrinoSQLDialect)connData.getDialect();
        ArrayList<String> sourceStatements = new ArrayList<String>();
        for (Partition inputPartition : inputPartitions) {
            sourceStatements.add(this.generateCopySourceStatement(connData, connWrapper, inputDatasetHandler, inputTable, inputPartition, outputDatasetHandler, outputTable, outputPartition, mode));
        }
        String insertStatement = String.format("INSERT INTO %s %s", dialect.getQuotedTableFullName(outputTable), sourceStatements.stream().collect(Collectors.joining("\nUNION ALL\n")));
        try (Statement stmt = connWrapper.createStatement();){
            SQLUtils.execute(connWrapper, stmt, insertStatement, insertStatement, false, true);
        }
    }

    private String generateCopySourceStatement(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper connWrapper, AbstractSQLTableDatasetHandler inputDatasetHandler, SQLUtils.SQLTable inputTable, Partition inputPartition, T outputDatasetHandler, SQLUtils.SQLTable outputTable, Partition outputPartition, TrinoSupport.CopyMode mode) throws SQLException, IOException {
        Object partitionFilter;
        TrinoSQLDialect dialect = (TrinoSQLDialect)connData.getDialect();
        Dataset inputDataset = inputDatasetHandler.getDataset();
        Dataset outputDataset = ((AbstractFSLikeDatasetHandler)outputDatasetHandler).getDataset();
        Schema inputSchema = inputDataset.getSchema();
        Schema outputSchema = outputDataset.getSchema();
        Map outputPartitionValues = outputPartition == null || outputPartition.isNP() ? new HashMap() : outputPartition.getDimensionValues();
        Map inputPartitionValues = inputPartition == null || inputPartition.isNP() ? new HashMap() : inputPartition.getDimensionValues();
        ArrayList<Object> inserted = new ArrayList<Object>();
        for (SchemaColumn outputColumn : outputSchema.getColumns()) {
            String value;
            SchemaColumn inputColumn = inputSchema.getColumn(outputColumn.getName());
            String quotedIdentifier = dialect.quoteIdentifier(outputColumn.getName());
            if (outputPartitionValues.containsKey(outputColumn.getName())) {
                value = ExpressionUtils.getStringForDimensionValue((DimensionValue)outputPartitionValues.get(outputColumn.getName()), outputColumn.getType());
                if (outputColumn.getType() == Type.DATE) {
                    inserted.add(dialect.quoteDate(value) + " AS " + quotedIdentifier);
                    continue;
                }
                if (outputColumn.getType() == Type.DATEONLY) {
                    inserted.add(dialect.quoteDateOnly(value) + " AS " + quotedIdentifier);
                    continue;
                }
                if (outputColumn.getType() == Type.DATETIMENOTZ) {
                    inserted.add(dialect.quoteDatetimeNoTz(value) + " AS " + quotedIdentifier);
                    continue;
                }
                inserted.add(dialect.quoteString(value) + " AS " + quotedIdentifier);
                continue;
            }
            if (inputColumn != null) {
                if (mode.type == TrinoSupport.CopyMode.CopyModeType.CSV || mode.type == TrinoSupport.CopyMode.CopyModeType.TEXTFILE) {
                    inserted.add("CAST(" + quotedIdentifier + " AS VARCHAR) AS " + quotedIdentifier);
                    continue;
                }
                inserted.add(quotedIdentifier);
                continue;
            }
            if (inputPartitionValues.containsKey(outputColumn.getName())) {
                value = ExpressionUtils.getStringForDimensionValue((DimensionValue)inputPartition.getDimensionValues().get(outputColumn.getName()), outputColumn.getType());
                if (outputColumn.getType() == Type.DATE) {
                    inserted.add(dialect.quoteDate(value) + " AS " + quotedIdentifier);
                    continue;
                }
                if (outputColumn.getType() == Type.DATEONLY) {
                    inserted.add(dialect.quoteDateOnly(value) + " AS " + quotedIdentifier);
                    continue;
                }
                if (outputColumn.getType() == Type.DATETIMENOTZ) {
                    inserted.add(dialect.quoteDatetimeNoTz(value) + " AS " + quotedIdentifier);
                    continue;
                }
                inserted.add(dialect.quoteString(value) + " AS " + quotedIdentifier);
                continue;
            }
            String partitionId = inputPartition != null ? " (partition id=" + inputPartition.id() + ")" : "";
            String dims = " (partition dims = " + inputPartitionValues.keySet().stream().collect(Collectors.joining(", ")) + ")";
            throw new IOException("Input dataset cannot provide values for column " + outputColumn.getName() + partitionId + dims);
        }
        if (inputPartition != null && !inputPartition.isNP()) {
            ExpressionBuilder expr = ExpressionUtils.getPartitionFilterClause(inputDataset.getPartitioningSchema(), inputDataset, inputPartition, (SQLDialect)dialect);
            partitionFilter = "WHERE " + new QuerySQLWriter(dialect).toSQL(expr.expr);
        } else {
            partitionFilter = "";
        }
        return String.format("SELECT %s FROM %s %s", inserted.stream().collect(Collectors.joining(", ")), dialect.getQuotedTableFullName(inputTable), partitionFilter);
    }

    private void makeTableForOutput(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper connWrapper, SQLUtils.SQLTable outputTable, T datasetHandler, Partition partition, TrinoSupport.CopyMode mode) throws CodedException, IOException, DKUSecurityException, SQLException {
        Dataset dataset = ((AbstractFSLikeDatasetHandler)datasetHandler).getDataset();
        String inputRootPath = this.getPartitionRootPath(datasetHandler, partition);
        TrinoSQLDialect dialect = (TrinoSQLDialect)connData.getDialect();
        String copyOptions = mode.generateFormatOptions();
        List columnsList = mode.type == TrinoSupport.CopyMode.CopyModeType.CSV || mode.type == TrinoSupport.CopyMode.CopyModeType.TEXTFILE ? dataset.getSchema().getColumns().stream().map(sc -> dialect.quoteIdentifier(sc.getName()) + " varchar").collect(Collectors.toList()) : dataset.getSchema().getColumns().stream().map(sc -> dialect.quoteIdentifier(sc.getName()) + " " + String.valueOf(dialect.getSQLType((SchemaColumn)sc, dataset))).collect(Collectors.toList());
        String createTableStatement = String.format("CREATE TABLE %s (%s) WITH (external_location='%s' %s)", dialect.getQuotedTableFullName(outputTable), columnsList.stream().collect(Collectors.joining(", ")), inputRootPath, StringUtils.isBlank((String)copyOptions) ? "" : ", " + copyOptions);
        try (Statement stmt = connWrapper.createStatement();){
            SQLUtils.execute(connWrapper, stmt, createTableStatement, createTableStatement, false, true);
        }
        catch (Exception e) {
            if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"External location must be a directory:")) {
                throw new SQLException("Trino connector doesn't have writes to non-managed tables activated", e);
            }
            throw e;
        }
    }
}

