/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudToSnowflake;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.SnowflakeToCloud;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class WASBToSnowflake
extends CloudToSnowflake<AzureBlobDatasetHandler> {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.wasbtosnowflake");

    public WASBToSnowflake() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) {
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(outputDS);
        status.isSelectable = true;
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(inputDS, "Azure")) {
            status.markAsNonSelectable("Input dataset is not in WASB", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        if (outputMeta != BuiltinSQLDatasets.SNOWFLAKE_META) {
            status.markAsNonSelectable("Output dataset is not in Snowflake", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        try {
            SnowflakeToCloud.getCopyMode(inputDS, true);
        }
        catch (SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    protected String getRootPath(AzureBlobDatasetHandler blobDShandler) throws DKUSecurityException, CodedException, IOException {
        return blobDShandler.getRootPathForSnowflakeFastPath();
    }

    @Override
    protected String generateCopyStatementFromCloud(String outputTableFullName, String inputRootPath, String specifiedFilePaths, CloudToSnowflake.CopyMode mode, AzureBlobDatasetHandler blobDShandler, boolean append, StringBuilder displayableSql) throws DKUSecurityException, IOException {
        String displayCreds;
        String creds;
        AzureConnection azure = blobDShandler.getConnection();
        if (StringUtils.isEmpty((String)azure.params.sasToken) && StringUtils.isEmpty((String)azure.params.snowflakeStorageIntegration) && !inputRootPath.startsWith("@")) {
            throw new SnowflakeToCloud.SnowflakeCloudFastpathImpossibleException(String.format("Cannot generate fastpath statement: SAS token, external stage, or storage integration is not defined for connection: %s", azure.name));
        }
        if (inputRootPath.startsWith("@")) {
            creds = "";
            displayCreds = "";
        } else if (StringUtils.isNotBlank((String)azure.params.snowflakeStorageIntegration)) {
            SnowflakeSQLDialect dialect = new SnowflakeSQLDialect();
            displayCreds = creds = String.format("   STORAGE_INTEGRATION=%s", dialect.quoteIdentifier(azure.params.snowflakeStorageIntegration));
        } else {
            AzureConnection.SerializableAzureStorageAccountCredentials azureCreds = azure.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, this.contextProjectKey), AzureConnection.SerializableAzureStorageAccountCredentials.class);
            creds = String.format("   CREDENTIALS=(azure_sas_token='%s')", azureCreds.sasToken);
            displayCreds = "   CREDENTIALS=(****)";
        }
        String copyQueryPattern = "COPY INTO %s FROM '%s'   %s   FILE_FORMAT = (%s " + mode.generateSnowflakeParquetLogicalTypes() + " )   FORCE=%s   %s";
        if (StringUtils.isNotBlank((String)specifiedFilePaths)) {
            copyQueryPattern = copyQueryPattern + "   FILES = (" + specifiedFilePaths + ")";
        }
        String formatOptions = mode.generateFormatOptions();
        String commonOptions = mode.generateToSnowflakeCommonOptions();
        String displaySql = String.format(copyQueryPattern, outputTableFullName, inputRootPath, commonOptions, formatOptions, append ? "true" : "false", displayCreds);
        displayableSql.append(displaySql);
        return String.format(copyQueryPattern, outputTableFullName, inputRootPath, commonOptions, formatOptions, append ? "true" : "false", creds);
    }
}

